/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.ipmessaging.v2.service.user.UserChannelFetcher;
import com.twilio.rest.ipmessaging.v2.service.user.UserChannelReader;
import com.twilio.rest.ipmessaging.v2.service.user.UserChannelUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UserChannel
extends Resource {
    private static final long serialVersionUID = 97342858560464L;
    private final String accountSid;
    private final String serviceSid;
    private final String channelSid;
    private final String userSid;
    private final String memberSid;
    private final ChannelStatus status;
    private final Integer lastConsumedMessageIndex;
    private final Integer unreadMessagesCount;
    private final Map<String, String> links;
    private final URI url;
    private final NotificationLevel notificationLevel;

    public static UserChannelReader reader(String pathServiceSid, String pathUserSid) {
        return new UserChannelReader(pathServiceSid, pathUserSid);
    }

    public static UserChannelFetcher fetcher(String pathServiceSid, String pathUserSid, String pathChannelSid) {
        return new UserChannelFetcher(pathServiceSid, pathUserSid, pathChannelSid);
    }

    public static UserChannelUpdater updater(String pathServiceSid, String pathUserSid, String pathChannelSid, NotificationLevel notificationLevel) {
        return new UserChannelUpdater(pathServiceSid, pathUserSid, pathChannelSid, notificationLevel);
    }

    public static UserChannel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UserChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static UserChannel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, UserChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private UserChannel(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="channel_sid") String channelSid, @JsonProperty(value="user_sid") String userSid, @JsonProperty(value="member_sid") String memberSid, @JsonProperty(value="status") ChannelStatus status, @JsonProperty(value="last_consumed_message_index") Integer lastConsumedMessageIndex, @JsonProperty(value="unread_messages_count") Integer unreadMessagesCount, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="url") URI url, @JsonProperty(value="notification_level") NotificationLevel notificationLevel) {
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.channelSid = channelSid;
        this.userSid = userSid;
        this.memberSid = memberSid;
        this.status = status;
        this.lastConsumedMessageIndex = lastConsumedMessageIndex;
        this.unreadMessagesCount = unreadMessagesCount;
        this.links = links;
        this.url = url;
        this.notificationLevel = notificationLevel;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getChannelSid() {
        return this.channelSid;
    }

    public final String getUserSid() {
        return this.userSid;
    }

    public final String getMemberSid() {
        return this.memberSid;
    }

    public final ChannelStatus getStatus() {
        return this.status;
    }

    public final Integer getLastConsumedMessageIndex() {
        return this.lastConsumedMessageIndex;
    }

    public final Integer getUnreadMessagesCount() {
        return this.unreadMessagesCount;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final NotificationLevel getNotificationLevel() {
        return this.notificationLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserChannel other = (UserChannel)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.channelSid, other.channelSid) && Objects.equals(this.userSid, other.userSid) && Objects.equals(this.memberSid, other.memberSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.lastConsumedMessageIndex, other.lastConsumedMessageIndex) && Objects.equals(this.unreadMessagesCount, other.unreadMessagesCount) && Objects.equals(this.links, other.links) && Objects.equals(this.url, other.url) && Objects.equals((Object)this.notificationLevel, (Object)other.notificationLevel);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.serviceSid, this.channelSid, this.userSid, this.memberSid, this.status, this.lastConsumedMessageIndex, this.unreadMessagesCount, this.links, this.url, this.notificationLevel});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("serviceSid", this.serviceSid).add("channelSid", this.channelSid).add("userSid", this.userSid).add("memberSid", this.memberSid).add("status", (Object)this.status).add("lastConsumedMessageIndex", this.lastConsumedMessageIndex).add("unreadMessagesCount", this.unreadMessagesCount).add("links", this.links).add("url", this.url).add("notificationLevel", (Object)this.notificationLevel).toString();
    }

    public static enum NotificationLevel {
        DEFAULT("default"),
        MUTED("muted");

        private final String value;

        private NotificationLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static NotificationLevel forValue(String value) {
            return (NotificationLevel)Promoter.enumFromString((String)value, (Enum[])NotificationLevel.values());
        }
    }

    public static enum ChannelStatus {
        JOINED("joined"),
        INVITED("invited"),
        NOT_PARTICIPATING("not_participating");

        private final String value;

        private ChannelStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ChannelStatus forValue(String value) {
            return (ChannelStatus)Promoter.enumFromString((String)value, (Enum[])ChannelStatus.values());
        }
    }
}

