/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.fax.v1.fax;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.fax.v1.fax.FaxMediaDeleter;
import com.twilio.rest.fax.v1.fax.FaxMediaFetcher;
import com.twilio.rest.fax.v1.fax.FaxMediaReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FaxMedia
extends Resource {
    private static final long serialVersionUID = 8543753722336L;
    private final String sid;
    private final String accountSid;
    private final String faxSid;
    private final String contentType;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static FaxMediaFetcher fetcher(String pathFaxSid, String pathSid) {
        return new FaxMediaFetcher(pathFaxSid, pathSid);
    }

    public static FaxMediaReader reader(String pathFaxSid) {
        return new FaxMediaReader(pathFaxSid);
    }

    public static FaxMediaDeleter deleter(String pathFaxSid, String pathSid) {
        return new FaxMediaDeleter(pathFaxSid, pathSid);
    }

    public static FaxMedia fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FaxMedia.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static FaxMedia fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, FaxMedia.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private FaxMedia(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="fax_sid") String faxSid, @JsonProperty(value="content_type") String contentType, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.faxSid = faxSid;
        this.contentType = contentType;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFaxSid() {
        return this.faxSid;
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FaxMedia other = (FaxMedia)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.faxSid, other.faxSid) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.faxSid, this.contentType, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("faxSid", this.faxSid).add("contentType", this.contentType).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).toString();
    }
}

