/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.authy.v1;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.authy.v1.Service;

public class ServiceFetcher
extends Fetcher<Service> {
    private final String pathSid;

    public ServiceFetcher(String pathSid) {
        this.pathSid = pathSid;
    }

    @Override
    public Service fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.AUTHY.toString(), "/v1/Services/" + this.pathSid + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }
}

