/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.usage;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.usage.Trigger;
import java.net.URI;

public class TriggerUpdater
extends Updater<Trigger> {
    private String pathAccountSid;
    private final String pathSid;
    private HttpMethod callbackMethod;
    private URI callbackUrl;
    private String friendlyName;

    public TriggerUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public TriggerUpdater(String pathAccountSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
    }

    public TriggerUpdater setCallbackMethod(HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public TriggerUpdater setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public TriggerUpdater setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public TriggerUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    @Override
    public Trigger update(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Usage/Triggers/" + this.pathSid + ".json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Trigger update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Trigger.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod.toString());
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
    }
}

