/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.availablephonenumbercountry;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.availablephonenumbercountry.Voip;
import com.twilio.type.PhoneNumber;

public class VoipReader
extends Reader<Voip> {
    private String pathAccountSid;
    private final String pathCountryCode;
    private Integer areaCode;
    private String contains;
    private Boolean smsEnabled;
    private Boolean mmsEnabled;
    private Boolean voiceEnabled;
    private Boolean excludeAllAddressRequired;
    private Boolean excludeLocalAddressRequired;
    private Boolean excludeForeignAddressRequired;
    private Boolean beta;
    private PhoneNumber nearNumber;
    private String nearLatLong;
    private Integer distance;
    private String inPostalCode;
    private String inRegion;
    private String inRateCenter;
    private String inLata;
    private String inLocality;
    private Boolean faxEnabled;

    public VoipReader(String pathCountryCode) {
        this.pathCountryCode = pathCountryCode;
    }

    public VoipReader(String pathAccountSid, String pathCountryCode) {
        this.pathAccountSid = pathAccountSid;
        this.pathCountryCode = pathCountryCode;
    }

    public VoipReader setAreaCode(Integer areaCode) {
        this.areaCode = areaCode;
        return this;
    }

    public VoipReader setContains(String contains) {
        this.contains = contains;
        return this;
    }

    public VoipReader setSmsEnabled(Boolean smsEnabled) {
        this.smsEnabled = smsEnabled;
        return this;
    }

    public VoipReader setMmsEnabled(Boolean mmsEnabled) {
        this.mmsEnabled = mmsEnabled;
        return this;
    }

    public VoipReader setVoiceEnabled(Boolean voiceEnabled) {
        this.voiceEnabled = voiceEnabled;
        return this;
    }

    public VoipReader setExcludeAllAddressRequired(Boolean excludeAllAddressRequired) {
        this.excludeAllAddressRequired = excludeAllAddressRequired;
        return this;
    }

    public VoipReader setExcludeLocalAddressRequired(Boolean excludeLocalAddressRequired) {
        this.excludeLocalAddressRequired = excludeLocalAddressRequired;
        return this;
    }

    public VoipReader setExcludeForeignAddressRequired(Boolean excludeForeignAddressRequired) {
        this.excludeForeignAddressRequired = excludeForeignAddressRequired;
        return this;
    }

    public VoipReader setBeta(Boolean beta) {
        this.beta = beta;
        return this;
    }

    public VoipReader setNearNumber(PhoneNumber nearNumber) {
        this.nearNumber = nearNumber;
        return this;
    }

    public VoipReader setNearNumber(String nearNumber) {
        return this.setNearNumber(Promoter.phoneNumberFromString(nearNumber));
    }

    public VoipReader setNearLatLong(String nearLatLong) {
        this.nearLatLong = nearLatLong;
        return this;
    }

    public VoipReader setDistance(Integer distance) {
        this.distance = distance;
        return this;
    }

    public VoipReader setInPostalCode(String inPostalCode) {
        this.inPostalCode = inPostalCode;
        return this;
    }

    public VoipReader setInRegion(String inRegion) {
        this.inRegion = inRegion;
        return this;
    }

    public VoipReader setInRateCenter(String inRateCenter) {
        this.inRateCenter = inRateCenter;
        return this;
    }

    public VoipReader setInLata(String inLata) {
        this.inLata = inLata;
        return this;
    }

    public VoipReader setInLocality(String inLocality) {
        this.inLocality = inLocality;
        return this;
    }

    public VoipReader setFaxEnabled(Boolean faxEnabled) {
        this.faxEnabled = faxEnabled;
        return this;
    }

    @Override
    public ResourceSet<Voip> read(TwilioRestClient client) {
        return new ResourceSet<Voip>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Voip> firstPage(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/AvailablePhoneNumbers/" + this.pathCountryCode + "/Voip.json", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Voip> getPage(String targetUrl, TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Voip> nextPage(Page<Voip> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Voip> previousPage(Page<Voip> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.API.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Voip> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Voip read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("available_phone_numbers", response.getContent(), Voip.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.areaCode != null) {
            request.addQueryParam("AreaCode", this.areaCode.toString());
        }
        if (this.contains != null) {
            request.addQueryParam("Contains", this.contains);
        }
        if (this.smsEnabled != null) {
            request.addQueryParam("SmsEnabled", this.smsEnabled.toString());
        }
        if (this.mmsEnabled != null) {
            request.addQueryParam("MmsEnabled", this.mmsEnabled.toString());
        }
        if (this.voiceEnabled != null) {
            request.addQueryParam("VoiceEnabled", this.voiceEnabled.toString());
        }
        if (this.excludeAllAddressRequired != null) {
            request.addQueryParam("ExcludeAllAddressRequired", this.excludeAllAddressRequired.toString());
        }
        if (this.excludeLocalAddressRequired != null) {
            request.addQueryParam("ExcludeLocalAddressRequired", this.excludeLocalAddressRequired.toString());
        }
        if (this.excludeForeignAddressRequired != null) {
            request.addQueryParam("ExcludeForeignAddressRequired", this.excludeForeignAddressRequired.toString());
        }
        if (this.beta != null) {
            request.addQueryParam("Beta", this.beta.toString());
        }
        if (this.nearNumber != null) {
            request.addQueryParam("NearNumber", this.nearNumber.toString());
        }
        if (this.nearLatLong != null) {
            request.addQueryParam("NearLatLong", this.nearLatLong);
        }
        if (this.distance != null) {
            request.addQueryParam("Distance", this.distance.toString());
        }
        if (this.inPostalCode != null) {
            request.addQueryParam("InPostalCode", this.inPostalCode);
        }
        if (this.inRegion != null) {
            request.addQueryParam("InRegion", this.inRegion);
        }
        if (this.inRateCenter != null) {
            request.addQueryParam("InRateCenter", this.inRateCenter);
        }
        if (this.inLata != null) {
            request.addQueryParam("InLata", this.inLata);
        }
        if (this.inLocality != null) {
            request.addQueryParam("InLocality", this.inLocality);
        }
        if (this.faxEnabled != null) {
            request.addQueryParam("FaxEnabled", this.faxEnabled.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

