/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.accounts.v1.credential;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.accounts.v1.credential.PublicKey;

public class PublicKeyReader
extends Reader<PublicKey> {
    @Override
    public ResourceSet<PublicKey> read(TwilioRestClient client) {
        return new ResourceSet<PublicKey>(this, client, this.firstPage(client));
    }

    @Override
    public Page<PublicKey> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.ACCOUNTS.toString(), "/v1/Credentials/PublicKeys", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PublicKey> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PublicKey> nextPage(Page<PublicKey> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.ACCOUNTS.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<PublicKey> previousPage(Page<PublicKey> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.ACCOUNTS.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<PublicKey> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("PublicKey read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("credentials", response.getContent(), PublicKey.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

