/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.unitsofmeasurement.indriya.columnmapper;

import javax.measure.Quantity;
import javax.measure.Unit;
import org.jadira.usertype.spi.shared.AbstractLongColumnMapper;
import org.jadira.usertype.unitsofmeasurement.indriya.util.UnitConfigured;
import tec.units.indriya.ComparableQuantity;
import tec.units.indriya.quantity.Quantities;

public class LongColumnQuantityMapper<Q extends Quantity<Q>>
extends AbstractLongColumnMapper<Q>
implements UnitConfigured<Q> {
    private static final long serialVersionUID = 4205713919952452881L;
    private Unit<Q> unit;

    public Q fromNonNullValue(Long val) {
        ComparableQuantity result = Quantities.getQuantity((Number)val, this.unit);
        return (Q)result;
    }

    public Long toNonNullValue(Q value) {
        if (!this.unit.getClass().isAssignableFrom(value.getUnit().getClass())) {
            throw new IllegalStateException("Expected unit " + this.unit + " but was " + value.getUnit());
        }
        return Long.parseLong(value.getValue().toString());
    }

    public Q fromNonNullString(String s) {
        ComparableQuantity quantity = Quantities.getQuantity((CharSequence)s);
        if (!this.unit.getClass().isAssignableFrom(quantity.getUnit().getClass())) {
            throw new IllegalStateException("Expected unit " + this.unit + " but was " + quantity.getUnit());
        }
        return (Q)quantity;
    }

    public String toNonNullString(Q value) {
        if (!this.unit.getClass().isAssignableFrom(value.getUnit().getClass())) {
            throw new IllegalStateException("Expected unit " + this.unit + " but was " + value.getUnit());
        }
        return value.toString();
    }

    @Override
    public void setUnit(Unit<Q> unit) {
        this.unit = unit;
    }
}

