/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.math.BigInteger;
import java.time.Instant;
import org.jadira.usertype.spi.shared.AbstractVersionableBigIntegerColumnMapper;

public class BigIntegerColumnInstantMapper
extends AbstractVersionableBigIntegerColumnMapper<Instant> {
    private static final long serialVersionUID = 2647692721818989190L;
    private static final BigInteger NANOS_IN_MILLI = BigInteger.valueOf(1000000L);
    private static final BigInteger MILLIS_IN_SECOND = BigInteger.valueOf(1000L);

    public Instant fromNonNullString(String s) {
        return Instant.parse(s);
    }

    public Instant fromNonNullValue(BigInteger value) {
        BigInteger[] milliAndNanoPart = value.divideAndRemainder(NANOS_IN_MILLI);
        Instant result = Instant.ofEpochMilli(milliAndNanoPart[0].longValue());
        return result.plusNanos(milliAndNanoPart[1].longValue());
    }

    public String toNonNullString(Instant value) {
        return value.toString();
    }

    public BigInteger toNonNullValue(Instant value) {
        BigInteger result = BigInteger.valueOf(value.getEpochSecond()).multiply(NANOS_IN_MILLI).multiply(MILLIS_IN_SECOND);
        return result.add(BigInteger.valueOf(value.getNano()));
    }
}

