/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import org.jadira.usertype.spi.shared.AbstractStringColumnMapper;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class StringColumnDateTimeMapper
extends AbstractStringColumnMapper<DateTime> {
    private static final long serialVersionUID = -2548824513686423324L;
    private static final DateTimeFormatter DATE_TIME_PARSER = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).appendLiteral('T').append(ISODateTimeFormat.hourMinuteSecondFraction()).appendLiteral('_').appendTimeZoneId().toFormatter();
    private static final DateTimeFormatter DATE_TIME_PRINTER_PREFIX = new DateTimeFormatterBuilder().append(ISODateTimeFormat.yearMonth()).appendLiteral("-").toFormatter();
    private static final DateTimeFormatter DATE_TIME_PRINTER_SUFFIX = new DateTimeFormatterBuilder().appendLiteral('T').append(ISODateTimeFormat.hourMinuteSecondFraction()).appendLiteral('_').appendTimeZoneId().toFormatter();

    public DateTime fromNonNullValue(String s) {
        DateTime parsedDateTime = DATE_TIME_PARSER.parseDateTime(s);
        DateTimeZone correctTimeZone = parsedDateTime.getZone();
        DateTime utcDateTime = parsedDateTime.withZoneRetainFields(DateTimeZone.UTC);
        DateTime correctedDateTime = utcDateTime.withZone(correctTimeZone);
        return correctedDateTime;
    }

    public String toNonNullValue(DateTime value) {
        DateTimeZone correctTimeZone = value.getZone();
        DateTime utcDateTime = value.withZone(DateTimeZone.UTC);
        DateTime utcDateTimeWithCorrectTimeZone = utcDateTime.withZoneRetainFields(correctTimeZone);
        int dayOfMonth = utcDateTimeWithCorrectTimeZone.getDayOfMonth();
        String dateTimeAsString = DATE_TIME_PRINTER_PREFIX.print((ReadableInstant)utcDateTimeWithCorrectTimeZone);
        if (dayOfMonth < 10) {
            dateTimeAsString = dateTimeAsString + "0";
        }
        dateTimeAsString = dateTimeAsString + dayOfMonth;
        dateTimeAsString = dateTimeAsString + DATE_TIME_PRINTER_SUFFIX.print((ReadableInstant)utcDateTimeWithCorrectTimeZone);
        return dateTimeAsString;
    }
}

