/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda;

import org.jadira.usertype.dateandtime.joda.columnmapper.StringColumnDateTimeZoneWithOffsetMapper;
import org.jadira.usertype.dateandtime.joda.columnmapper.TimestampColumnLocalDateTimeMapper;
import org.jadira.usertype.dateandtime.joda.util.DateTimeZoneWithOffset;
import org.jadira.usertype.spi.shared.AbstractParameterizedTemporalMultiColumnUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.utils.reflection.ArrayUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;

public class PersistentDateTimeAndZoneWithOffset
extends AbstractParameterizedTemporalMultiColumnUserType<DateTime> {
    private static final long serialVersionUID = 1364221029392346011L;
    private static final ColumnMapper<?, ?>[] COLUMN_MAPPERS = new ColumnMapper[]{new TimestampColumnLocalDateTimeMapper(), new StringColumnDateTimeZoneWithOffsetMapper()};
    private static final String[] PROPERTY_NAMES = new String[]{"datetime", "offset"};

    protected ColumnMapper<?, ?>[] getColumnMappers() {
        return COLUMN_MAPPERS;
    }

    public String[] getPropertyNames() {
        return (String[])ArrayUtils.copyOf((Object[])PROPERTY_NAMES);
    }

    protected DateTime fromConvertedColumns(Object[] convertedColumns) {
        LocalDateTime datePart = (LocalDateTime)convertedColumns[0];
        DateTimeZoneWithOffset offset = (DateTimeZoneWithOffset)convertedColumns[1];
        DateTime result = datePart == null ? null : datePart.toDateTime(offset.getStandardDateTimeZone());
        if (result != null && offset.getOffsetDateTimeZone() != null && offset.getStandardDateTimeZone().getOffset((ReadableInstant)result) > offset.getOffsetDateTimeZone().getOffset((ReadableInstant)result)) {
            return result.withLaterOffsetAtOverlap();
        }
        return result;
    }

    protected Object[] toConvertedColumns(DateTime value) {
        return new Object[]{value.toLocalDateTime(), new DateTimeZoneWithOffset(value.getZone(), value.getZone().isFixed() ? null : DateTimeZone.forOffsetMillis((int)value.getZone().getOffset((ReadableInstant)value)))};
    }
}

