/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room.participant;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.room.participant.SubscribedTrack;
import org.joda.time.DateTime;

public class SubscribedTrackReader
extends Reader<SubscribedTrack> {
    private final String pathRoomSid;
    private final String pathSubscriberSid;
    private DateTime dateCreatedAfter;
    private DateTime dateCreatedBefore;
    private String track;
    private String publisher;
    private SubscribedTrack.Kind kind;

    public SubscribedTrackReader(String pathRoomSid, String pathSubscriberSid) {
        this.pathRoomSid = pathRoomSid;
        this.pathSubscriberSid = pathSubscriberSid;
    }

    public SubscribedTrackReader setDateCreatedAfter(DateTime dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    public SubscribedTrackReader setDateCreatedBefore(DateTime dateCreatedBefore) {
        this.dateCreatedBefore = dateCreatedBefore;
        return this;
    }

    public SubscribedTrackReader setTrack(String track) {
        this.track = track;
        return this;
    }

    public SubscribedTrackReader setPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public SubscribedTrackReader setKind(SubscribedTrack.Kind kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public ResourceSet<SubscribedTrack> read(TwilioRestClient client) {
        return new ResourceSet<SubscribedTrack>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SubscribedTrack> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VIDEO.toString(), "/v1/Rooms/" + this.pathRoomSid + "/Participants/" + this.pathSubscriberSid + "/SubscribedTracks", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SubscribedTrack> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SubscribedTrack> nextPage(Page<SubscribedTrack> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VIDEO.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SubscribedTrack> previousPage(Page<SubscribedTrack> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VIDEO.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<SubscribedTrack> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SubscribedTrack read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("subscribed_tracks", response.getContent(), SubscribedTrack.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.dateCreatedAfter != null) {
            request.addQueryParam("DateCreatedAfter", this.dateCreatedAfter.toString());
        }
        if (this.dateCreatedBefore != null) {
            request.addQueryParam("DateCreatedBefore", this.dateCreatedBefore.toString());
        }
        if (this.track != null) {
            request.addQueryParam("Track", this.track.toString());
        }
        if (this.publisher != null) {
            request.addQueryParam("Publisher", this.publisher.toString());
        }
        if (this.kind != null) {
            request.addQueryParam("Kind", this.kind.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

