/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room.participant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.video.v1.room.participant.SubscribedTrackReader;
import com.twilio.rest.video.v1.room.participant.SubscribedTrackUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SubscribedTrack
extends Resource {
    private static final long serialVersionUID = 222272126385904L;
    private final String sid;
    private final String roomSid;
    private final String name;
    private final String publisherSid;
    private final String subscriberSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Boolean enabled;
    private final Kind kind;

    public static SubscribedTrackReader reader(String pathRoomSid, String pathSubscriberSid) {
        return new SubscribedTrackReader(pathRoomSid, pathSubscriberSid);
    }

    public static SubscribedTrackUpdater updater(String pathRoomSid, String pathSubscriberSid) {
        return new SubscribedTrackUpdater(pathRoomSid, pathSubscriberSid);
    }

    public static SubscribedTrack fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SubscribedTrack.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SubscribedTrack fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, SubscribedTrack.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SubscribedTrack(@JsonProperty(value="sid") String sid, @JsonProperty(value="room_sid") String roomSid, @JsonProperty(value="name") String name, @JsonProperty(value="publisher_sid") String publisherSid, @JsonProperty(value="subscriber_sid") String subscriberSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="kind") Kind kind) {
        this.sid = sid;
        this.roomSid = roomSid;
        this.name = name;
        this.publisherSid = publisherSid;
        this.subscriberSid = subscriberSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.enabled = enabled;
        this.kind = kind;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getRoomSid() {
        return this.roomSid;
    }

    public final String getName() {
        return this.name;
    }

    public final String getPublisherSid() {
        return this.publisherSid;
    }

    public final String getSubscriberSid() {
        return this.subscriberSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Boolean getEnabled() {
        return this.enabled;
    }

    public final Kind getKind() {
        return this.kind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscribedTrack other = (SubscribedTrack)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.roomSid, other.roomSid) && Objects.equals(this.name, other.name) && Objects.equals(this.publisherSid, other.publisherSid) && Objects.equals(this.subscriberSid, other.subscriberSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.enabled, other.enabled) && Objects.equals((Object)this.kind, (Object)other.kind);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.roomSid, this.name, this.publisherSid, this.subscriberSid, this.dateCreated, this.dateUpdated, this.enabled, this.kind});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("roomSid", this.roomSid).add("name", this.name).add("publisherSid", this.publisherSid).add("subscriberSid", this.subscriberSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("enabled", this.enabled).add("kind", (Object)this.kind).toString();
    }

    public static enum Status {
        SUBSCRIBE("subscribe"),
        UNSUBSCRIBE("unsubscribe");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Kind {
        AUDIO("audio"),
        VIDEO("video"),
        DATA("data");

        private final String value;

        private Kind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Kind forValue(String value) {
            return (Kind)Promoter.enumFromString((String)value, (Enum[])Kind.values());
        }
    }
}

