/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.room.Participant;

public class ParticipantUpdater
extends Updater<Participant> {
    private final String pathRoomSid;
    private final String pathSid;
    private Participant.Status status;

    public ParticipantUpdater(String pathRoomSid, String pathSid) {
        this.pathRoomSid = pathRoomSid;
        this.pathSid = pathSid;
    }

    public ParticipantUpdater setStatus(Participant.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public Participant update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VIDEO.toString(), "/v1/Rooms/" + this.pathRoomSid + "/Participants/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

