/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.video.v1.RoomCreator;
import com.twilio.rest.video.v1.RoomFetcher;
import com.twilio.rest.video.v1.RoomReader;
import com.twilio.rest.video.v1.RoomUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Room
extends Resource {
    private static final long serialVersionUID = 123703237879933L;
    private final String sid;
    private final RoomStatus status;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String accountSid;
    private final Boolean enableTurn;
    private final String uniqueName;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final DateTime endTime;
    private final Integer duration;
    private final RoomType type;
    private final Integer maxParticipants;
    private final Boolean recordParticipantsOnConnect;
    private final List<VideoCodec> videoCodecs;
    private final String mediaRegion;
    private final URI url;
    private final Map<String, String> links;

    public static RoomFetcher fetcher(String pathSid) {
        return new RoomFetcher(pathSid);
    }

    public static RoomCreator creator() {
        return new RoomCreator();
    }

    public static RoomReader reader() {
        return new RoomReader();
    }

    public static RoomUpdater updater(String pathSid, RoomStatus status) {
        return new RoomUpdater(pathSid, status);
    }

    public static Room fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Room.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Room fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Room.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Room(@JsonProperty(value="sid") String sid, @JsonProperty(value="status") RoomStatus status, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="enable_turn") Boolean enableTurn, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="status_callback_method") HttpMethod statusCallbackMethod, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="duration") Integer duration, @JsonProperty(value="type") RoomType type, @JsonProperty(value="max_participants") Integer maxParticipants, @JsonProperty(value="record_participants_on_connect") Boolean recordParticipantsOnConnect, @JsonProperty(value="video_codecs") List<VideoCodec> videoCodecs, @JsonProperty(value="media_region") String mediaRegion, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.status = status;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.accountSid = accountSid;
        this.enableTurn = enableTurn;
        this.uniqueName = uniqueName;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.endTime = DateConverter.iso8601DateTimeFromString(endTime);
        this.duration = duration;
        this.type = type;
        this.maxParticipants = maxParticipants;
        this.recordParticipantsOnConnect = recordParticipantsOnConnect;
        this.videoCodecs = videoCodecs;
        this.mediaRegion = mediaRegion;
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final RoomStatus getStatus() {
        return this.status;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Boolean getEnableTurn() {
        return this.enableTurn;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public final DateTime getEndTime() {
        return this.endTime;
    }

    public final Integer getDuration() {
        return this.duration;
    }

    public final RoomType getType() {
        return this.type;
    }

    public final Integer getMaxParticipants() {
        return this.maxParticipants;
    }

    public final Boolean getRecordParticipantsOnConnect() {
        return this.recordParticipantsOnConnect;
    }

    public final List<VideoCodec> getVideoCodecs() {
        return this.videoCodecs;
    }

    public final String getMediaRegion() {
        return this.mediaRegion;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Room other = (Room)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.enableTurn, other.enableTurn) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals((Object)this.statusCallbackMethod, (Object)other.statusCallbackMethod) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.duration, other.duration) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.maxParticipants, other.maxParticipants) && Objects.equals(this.recordParticipantsOnConnect, other.recordParticipantsOnConnect) && Objects.equals(this.videoCodecs, other.videoCodecs) && Objects.equals(this.mediaRegion, other.mediaRegion) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.status, this.dateCreated, this.dateUpdated, this.accountSid, this.enableTurn, this.uniqueName, this.statusCallback, this.statusCallbackMethod, this.endTime, this.duration, this.type, this.maxParticipants, this.recordParticipantsOnConnect, this.videoCodecs, this.mediaRegion, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("status", (Object)this.status).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("accountSid", this.accountSid).add("enableTurn", this.enableTurn).add("uniqueName", this.uniqueName).add("statusCallback", this.statusCallback).add("statusCallbackMethod", (Object)this.statusCallbackMethod).add("endTime", this.endTime).add("duration", this.duration).add("type", (Object)this.type).add("maxParticipants", this.maxParticipants).add("recordParticipantsOnConnect", this.recordParticipantsOnConnect).add("videoCodecs", this.videoCodecs).add("mediaRegion", this.mediaRegion).add("url", this.url).add("links", this.links).toString();
    }

    public static enum VideoCodec {
        VP8("VP8"),
        H264("H264");

        private final String value;

        private VideoCodec(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static VideoCodec forValue(String value) {
            return (VideoCodec)Promoter.enumFromString((String)value, (Enum[])VideoCodec.values());
        }
    }

    public static enum RoomType {
        PEER_TO_PEER("peer-to-peer"),
        GROUP("group"),
        GROUP_SMALL("group-small");

        private final String value;

        private RoomType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RoomType forValue(String value) {
            return (RoomType)Promoter.enumFromString((String)value, (Enum[])RoomType.values());
        }
    }

    public static enum RoomStatus {
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        FAILED("failed");

        private final String value;

        private RoomStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static RoomStatus forValue(String value) {
            return (RoomStatus)Promoter.enumFromString((String)value, (Enum[])RoomStatus.values());
        }
    }
}

