/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.WorkflowCreator;
import com.twilio.rest.taskrouter.v1.workspace.WorkflowDeleter;
import com.twilio.rest.taskrouter.v1.workspace.WorkflowFetcher;
import com.twilio.rest.taskrouter.v1.workspace.WorkflowReader;
import com.twilio.rest.taskrouter.v1.workspace.WorkflowUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Workflow
extends Resource {
    private static final long serialVersionUID = 205559746169581L;
    private final String accountSid;
    private final URI assignmentCallbackUrl;
    private final String configuration;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String documentContentType;
    private final URI fallbackAssignmentCallbackUrl;
    private final String friendlyName;
    private final String sid;
    private final Integer taskReservationTimeout;
    private final String workspaceSid;
    private final URI url;
    private final Map<String, String> links;

    public static WorkflowFetcher fetcher(String pathWorkspaceSid, String pathSid) {
        return new WorkflowFetcher(pathWorkspaceSid, pathSid);
    }

    public static WorkflowUpdater updater(String pathWorkspaceSid, String pathSid) {
        return new WorkflowUpdater(pathWorkspaceSid, pathSid);
    }

    public static WorkflowDeleter deleter(String pathWorkspaceSid, String pathSid) {
        return new WorkflowDeleter(pathWorkspaceSid, pathSid);
    }

    public static WorkflowReader reader(String pathWorkspaceSid) {
        return new WorkflowReader(pathWorkspaceSid);
    }

    public static WorkflowCreator creator(String pathWorkspaceSid, String friendlyName, String configuration) {
        return new WorkflowCreator(pathWorkspaceSid, friendlyName, configuration);
    }

    public static Workflow fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Workflow.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Workflow fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Workflow.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Workflow(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="assignment_callback_url") URI assignmentCallbackUrl, @JsonProperty(value="configuration") String configuration, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="document_content_type") String documentContentType, @JsonProperty(value="fallback_assignment_callback_url") URI fallbackAssignmentCallbackUrl, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="sid") String sid, @JsonProperty(value="task_reservation_timeout") Integer taskReservationTimeout, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.assignmentCallbackUrl = assignmentCallbackUrl;
        this.configuration = configuration;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.documentContentType = documentContentType;
        this.fallbackAssignmentCallbackUrl = fallbackAssignmentCallbackUrl;
        this.friendlyName = friendlyName;
        this.sid = sid;
        this.taskReservationTimeout = taskReservationTimeout;
        this.workspaceSid = workspaceSid;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final URI getAssignmentCallbackUrl() {
        return this.assignmentCallbackUrl;
    }

    public final String getConfiguration() {
        return this.configuration;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDocumentContentType() {
        return this.documentContentType;
    }

    public final URI getFallbackAssignmentCallbackUrl() {
        return this.fallbackAssignmentCallbackUrl;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Integer getTaskReservationTimeout() {
        return this.taskReservationTimeout;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workflow other = (Workflow)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.assignmentCallbackUrl, other.assignmentCallbackUrl) && Objects.equals(this.configuration, other.configuration) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.documentContentType, other.documentContentType) && Objects.equals(this.fallbackAssignmentCallbackUrl, other.fallbackAssignmentCallbackUrl) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.sid, other.sid) && Objects.equals(this.taskReservationTimeout, other.taskReservationTimeout) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.assignmentCallbackUrl, this.configuration, this.dateCreated, this.dateUpdated, this.documentContentType, this.fallbackAssignmentCallbackUrl, this.friendlyName, this.sid, this.taskReservationTimeout, this.workspaceSid, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("assignmentCallbackUrl", this.assignmentCallbackUrl).add("configuration", this.configuration).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("documentContentType", this.documentContentType).add("fallbackAssignmentCallbackUrl", this.fallbackAssignmentCallbackUrl).add("friendlyName", this.friendlyName).add("sid", this.sid).add("taskReservationTimeout", this.taskReservationTimeout).add("workspaceSid", this.workspaceSid).add("url", this.url).add("links", this.links).toString();
    }
}

