/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service.session;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.service.session.Interaction;

public class InteractionReader
extends Reader<Interaction> {
    private final String pathServiceSid;
    private final String pathSessionSid;

    public InteractionReader(String pathServiceSid, String pathSessionSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSessionSid = pathSessionSid;
    }

    @Override
    public ResourceSet<Interaction> read(TwilioRestClient client) {
        return new ResourceSet<Interaction>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Interaction> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PROXY.toString(), "/v1/Services/" + this.pathServiceSid + "/Sessions/" + this.pathSessionSid + "/Interactions", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Interaction> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Interaction> nextPage(Page<Interaction> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PROXY.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Interaction> previousPage(Page<Interaction> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PROXY.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Interaction> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Interaction read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("interactions", response.getContent(), Interaction.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

