/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.wireless;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.wireless.Command;
import java.net.URI;

public class CommandCreator
extends Creator<Command> {
    private final String command;
    private String device;
    private String sim;
    private String callbackMethod;
    private URI callbackUrl;
    private String commandMode;
    private String includeSid;

    public CommandCreator(String command) {
        this.command = command;
    }

    public CommandCreator setDevice(String device) {
        this.device = device;
        return this;
    }

    public CommandCreator setSim(String sim) {
        this.sim = sim;
        return this;
    }

    public CommandCreator setCallbackMethod(String callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public CommandCreator setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public CommandCreator setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    public CommandCreator setCommandMode(String commandMode) {
        this.commandMode = commandMode;
        return this;
    }

    public CommandCreator setIncludeSid(String includeSid) {
        this.includeSid = includeSid;
        return this;
    }

    @Override
    public Command create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/wireless/Commands", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Command creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Command.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.command != null) {
            request.addPostParam("Command", this.command);
        }
        if (this.device != null) {
            request.addPostParam("Device", this.device);
        }
        if (this.sim != null) {
            request.addPostParam("Sim", this.sim);
        }
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod);
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
        if (this.commandMode != null) {
            request.addPostParam("CommandMode", this.commandMode);
        }
        if (this.includeSid != null) {
            request.addPostParam("IncludeSid", this.includeSid);
        }
    }
}

