/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant.task;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.understand.assistant.task.Field;

public class FieldCreator
extends Creator<Field> {
    private final String pathAssistantSid;
    private final String pathTaskSid;
    private final String fieldType;
    private final String uniqueName;

    public FieldCreator(String pathAssistantSid, String pathTaskSid, String fieldType, String uniqueName) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathTaskSid = pathTaskSid;
        this.fieldType = fieldType;
        this.uniqueName = uniqueName;
    }

    @Override
    public Field create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/understand/Assistants/" + this.pathAssistantSid + "/Tasks/" + this.pathTaskSid + "/Fields", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Field creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Field.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.fieldType != null) {
            request.addPostParam("FieldType", this.fieldType);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
    }
}

