/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.understand.assistant.StyleSheetFetcher;
import com.twilio.rest.preview.understand.assistant.StyleSheetUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StyleSheet
extends Resource {
    private static final long serialVersionUID = 3179724176697L;
    private final String accountSid;
    private final String assistantSid;
    private final URI url;
    private final Map<String, Object> data;

    public static StyleSheetFetcher fetcher(String pathAssistantSid) {
        return new StyleSheetFetcher(pathAssistantSid);
    }

    public static StyleSheetUpdater updater(String pathAssistantSid) {
        return new StyleSheetUpdater(pathAssistantSid);
    }

    public static StyleSheet fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, StyleSheet.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static StyleSheet fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, StyleSheet.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private StyleSheet(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="url") URI url, @JsonProperty(value="data") Map<String, Object> data) {
        this.accountSid = accountSid;
        this.assistantSid = assistantSid;
        this.url = url;
        this.data = data;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyleSheet other = (StyleSheet)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.url, other.url) && Objects.equals(this.data, other.data);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.assistantSid, this.url, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("assistantSid", this.assistantSid).add("url", this.url).add("data", this.data).toString();
    }
}

