/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.marketplace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.marketplace.AvailableAddOnFetcher;
import com.twilio.rest.preview.marketplace.AvailableAddOnReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AvailableAddOn
extends Resource {
    private static final long serialVersionUID = 22306216855466L;
    private final String sid;
    private final String friendlyName;
    private final String description;
    private final String pricingType;
    private final Map<String, Object> configurationSchema;
    private final URI url;
    private final Map<String, String> links;

    public static AvailableAddOnFetcher fetcher(String pathSid) {
        return new AvailableAddOnFetcher(pathSid);
    }

    public static AvailableAddOnReader reader() {
        return new AvailableAddOnReader();
    }

    public static AvailableAddOn fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AvailableAddOn.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AvailableAddOn fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AvailableAddOn.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AvailableAddOn(@JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="description") String description, @JsonProperty(value="pricing_type") String pricingType, @JsonProperty(value="configuration_schema") Map<String, Object> configurationSchema, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.description = description;
        this.pricingType = pricingType;
        this.configurationSchema = configurationSchema;
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getPricingType() {
        return this.pricingType;
    }

    public final Map<String, Object> getConfigurationSchema() {
        return this.configurationSchema;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableAddOn other = (AvailableAddOn)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.description, other.description) && Objects.equals(this.pricingType, other.pricingType) && Objects.equals(this.configurationSchema, other.configurationSchema) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.friendlyName, this.description, this.pricingType, this.configurationSchema, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("friendlyName", this.friendlyName).add("description", this.description).add("pricingType", this.pricingType).add("configurationSchema", this.configurationSchema).add("url", this.url).add("links", this.links).toString();
    }
}

