/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.hostedNumbers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.hostedNumbers.AuthorizationDocumentCreator;
import com.twilio.rest.preview.hostedNumbers.AuthorizationDocumentFetcher;
import com.twilio.rest.preview.hostedNumbers.AuthorizationDocumentReader;
import com.twilio.rest.preview.hostedNumbers.AuthorizationDocumentUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AuthorizationDocument
extends Resource {
    private static final long serialVersionUID = 156014201571905L;
    private final String sid;
    private final String addressSid;
    private final Status status;
    private final String email;
    private final List<String> ccEmails;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static AuthorizationDocumentFetcher fetcher(String pathSid) {
        return new AuthorizationDocumentFetcher(pathSid);
    }

    public static AuthorizationDocumentUpdater updater(String pathSid) {
        return new AuthorizationDocumentUpdater(pathSid);
    }

    public static AuthorizationDocumentReader reader() {
        return new AuthorizationDocumentReader();
    }

    public static AuthorizationDocumentCreator creator(List<String> hostedNumberOrderSids, String addressSid, String email, String contactTitle, String contactPhoneNumber) {
        return new AuthorizationDocumentCreator(hostedNumberOrderSids, addressSid, email, contactTitle, contactPhoneNumber);
    }

    public static AuthorizationDocument fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AuthorizationDocument.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AuthorizationDocument fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, AuthorizationDocument.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AuthorizationDocument(@JsonProperty(value="sid") String sid, @JsonProperty(value="address_sid") String addressSid, @JsonProperty(value="status") Status status, @JsonProperty(value="email") String email, @JsonProperty(value="cc_emails") List<String> ccEmails, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.addressSid = addressSid;
        this.status = status;
        this.email = email;
        this.ccEmails = ccEmails;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAddressSid() {
        return this.addressSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getEmail() {
        return this.email;
    }

    public final List<String> getCcEmails() {
        return this.ccEmails;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationDocument other = (AuthorizationDocument)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.addressSid, other.addressSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.email, other.email) && Objects.equals(this.ccEmails, other.ccEmails) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.addressSid, this.status, this.email, this.ccEmails, this.dateCreated, this.dateUpdated, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("addressSid", this.addressSid).add("status", (Object)this.status).add("email", this.email).add("ccEmails", this.ccEmails).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).add("links", this.links).toString();
    }

    public static enum Status {
        OPENED("opened"),
        SIGNING("signing"),
        SIGNED("signed"),
        CANCELED("canceled"),
        FAILED("failed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

