/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.notify.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.notify.v1.service.Binding;
import java.util.List;
import org.joda.time.LocalDate;

public class BindingReader
extends Reader<Binding> {
    private final String pathServiceSid;
    private LocalDate startDate;
    private LocalDate endDate;
    private List<String> identity;
    private List<String> tag;

    public BindingReader(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public BindingReader setStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    public BindingReader setEndDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    public BindingReader setIdentity(List<String> identity) {
        this.identity = identity;
        return this;
    }

    public BindingReader setIdentity(String identity) {
        return this.setIdentity(Promoter.listOfOne(identity));
    }

    public BindingReader setTag(List<String> tag) {
        this.tag = tag;
        return this;
    }

    public BindingReader setTag(String tag) {
        return this.setTag(Promoter.listOfOne(tag));
    }

    @Override
    public ResourceSet<Binding> read(TwilioRestClient client) {
        return new ResourceSet<Binding>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Binding> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.NOTIFY.toString(), "/v1/Services/" + this.pathServiceSid + "/Bindings", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Binding> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Binding> nextPage(Page<Binding> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.NOTIFY.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Binding> previousPage(Page<Binding> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.NOTIFY.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Binding> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Binding read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("bindings", response.getContent(), Binding.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.startDate != null) {
            request.addQueryParam("StartDate", DateConverter.dateStringFromLocalDate(this.startDate));
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", DateConverter.dateStringFromLocalDate(this.endDate));
        }
        if (this.identity != null) {
            for (String prop : this.identity) {
                request.addQueryParam("Identity", prop);
            }
        }
        if (this.tag != null) {
            for (String prop : this.tag) {
                request.addQueryParam("Tag", prop);
            }
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

