/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.fax.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.fax.v1.FaxCreator;
import com.twilio.rest.fax.v1.FaxDeleter;
import com.twilio.rest.fax.v1.FaxFetcher;
import com.twilio.rest.fax.v1.FaxReader;
import com.twilio.rest.fax.v1.FaxUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Fax
extends Resource {
    private static final long serialVersionUID = 272370485490742L;
    private final String sid;
    private final String accountSid;
    private final String from;
    private final String to;
    private final Quality quality;
    private final String mediaSid;
    private final String mediaUrl;
    private final Integer numPages;
    private final Integer duration;
    private final Status status;
    private final Direction direction;
    private final String apiVersion;
    private final BigDecimal price;
    private final Currency priceUnit;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Map<String, String> links;
    private final URI url;

    public static FaxFetcher fetcher(String pathSid) {
        return new FaxFetcher(pathSid);
    }

    public static FaxReader reader() {
        return new FaxReader();
    }

    public static FaxCreator creator(String to, URI mediaUrl) {
        return new FaxCreator(to, mediaUrl);
    }

    public static FaxUpdater updater(String pathSid) {
        return new FaxUpdater(pathSid);
    }

    public static FaxDeleter deleter(String pathSid) {
        return new FaxDeleter(pathSid);
    }

    public static Fax fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Fax.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Fax fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Fax.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Fax(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="from") String from, @JsonProperty(value="to") String to, @JsonProperty(value="quality") Quality quality, @JsonProperty(value="media_sid") String mediaSid, @JsonProperty(value="media_url") String mediaUrl, @JsonProperty(value="num_pages") Integer numPages, @JsonProperty(value="duration") Integer duration, @JsonProperty(value="status") Status status, @JsonProperty(value="direction") Direction direction, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.from = from;
        this.to = to;
        this.quality = quality;
        this.mediaSid = mediaSid;
        this.mediaUrl = mediaUrl;
        this.numPages = numPages;
        this.duration = duration;
        this.status = status;
        this.direction = direction;
        this.apiVersion = apiVersion;
        this.price = price;
        this.priceUnit = priceUnit;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.links = links;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFrom() {
        return this.from;
    }

    public final String getTo() {
        return this.to;
    }

    public final Quality getQuality() {
        return this.quality;
    }

    public final String getMediaSid() {
        return this.mediaSid;
    }

    public final String getMediaUrl() {
        return this.mediaUrl;
    }

    public final Integer getNumPages() {
        return this.numPages;
    }

    public final Integer getDuration() {
        return this.duration;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final BigDecimal getPrice() {
        return this.price;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fax other = (Fax)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals((Object)this.quality, (Object)other.quality) && Objects.equals(this.mediaSid, other.mediaSid) && Objects.equals(this.mediaUrl, other.mediaUrl) && Objects.equals(this.numPages, other.numPages) && Objects.equals(this.duration, other.duration) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.price, other.price) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.links, other.links) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.from, this.to, this.quality, this.mediaSid, this.mediaUrl, this.numPages, this.duration, this.status, this.direction, this.apiVersion, this.price, this.priceUnit, this.dateCreated, this.dateUpdated, this.links, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("from", this.from).add("to", this.to).add("quality", (Object)this.quality).add("mediaSid", this.mediaSid).add("mediaUrl", this.mediaUrl).add("numPages", this.numPages).add("duration", this.duration).add("status", (Object)this.status).add("direction", (Object)this.direction).add("apiVersion", this.apiVersion).add("price", this.price).add("priceUnit", this.priceUnit).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("links", this.links).add("url", this.url).toString();
    }

    public static enum UpdateStatus {
        CANCELED("canceled");

        private final String value;

        private UpdateStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static UpdateStatus forValue(String value) {
            return (UpdateStatus)Promoter.enumFromString((String)value, (Enum[])UpdateStatus.values());
        }
    }

    public static enum Status {
        QUEUED("queued"),
        PROCESSING("processing"),
        SENDING("sending"),
        DELIVERED("delivered"),
        RECEIVING("receiving"),
        RECEIVED("received"),
        NO_ANSWER("no-answer"),
        BUSY("busy"),
        FAILED("failed"),
        CANCELED("canceled");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Quality {
        STANDARD("standard"),
        FINE("fine"),
        SUPERFINE("superfine");

        private final String value;

        private Quality(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Quality forValue(String value) {
            return (Quality)Promoter.enumFromString((String)value, (Enum[])Quality.values());
        }
    }

    public static enum Direction {
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Direction forValue(String value) {
            return (Direction)Promoter.enumFromString((String)value, (Enum[])Direction.values());
        }
    }
}

