/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.chat.v2.service.BindingDeleter;
import com.twilio.rest.chat.v2.service.BindingFetcher;
import com.twilio.rest.chat.v2.service.BindingReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Binding
extends Resource {
    private static final long serialVersionUID = 102481637129176L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String endpoint;
    private final String identity;
    private final String credentialSid;
    private final BindingType bindingType;
    private final List<String> messageTypes;
    private final URI url;
    private final Map<String, String> links;

    public static BindingReader reader(String pathServiceSid) {
        return new BindingReader(pathServiceSid);
    }

    public static BindingFetcher fetcher(String pathServiceSid, String pathSid) {
        return new BindingFetcher(pathServiceSid, pathSid);
    }

    public static BindingDeleter deleter(String pathServiceSid, String pathSid) {
        return new BindingDeleter(pathServiceSid, pathSid);
    }

    public static Binding fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Binding.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Binding fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Binding.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Binding(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="endpoint") String endpoint, @JsonProperty(value="identity") String identity, @JsonProperty(value="credential_sid") String credentialSid, @JsonProperty(value="binding_type") BindingType bindingType, @JsonProperty(value="message_types") List<String> messageTypes, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.endpoint = endpoint;
        this.identity = identity;
        this.credentialSid = credentialSid;
        this.bindingType = bindingType;
        this.messageTypes = messageTypes;
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getEndpoint() {
        return this.endpoint;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getCredentialSid() {
        return this.credentialSid;
    }

    public final BindingType getBindingType() {
        return this.bindingType;
    }

    public final List<String> getMessageTypes() {
        return this.messageTypes;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binding other = (Binding)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.identity, other.identity) && Objects.equals(this.credentialSid, other.credentialSid) && Objects.equals((Object)this.bindingType, (Object)other.bindingType) && Objects.equals(this.messageTypes, other.messageTypes) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.dateCreated, this.dateUpdated, this.endpoint, this.identity, this.credentialSid, this.bindingType, this.messageTypes, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("serviceSid", this.serviceSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("endpoint", this.endpoint).add("identity", this.identity).add("credentialSid", this.credentialSid).add("bindingType", (Object)this.bindingType).add("messageTypes", this.messageTypes).add("url", this.url).add("links", this.links).toString();
    }

    public static enum BindingType {
        GCM("gcm"),
        APN("apn"),
        FCM("fcm");

        private final String value;

        private BindingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static BindingType forValue(String value) {
            return (BindingType)Promoter.enumFromString((String)value, (Enum[])BindingType.values());
        }
    }
}

