/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant.task;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.assistant.task.Sample;

public class SampleReader
extends Reader<Sample> {
    private final String pathAssistantSid;
    private final String pathTaskSid;
    private String language;

    public SampleReader(String pathAssistantSid, String pathTaskSid) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathTaskSid = pathTaskSid;
    }

    public SampleReader setLanguage(String language) {
        this.language = language;
        return this;
    }

    @Override
    public ResourceSet<Sample> read(TwilioRestClient client) {
        return new ResourceSet<Sample>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Sample> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.AUTOPILOT.toString(), "/v1/Assistants/" + this.pathAssistantSid + "/Tasks/" + this.pathTaskSid + "/Samples", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Sample> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Sample> nextPage(Page<Sample> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.AUTOPILOT.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Sample> previousPage(Page<Sample> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.AUTOPILOT.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Sample> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Sample read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("samples", response.getContent(), Sample.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.language != null) {
            request.addQueryParam("Language", this.language);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

