/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.autopilot.v1.assistant.ModelBuildCreator;
import com.twilio.rest.autopilot.v1.assistant.ModelBuildDeleter;
import com.twilio.rest.autopilot.v1.assistant.ModelBuildFetcher;
import com.twilio.rest.autopilot.v1.assistant.ModelBuildReader;
import com.twilio.rest.autopilot.v1.assistant.ModelBuildUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ModelBuild
extends Resource {
    private static final long serialVersionUID = 48078492703405L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String assistantSid;
    private final String sid;
    private final Status status;
    private final String uniqueName;
    private final URI url;
    private final Integer buildDuration;
    private final Integer errorCode;

    public static ModelBuildFetcher fetcher(String pathAssistantSid, String pathSid) {
        return new ModelBuildFetcher(pathAssistantSid, pathSid);
    }

    public static ModelBuildReader reader(String pathAssistantSid) {
        return new ModelBuildReader(pathAssistantSid);
    }

    public static ModelBuildCreator creator(String pathAssistantSid) {
        return new ModelBuildCreator(pathAssistantSid);
    }

    public static ModelBuildUpdater updater(String pathAssistantSid, String pathSid) {
        return new ModelBuildUpdater(pathAssistantSid, pathSid);
    }

    public static ModelBuildDeleter deleter(String pathAssistantSid, String pathSid) {
        return new ModelBuildDeleter(pathAssistantSid, pathSid);
    }

    public static ModelBuild fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ModelBuild.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ModelBuild fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, ModelBuild.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ModelBuild(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="status") Status status, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="url") URI url, @JsonProperty(value="build_duration") Integer buildDuration, @JsonProperty(value="error_code") Integer errorCode) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.assistantSid = assistantSid;
        this.sid = sid;
        this.status = status;
        this.uniqueName = uniqueName;
        this.url = url;
        this.buildDuration = buildDuration;
        this.errorCode = errorCode;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Integer getBuildDuration() {
        return this.buildDuration;
    }

    public final Integer getErrorCode() {
        return this.errorCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelBuild other = (ModelBuild)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.url, other.url) && Objects.equals(this.buildDuration, other.buildDuration) && Objects.equals(this.errorCode, other.errorCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.dateCreated, this.dateUpdated, this.assistantSid, this.sid, this.status, this.uniqueName, this.url, this.buildDuration, this.errorCode});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("assistantSid", this.assistantSid).add("sid", this.sid).add("status", (Object)this.status).add("uniqueName", this.uniqueName).add("url", this.url).add("buildDuration", this.buildDuration).add("errorCode", this.errorCode).toString();
    }

    public static enum Status {
        ENQUEUED("enqueued"),
        BUILDING("building"),
        COMPLETED("completed"),
        FAILED("failed"),
        CANCELED("canceled");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

