/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.authy.v1.service.entity.factor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.authy.v1.service.entity.factor.ChallengeCreator;
import com.twilio.rest.authy.v1.service.entity.factor.ChallengeDeleter;
import com.twilio.rest.authy.v1.service.entity.factor.ChallengeFetcher;
import com.twilio.rest.authy.v1.service.entity.factor.ChallengeUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Challenge
extends Resource {
    private static final long serialVersionUID = 218254684366686L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String entitySid;
    private final String identity;
    private final String factorSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final DateTime dateResponded;
    private final DateTime expirationDate;
    private final ChallengeStatuses status;
    private final ChallengeReasons respondedReason;
    private final String details;
    private final String hiddenDetails;
    private final FactorTypes factorType;
    private final URI url;

    public static ChallengeCreator creator(String pathServiceSid, String pathIdentity, String pathFactorSid) {
        return new ChallengeCreator(pathServiceSid, pathIdentity, pathFactorSid);
    }

    public static ChallengeDeleter deleter(String pathServiceSid, String pathIdentity, String pathFactorSid, String pathSid) {
        return new ChallengeDeleter(pathServiceSid, pathIdentity, pathFactorSid, pathSid);
    }

    public static ChallengeFetcher fetcher(String pathServiceSid, String pathIdentity, String pathFactorSid, String pathSid) {
        return new ChallengeFetcher(pathServiceSid, pathIdentity, pathFactorSid, pathSid);
    }

    public static ChallengeUpdater updater(String pathServiceSid, String pathIdentity, String pathFactorSid, String pathSid) {
        return new ChallengeUpdater(pathServiceSid, pathIdentity, pathFactorSid, pathSid);
    }

    public static Challenge fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Challenge.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Challenge fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Challenge.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Challenge(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="entity_sid") String entitySid, @JsonProperty(value="identity") String identity, @JsonProperty(value="factor_sid") String factorSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="date_responded") String dateResponded, @JsonProperty(value="expiration_date") String expirationDate, @JsonProperty(value="status") ChallengeStatuses status, @JsonProperty(value="responded_reason") ChallengeReasons respondedReason, @JsonProperty(value="details") String details, @JsonProperty(value="hidden_details") String hiddenDetails, @JsonProperty(value="factor_type") FactorTypes factorType, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.entitySid = entitySid;
        this.identity = identity;
        this.factorSid = factorSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.dateResponded = DateConverter.iso8601DateTimeFromString(dateResponded);
        this.expirationDate = DateConverter.iso8601DateTimeFromString(expirationDate);
        this.status = status;
        this.respondedReason = respondedReason;
        this.details = details;
        this.hiddenDetails = hiddenDetails;
        this.factorType = factorType;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getEntitySid() {
        return this.entitySid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getFactorSid() {
        return this.factorSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final DateTime getDateResponded() {
        return this.dateResponded;
    }

    public final DateTime getExpirationDate() {
        return this.expirationDate;
    }

    public final ChallengeStatuses getStatus() {
        return this.status;
    }

    public final ChallengeReasons getRespondedReason() {
        return this.respondedReason;
    }

    public final String getDetails() {
        return this.details;
    }

    public final String getHiddenDetails() {
        return this.hiddenDetails;
    }

    public final FactorTypes getFactorType() {
        return this.factorType;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Challenge other = (Challenge)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.entitySid, other.entitySid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.factorSid, other.factorSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.dateResponded, other.dateResponded) && Objects.equals(this.expirationDate, other.expirationDate) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.respondedReason, (Object)other.respondedReason) && Objects.equals(this.details, other.details) && Objects.equals(this.hiddenDetails, other.hiddenDetails) && Objects.equals((Object)this.factorType, (Object)other.factorType) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.entitySid, this.identity, this.factorSid, this.dateCreated, this.dateUpdated, this.dateResponded, this.expirationDate, this.status, this.respondedReason, this.details, this.hiddenDetails, this.factorType, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("serviceSid", this.serviceSid).add("entitySid", this.entitySid).add("identity", this.identity).add("factorSid", this.factorSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("dateResponded", this.dateResponded).add("expirationDate", this.expirationDate).add("status", (Object)this.status).add("respondedReason", (Object)this.respondedReason).add("details", this.details).add("hiddenDetails", this.hiddenDetails).add("factorType", (Object)this.factorType).add("url", this.url).toString();
    }

    public static enum FactorTypes {
        APP_PUSH("app-push"),
        SMS("sms"),
        TOTP("totp");

        private final String value;

        private FactorTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static FactorTypes forValue(String value) {
            return (FactorTypes)Promoter.enumFromString((String)value, (Enum[])FactorTypes.values());
        }
    }

    public static enum ChallengeReasons {
        NONE("none"),
        NOT_NEEDED("not_needed"),
        NOT_REQUESTED("not_requested");

        private final String value;

        private ChallengeReasons(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ChallengeReasons forValue(String value) {
            return (ChallengeReasons)Promoter.enumFromString((String)value, (Enum[])ChallengeReasons.values());
        }
    }

    public static enum ChallengeStatuses {
        PENDING("pending"),
        EXPIRED("expired"),
        APPROVED("approved"),
        DENIED("denied");

        private final String value;

        private ChallengeStatuses(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ChallengeStatuses forValue(String value) {
            return (ChallengeStatuses)Promoter.enumFromString((String)value, (Enum[])ChallengeStatuses.values());
        }
    }
}

