/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.authy.v1.service.entity;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.authy.v1.service.entity.Factor;

public class FactorCreator
extends Creator<Factor> {
    private final String pathServiceSid;
    private final String pathIdentity;
    private final String binding;
    private final String friendlyName;
    private final Factor.FactorTypes factorType;

    public FactorCreator(String pathServiceSid, String pathIdentity, String binding, String friendlyName, Factor.FactorTypes factorType) {
        this.pathServiceSid = pathServiceSid;
        this.pathIdentity = pathIdentity;
        this.binding = binding;
        this.friendlyName = friendlyName;
        this.factorType = factorType;
    }

    @Override
    public Factor create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTHY.toString(), "/v1/Services/" + this.pathServiceSid + "/Entities/" + this.pathIdentity + "/Factors", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Factor creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Factor.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.binding != null) {
            request.addPostParam("Binding", this.binding);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.factorType != null) {
            request.addPostParam("FactorType", this.factorType.toString());
        }
    }
}

