/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.authy.v1.service.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.authy.v1.service.entity.FactorCreator;
import com.twilio.rest.authy.v1.service.entity.FactorDeleter;
import com.twilio.rest.authy.v1.service.entity.FactorFetcher;
import com.twilio.rest.authy.v1.service.entity.FactorReader;
import com.twilio.rest.authy.v1.service.entity.FactorUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Factor
extends Resource {
    private static final long serialVersionUID = 171608504161461L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final String entitySid;
    private final String identity;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final FactorStatuses status;
    private final FactorTypes factorType;
    private final URI url;
    private final Map<String, String> links;

    public static FactorCreator creator(String pathServiceSid, String pathIdentity, String binding, String friendlyName, FactorTypes factorType) {
        return new FactorCreator(pathServiceSid, pathIdentity, binding, friendlyName, factorType);
    }

    public static FactorDeleter deleter(String pathServiceSid, String pathIdentity, String pathSid) {
        return new FactorDeleter(pathServiceSid, pathIdentity, pathSid);
    }

    public static FactorFetcher fetcher(String pathServiceSid, String pathIdentity, String pathSid) {
        return new FactorFetcher(pathServiceSid, pathIdentity, pathSid);
    }

    public static FactorReader reader(String pathServiceSid, String pathIdentity) {
        return new FactorReader(pathServiceSid, pathIdentity);
    }

    public static FactorUpdater updater(String pathServiceSid, String pathIdentity, String pathSid) {
        return new FactorUpdater(pathServiceSid, pathIdentity, pathSid);
    }

    public static Factor fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Factor.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Factor fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Factor.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Factor(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="entity_sid") String entitySid, @JsonProperty(value="identity") String identity, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="status") FactorStatuses status, @JsonProperty(value="factor_type") FactorTypes factorType, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.entitySid = entitySid;
        this.identity = identity;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.status = status;
        this.factorType = factorType;
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getEntitySid() {
        return this.entitySid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final FactorStatuses getStatus() {
        return this.status;
    }

    public final FactorTypes getFactorType() {
        return this.factorType;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Factor other = (Factor)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.entitySid, other.entitySid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.factorType, (Object)other.factorType) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.accountSid, this.serviceSid, this.entitySid, this.identity, this.dateCreated, this.dateUpdated, this.friendlyName, this.status, this.factorType, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("accountSid", this.accountSid).add("serviceSid", this.serviceSid).add("entitySid", this.entitySid).add("identity", this.identity).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("friendlyName", this.friendlyName).add("status", (Object)this.status).add("factorType", (Object)this.factorType).add("url", this.url).add("links", this.links).toString();
    }

    public static enum FactorTypes {
        APP_PUSH("app-push"),
        SMS("sms"),
        TOTP("totp");

        private final String value;

        private FactorTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static FactorTypes forValue(String value) {
            return (FactorTypes)Promoter.enumFromString((String)value, (Enum[])FactorTypes.values());
        }
    }

    public static enum FactorStatuses {
        UNVERIFIED("unverified"),
        VERIFIED("verified");

        private final String value;

        private FactorStatuses(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static FactorStatuses forValue(String value) {
            return (FactorStatuses)Promoter.enumFromString((String)value, (Enum[])FactorStatuses.values());
        }
    }
}

