/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.incomingphonenumber;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.incomingphonenumber.AssignedAddOn;

public class AssignedAddOnCreator
extends Creator<AssignedAddOn> {
    private String pathAccountSid;
    private final String pathResourceSid;
    private final String installedAddOnSid;

    public AssignedAddOnCreator(String pathResourceSid, String installedAddOnSid) {
        this.pathResourceSid = pathResourceSid;
        this.installedAddOnSid = installedAddOnSid;
    }

    public AssignedAddOnCreator(String pathAccountSid, String pathResourceSid, String installedAddOnSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathResourceSid = pathResourceSid;
        this.installedAddOnSid = installedAddOnSid;
    }

    @Override
    public AssignedAddOn create(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/IncomingPhoneNumbers/" + this.pathResourceSid + "/AssignedAddOns.json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AssignedAddOn creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return AssignedAddOn.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.installedAddOnSid != null) {
            request.addPostParam("InstalledAddOnSid", this.installedAddOnSid);
        }
    }
}

