/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.conference.Participant;

public class ParticipantFetcher
extends Fetcher<Participant> {
    private String pathAccountSid;
    private final String pathConferenceSid;
    private final String pathCallSid;

    public ParticipantFetcher(String pathConferenceSid, String pathCallSid) {
        this.pathConferenceSid = pathConferenceSid;
        this.pathCallSid = pathCallSid;
    }

    public ParticipantFetcher(String pathAccountSid, String pathConferenceSid, String pathCallSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathConferenceSid = pathConferenceSid;
        this.pathCallSid = pathCallSid;
    }

    @Override
    public Participant fetch(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.GET, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Conferences/" + this.pathConferenceSid + "/Participants/" + this.pathCallSid + ".json", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }
}

