/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.BalanceFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Balance
extends Resource {
    private static final long serialVersionUID = 237340404453814L;
    private final String accountSid;
    private final String balance;
    private final String currency;

    public static BalanceFetcher fetcher(String pathAccountSid) {
        return new BalanceFetcher(pathAccountSid);
    }

    public static BalanceFetcher fetcher() {
        return new BalanceFetcher();
    }

    public static Balance fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Balance.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Balance fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Balance.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Balance(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="balance") String balance, @JsonProperty(value="currency") String currency) {
        this.accountSid = accountSid;
        this.balance = balance;
        this.currency = currency;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getBalance() {
        return this.balance;
    }

    public final String getCurrency() {
        return this.currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Balance other = (Balance)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.balance, other.balance) && Objects.equals(this.currency, other.currency);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.balance, this.currency);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("balance", this.balance).add("currency", this.currency).toString();
    }
}

