/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Address;

public class AddressCreator
extends Creator<Address> {
    private String pathAccountSid;
    private final String customerName;
    private final String street;
    private final String city;
    private final String region;
    private final String postalCode;
    private final String isoCountry;
    private String friendlyName;
    private Boolean emergencyEnabled;
    private Boolean autoCorrectAddress;

    public AddressCreator(String customerName, String street, String city, String region, String postalCode, String isoCountry) {
        this.customerName = customerName;
        this.street = street;
        this.city = city;
        this.region = region;
        this.postalCode = postalCode;
        this.isoCountry = isoCountry;
    }

    public AddressCreator(String pathAccountSid, String customerName, String street, String city, String region, String postalCode, String isoCountry) {
        this.pathAccountSid = pathAccountSid;
        this.customerName = customerName;
        this.street = street;
        this.city = city;
        this.region = region;
        this.postalCode = postalCode;
        this.isoCountry = isoCountry;
    }

    public AddressCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AddressCreator setEmergencyEnabled(Boolean emergencyEnabled) {
        this.emergencyEnabled = emergencyEnabled;
        return this;
    }

    public AddressCreator setAutoCorrectAddress(Boolean autoCorrectAddress) {
        this.autoCorrectAddress = autoCorrectAddress;
        return this;
    }

    @Override
    public Address create(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Addresses.json", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Address creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Address.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.customerName != null) {
            request.addPostParam("CustomerName", this.customerName);
        }
        if (this.street != null) {
            request.addPostParam("Street", this.street);
        }
        if (this.city != null) {
            request.addPostParam("City", this.city);
        }
        if (this.region != null) {
            request.addPostParam("Region", this.region);
        }
        if (this.postalCode != null) {
            request.addPostParam("PostalCode", this.postalCode);
        }
        if (this.isoCountry != null) {
            request.addPostParam("IsoCountry", this.isoCountry);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.emergencyEnabled != null) {
            request.addPostParam("EmergencyEnabled", this.emergencyEnabled.toString());
        }
        if (this.autoCorrectAddress != null) {
            request.addPostParam("AutoCorrectAddress", this.autoCorrectAddress.toString());
        }
    }
}

