/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.legacyjdk.columnmapper;

import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jadira.usertype.spi.shared.AbstractVersionableTimestampColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.DstSafeTimestampType;

public class TimestampColumnDateMapper
extends AbstractVersionableTimestampColumnMapper<Date>
implements DatabaseZoneConfigured<TimeZone> {
    private static final long serialVersionUID = -7670411089210984705L;
    protected static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final ThreadLocal<SimpleDateFormat> DATETIME_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            format.setTimeZone(GMT);
            return format;
        }
    };
    private TimeZone databaseZone = GMT;

    public TimestampColumnDateMapper() {
    }

    public TimestampColumnDateMapper(TimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public Date fromNonNullString(String s) {
        int nanos;
        Date date = null;
        s = s.trim();
        String mainPart = s.substring(0, 23);
        ParsePosition parsePosition = new ParsePosition(0);
        SimpleDateFormat format = DATETIME_FORMAT.get();
        format.setTimeZone(GMT);
        date = format.parse(mainPart, parsePosition);
        if (date == null) {
            throw new IllegalArgumentException("Could not parse date: " + s);
        }
        int currentPosition = parsePosition.getIndex();
        int remaining = s.length() - currentPosition;
        if (remaining == 0) {
            nanos = 0;
        } else {
            if (s.charAt(currentPosition) != '.') {
                throw new IllegalArgumentException("Nanoseconds part was incorrectly formatted: " + s);
            }
            if (s.length() - ++currentPosition < 1 || s.length() - currentPosition > 9) {
                throw new IllegalArgumentException("Nanoseconds part was incorrectly formatted: " + s);
            }
            String nanosString = s.substring(currentPosition);
            if (nanosString.length() < 9) {
                nanosString = nanosString + "000000000";
                nanosString = nanosString.substring(0, 9);
            }
            try {
                nanos = Integer.parseInt(nanosString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Nanoseconds part was incorrectly formatted: " + s, e);
            }
        }
        if (nanos < 0 || nanos > 999999999) {
            throw new IllegalArgumentException("Nanoseconds part was incorrectly formatted: " + s);
        }
        if (nanos != 0) {
            date.setTime(date.getTime() + (long)(nanos / 1000000));
        }
        return date;
    }

    public Date fromNonNullValue(Timestamp value) {
        Date date = new Date(value.getTime());
        return date;
    }

    public String toNonNullString(Date value) {
        String tsString;
        TimeZone gmtZone = GMT;
        SimpleDateFormat sdf = DATETIME_FORMAT.get();
        sdf.setTimeZone(gmtZone);
        Calendar now = Calendar.getInstance(gmtZone);
        now.clear();
        now.setTime(value);
        long milliseconds = now.get(14);
        if (milliseconds == 0L) {
            tsString = sdf.format(value);
        } else {
            String nanosString = "" + milliseconds + "000000000";
            nanosString = nanosString.substring(0, 9);
            tsString = sdf.format(value) + "." + nanosString;
        }
        return tsString;
    }

    public Timestamp toNonNullValue(Date value) {
        Timestamp timestamp = new Timestamp(value.getTime());
        return timestamp;
    }

    public void setDatabaseZone(TimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public TimeZone parseZone(String zoneString) {
        return TimeZone.getTimeZone(zoneString);
    }

    public final DstSafeTimestampType getHibernateType() {
        return this.databaseZone == null ? DstSafeTimestampType.INSTANCE : new DstSafeTimestampType(Calendar.getInstance(this.databaseZone));
    }
}

