/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import org.jadira.usertype.spi.shared.AbstractStringColumnMapper;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class StringColumnInstantMapper
extends AbstractStringColumnMapper<Instant> {
    private static final long serialVersionUID = -6885561256539185520L;
    public static final DateTimeFormatter LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).appendLiteral('T').appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2).appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFractionOfSecond(3, 9).toParser()).appendTimeZoneOffset("Z", true, 2, 4).toFormatter();

    public Instant fromNonNullValue(String s) {
        return LOCAL_DATETIME_FORMATTER.parseDateTime(s).toInstant();
    }

    public String toNonNullValue(Instant value) {
        String formatted = ISODateTimeFormat.dateTime().print((ReadableInstant)value);
        if (formatted.endsWith(".000Z")) {
            formatted = formatted.substring(0, formatted.length() - 5) + "Z";
        }
        return formatted;
    }
}

