/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Date;
import java.util.Calendar;
import org.jadira.usertype.spi.shared.AbstractDateColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.DstSafeDateType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class DateColumnLocalDateMapper
extends AbstractDateColumnMapper<LocalDate>
implements DatabaseZoneConfigured<DateTimeZone> {
    private static final long serialVersionUID = 6734385103313158326L;
    public static final DateTimeFormatter LOCAL_DATE_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").toFormatter();
    private DateTimeZone databaseZone = null;

    public DateColumnLocalDateMapper() {
    }

    public DateColumnLocalDateMapper(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public LocalDate fromNonNullString(String s) {
        return new LocalDate((Object)s);
    }

    public LocalDate fromNonNullValue(Date value) {
        if (this.databaseZone == null) {
            return new LocalDate((Object)value.toString());
        }
        DateTime dateTime = new DateTime(value.getTime());
        LocalDate localDate = dateTime.toLocalDate();
        return localDate;
    }

    public String toNonNullString(LocalDate value) {
        return value.toString();
    }

    public Date toNonNullValue(LocalDate value) {
        if (this.databaseZone == null) {
            return Date.valueOf(LOCAL_DATE_FORMATTER.print((ReadablePartial)value));
        }
        DateTime zonedValue = value.toDateTime((ReadableInstant)value.toDateTimeAtStartOfDay());
        Date date = new Date(zonedValue.getMillis());
        return date;
    }

    public void setDatabaseZone(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public DateTimeZone parseZone(String zoneString) {
        return DateTimeZone.forID((String)zoneString);
    }

    public final DstSafeDateType getHibernateType() {
        return this.databaseZone == null ? DstSafeDateType.INSTANCE : new DstSafeDateType(Calendar.getInstance(this.databaseZone.toTimeZone()));
    }
}

