/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.bindings;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.ParameterizedType;
import org.jadira.bindings.core.api.Binding;
import org.jadira.bindings.core.binder.BasicBinder;
import org.jadira.usertype.spi.shared.AbstractHeuristicUserType;

public class PersistentBoundClass
extends AbstractHeuristicUserType
implements ParameterizedType,
EnhancedUserType,
Serializable {
    private static final long serialVersionUID = 3094384329334123541L;
    private static final BasicBinder BINDING = new BasicBinder();
    private Class<?> javaClass;
    private Class<? extends Annotation> qualifier;
    private Binding binding;

    public void setParameterValues(Properties parameters) {
        String mappedClassName;
        if (parameters.containsKey("javaClass")) {
            mappedClassName = parameters.getProperty("javaClass");
            try {
                this.javaClass = Class.forName(mappedClassName);
            }
            catch (ClassNotFoundException e) {
                throw new HibernateException("Specified Java class could not be found", (Throwable)e);
            }
        }
        if (parameters.containsKey("hibernateClass")) {
            mappedClassName = parameters.getProperty("hibernateClass");
            try {
                super.setIdentifierType(Class.forName(mappedClassName));
            }
            catch (ClassNotFoundException e) {
                throw new HibernateException("Specified Hibernate class could not be found", (Throwable)e);
            }
        }
        if (parameters.containsKey("qualifier")) {
            mappedClassName = parameters.getProperty("qualifier");
            try {
                Class<?> myQualifier = Class.forName(mappedClassName);
                this.qualifier = myQualifier;
            }
            catch (ClassNotFoundException e) {
                throw new HibernateException("Specified Qualifier class could not be found", (Throwable)e);
            }
        }
        if (this.javaClass == null) {
            throw new HibernateException("Java class was not defined");
        }
        if (super.getIdentifierType() == null) {
            throw new HibernateException("Hibernate class was not defined");
        }
        super.setParameterValues(parameters);
        this.binding = BINDING.findBinding(this.javaClass, this.getIdentifierType(), this.qualifier);
        if (this.binding == null) {
            throw new HibernateException("Could not resolve binding instance");
        }
    }

    public Class<?> returnedClass() {
        return this.javaClass;
    }

    public Object doNullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object identifier = this.getType().get(rs, names[0], session);
        if (rs.wasNull()) {
            return null;
        }
        Object result = this.binding.unmarshal(identifier);
        return result;
    }

    public void doNullSafeSet(PreparedStatement preparedStatement, Object value, int index, SessionImplementor session) throws SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (value == null) {
            preparedStatement.setNull(index, this.getType().sqlType());
        } else {
            Object identifier = this.binding.marshal(value);
            this.getType().nullSafeSet(preparedStatement, identifier, index, session);
        }
    }
}

