/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]4a!\u0001\u0002\u0002\u0002\u0019a!!C*qS2d\u0017M\u00197f\u0015\t\u0019A!\u0001\u0006d_2dWm\u0019;j_:T!!\u0002\u0004\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOV\u0011QbJ\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"BA\t\u0007\u0003\u0019iW-\\8ss&\u00111\u0003\u0005\u0002\u000f\u001b\u0016lwN]=D_:\u001cX/\\3s!\t)\u0002$D\u0001\u0017\u0015\t9b!\u0001\u0005j]R,'O\\1m\u0013\tIbCA\u0004M_\u001e<\u0017N\\4\t\u0011m\u0001!\u0011!Q\u0001\nu\t\u0011\u0003^1tW6+Wn\u001c:z\u001b\u0006t\u0017mZ3s\u0007\u0001\u0001\"a\u0004\u0010\n\u0005}\u0001\"!\u0005+bg.lU-\\8ss6\u000bg.Y4fe\")\u0011\u0005\u0001C\u0001E\u00051A(\u001b8jiz\"\"aI\u001a\u0011\u0007\u0011\u0002Q%D\u0001\u0003!\t1s\u0005\u0004\u0001\u0005\u000b!\u0002!\u0019A\u0015\u0003\u0003\r\u000b\"A\u000b\u0019\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\u000f9{G\u000f[5oOB\u00111&M\u0005\u0003e1\u00121!\u00118z\u0011\u0015Y\u0002\u00051\u0001\u001e\u0011\u0015)\u0004A\"\u00057\u0003\u0015\u0019\b/\u001b7m)\t9$\b\u0005\u0002,q%\u0011\u0011\b\f\u0002\u0005+:LG\u000fC\u0003\u0004i\u0001\u0007Q\u0005C\u0003=\u0001\u0019EQ(\u0001\u0006g_J\u001cWm\u00159jY2$\u0012A\u0010\t\u0003W}J!\u0001\u0011\u0017\u0003\u000f\t{w\u000e\\3b]\")!\t\u0001C\t\u0007\u0006aQ\r\\3nK:$8OU3bIV\tA\t\u0005\u0002,\u000b&\u0011a\t\f\u0002\u0004\u0013:$\b\"\u0002%\u0001\t#I\u0015aD1eI\u0016cW-\\3oiN\u0014V-\u00193\u0015\u0003]Baa\u0013\u0001!\u0002\u0013a\u0015AF5oSRL\u0017\r\\'f[>\u0014\u0018\u0010\u00165sKNDw\u000e\u001c3\u0011\u0005-j\u0015B\u0001(-\u0005\u0011auN\\4\t\rA\u0003\u0001\u0015!\u0003E\u0003yqW/\\#mK6,g\u000e^:G_J\u001cWm\u00159jY2$\u0006N]3tQ>dG\r\u0003\u0004S\u0001\u0001\u0006K\u0001T\u0001\u0012[flU-\\8ssRC'/Z:i_2$\u0007FA)U!\tYS+\u0003\u0002WY\tAao\u001c7bi&dW\r\u0003\u0004Y\u0001\u0001\u0006K\u0001R\u0001\u000e?\u0016dW-\\3oiN\u0014V-\u00193\t\ri\u0003\u0001\u0015)\u0003M\u0003MyV.Z7pef\u0014\u0015\u0010^3t'BLG\u000e\\3eQ\tIF\u000b\u0003\u0007^\u0001\u0011\u0005\tQ!A\u0001B\u0003&A)A\u001cpe\u001e$\u0013\r]1dQ\u0016$3\u000f]1sW\u0012*H/\u001b7%G>dG.Z2uS>tGe\u00159jY2\f'\r\\3%I}\u001b\b/\u001b7m\u0007>,h\u000e\u001e\u0005\u0006?\u0002!\t\u0002Y\u0001\u000b[\u0006L(-Z*qS2dGc\u0001 bE\")1A\u0018a\u0001K!)1M\u0018a\u0001\u0019\u0006i1-\u001e:sK:$X*Z7pefDQ!\u000e\u0001\u0005B\u0015$2\u0001\u00144i\u0011\u00159G\r1\u0001M\u0003\u0011\u0019\u0018N_3\t\u000b%$\u0007\u0019\u0001\b\u0002\u000fQ\u0014\u0018nZ4fe\")1\u000e\u0001C\u0001Y\u0006\u0011R.Z7pef\u0014\u0015\u0010^3t'BLG\u000e\\3e+\u0005a\u0005\"\u00028\u0001\t\u0003I\u0015!\u0004:fY\u0016\f7/Z'f[>\u0014\u0018\u0010C\u0003q\u0001\u0011%\u0011/A\u0006m_\u001e\u001c\u0006/\u001b7mC\u001e,GCA\u001cs\u0011\u00159w\u000e1\u0001MQ\tyG\u000f\u0005\u0002,k&\u0011a\u000f\f\u0002\u0007S:d\u0017N\\3")
public abstract class Spillable<C>
extends MemoryConsumer
implements Logging {
    private final TaskMemoryManager taskMemoryManager;
    private final long initialMemoryThreshold;
    private final int numElementsForceSpillThreshold;
    private volatile long myMemoryThreshold;
    private int _elementsRead;
    private volatile long _memoryBytesSpilled;
    public int org$apache$spark$util$collection$Spillable$$_spillCount;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract void spill(C var1);

    public abstract boolean forceSpill();

    public int elementsRead() {
        return this._elementsRead;
    }

    public void addElementsRead() {
        ++this._elementsRead;
    }

    public boolean maybeSpill(C collection, long currentMemory) {
        boolean shouldSpill;
        block1: {
            shouldSpill = false;
            if (this.elementsRead() % 32 == 0 && currentMemory >= this.myMemoryThreshold) {
                long amountToRequest = 2L * currentMemory - this.myMemoryThreshold;
                long granted = this.acquireMemory(amountToRequest);
                this.myMemoryThreshold += granted;
                shouldSpill = currentMemory >= this.myMemoryThreshold;
            }
            boolean bl = shouldSpill = shouldSpill || this._elementsRead > this.numElementsForceSpillThreshold;
            if (!shouldSpill) break block1;
            ++this.org$apache$spark$util$collection$Spillable$$_spillCount;
            this.logSpillage(currentMemory);
            this.spill(collection);
            this._elementsRead = 0;
            this._memoryBytesSpilled += currentMemory;
            this.releaseMemory();
        }
        return shouldSpill;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long spill(long size, MemoryConsumer trigger) {
        boolean isSpilled;
        MemoryConsumer memoryConsumer = trigger;
        Spillable spillable = this;
        if (memoryConsumer == null) {
            if (spillable == null) return 0L;
        } else if (memoryConsumer.equals(spillable)) return 0L;
        MemoryMode memoryMode = this.taskMemoryManager.getTungstenMemoryMode();
        MemoryMode memoryMode2 = MemoryMode.ON_HEAP;
        if (memoryMode == null) {
            if (memoryMode2 != null) {
                return 0L;
            }
        } else if (!((Object)((Object)memoryMode)).equals((Object)memoryMode2)) return 0L;
        if (!(isSpilled = this.forceSpill())) {
            return 0L;
        }
        long freeMemory = this.myMemoryThreshold - this.initialMemoryThreshold;
        this._memoryBytesSpilled += freeMemory;
        this.releaseMemory();
        long l = freeMemory;
        return l;
    }

    public long memoryBytesSpilled() {
        return this._memoryBytesSpilled;
    }

    public void releaseMemory() {
        this.freeMemory(this.myMemoryThreshold - this.initialMemoryThreshold);
        this.myMemoryThreshold = this.initialMemoryThreshold;
    }

    private void logSpillage(long size) {
        long threadId = Thread.currentThread().getId();
        this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Thread %d spilling in-memory map of %s to disk (%d time%s so far)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)threadId), Utils$.MODULE$.bytesToString(size), BoxesRunTime.boxToInteger((int)$this.org$apache$spark$util$collection$Spillable$$_spillCount), $this.org$apache$spark$util$collection$Spillable$$_spillCount > 1 ? "s" : ""})));
    }

    public Spillable(TaskMemoryManager taskMemoryManager) {
        this.taskMemoryManager = taskMemoryManager;
        super(taskMemoryManager);
        Logging.$init$(this);
        this.initialMemoryThreshold = SparkEnv$.MODULE$.get().conf().getLong("spark.shuffle.spill.initialMemoryThreshold", 0x500000L);
        this.numElementsForceSpillThreshold = BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.SHUFFLE_SPILL_NUM_ELEMENTS_FORCE_SPILL_THRESHOLD()));
        this.myMemoryThreshold = this.initialMemoryThreshold;
        this._elementsRead = 0;
        this._memoryBytesSpilled = 0L;
        this.org$apache$spark$util$collection$Spillable$$_spillCount = 0;
    }
}

