/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.map;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.spark.SparkEnv;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.UnsafeAlignedOffset;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.map.HashMapGrowthStrategy;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterSpillReader;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterSpillWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.annotations.VisibleForTesting;
import org.spark_project.guava.io.Closeables;

public final class BytesToBytesMap
extends MemoryConsumer {
    private static final Logger logger = LoggerFactory.getLogger(BytesToBytesMap.class);
    private static final HashMapGrowthStrategy growthStrategy = HashMapGrowthStrategy.DOUBLING;
    private final TaskMemoryManager taskMemoryManager;
    private final LinkedList<MemoryBlock> dataPages = new LinkedList();
    private MemoryBlock currentPage = null;
    private long pageCursor = 0L;
    @VisibleForTesting
    static final int MAX_CAPACITY = 0x20000000;
    @Nullable
    private LongArray longArray;
    private boolean canGrowArray = true;
    private final double loadFactor;
    private final long pageSizeBytes;
    private int numKeys;
    private int numValues;
    private int growthThreshold;
    private int mask;
    private final Location loc;
    private final boolean enablePerfMetrics;
    private long numProbes = 0L;
    private long numKeyLookups = 0L;
    private long peakMemoryUsedBytes = 0L;
    private final int initialCapacity;
    private final BlockManager blockManager;
    private final SerializerManager serializerManager;
    private volatile MapIterator destructiveIterator = null;
    private LinkedList<UnsafeSorterSpillWriter> spillWriters = new LinkedList();

    public BytesToBytesMap(TaskMemoryManager taskMemoryManager, BlockManager blockManager, SerializerManager serializerManager, int initialCapacity, double loadFactor, long pageSizeBytes, boolean enablePerfMetrics) {
        super(taskMemoryManager, pageSizeBytes, taskMemoryManager.getTungstenMemoryMode());
        this.taskMemoryManager = taskMemoryManager;
        this.blockManager = blockManager;
        this.serializerManager = serializerManager;
        this.loadFactor = loadFactor;
        this.loc = new Location();
        this.pageSizeBytes = pageSizeBytes;
        this.enablePerfMetrics = enablePerfMetrics;
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        if (initialCapacity > 0x20000000) {
            throw new IllegalArgumentException("Initial capacity " + initialCapacity + " exceeds maximum capacity of " + 0x20000000);
        }
        if (pageSizeBytes > 0x3FFFFFFF8L) {
            throw new IllegalArgumentException("Page size " + pageSizeBytes + " cannot exceed " + 0x3FFFFFFF8L);
        }
        this.initialCapacity = initialCapacity;
        this.allocate(initialCapacity);
    }

    public BytesToBytesMap(TaskMemoryManager taskMemoryManager, int initialCapacity, long pageSizeBytes) {
        this(taskMemoryManager, initialCapacity, pageSizeBytes, false);
    }

    public BytesToBytesMap(TaskMemoryManager taskMemoryManager, int initialCapacity, long pageSizeBytes, boolean enablePerfMetrics) {
        this(taskMemoryManager, SparkEnv.get() != null ? SparkEnv.get().blockManager() : null, SparkEnv.get() != null ? SparkEnv.get().serializerManager() : null, initialCapacity, 0.5, pageSizeBytes, enablePerfMetrics);
    }

    public int numKeys() {
        return this.numKeys;
    }

    public int numValues() {
        return this.numValues;
    }

    public MapIterator iterator() {
        return new MapIterator(this.numValues, this.loc, false);
    }

    public MapIterator destructiveIterator() {
        this.updatePeakMemoryUsed();
        return new MapIterator(this.numValues, this.loc, true);
    }

    public Location lookup(Object keyBase, long keyOffset, int keyLength) {
        this.safeLookup(keyBase, keyOffset, keyLength, this.loc, Murmur3_x86_32.hashUnsafeWords((Object)keyBase, (long)keyOffset, (int)keyLength, (int)42));
        return this.loc;
    }

    public Location lookup(Object keyBase, long keyOffset, int keyLength, int hash) {
        this.safeLookup(keyBase, keyOffset, keyLength, this.loc, hash);
        return this.loc;
    }

    public void safeLookup(Object keyBase, long keyOffset, int keyLength, Location loc, int hash) {
        assert (this.longArray != null);
        if (this.enablePerfMetrics) {
            ++this.numKeyLookups;
        }
        int pos = hash & this.mask;
        int step = 1;
        while (true) {
            if (this.enablePerfMetrics) {
                ++this.numProbes;
            }
            if (this.longArray.get(pos * 2) == 0L) {
                loc.with(pos, hash, false);
                return;
            }
            long stored = this.longArray.get(pos * 2 + 1);
            if ((int)stored == hash) {
                boolean areEqual;
                loc.with(pos, hash, true);
                if (loc.getKeyLength() == keyLength && (areEqual = ByteArrayMethods.arrayEquals((Object)keyBase, (long)keyOffset, (Object)loc.getKeyBase(), (long)loc.getKeyOffset(), (long)keyLength))) {
                    return;
                }
            }
            pos = pos + step & this.mask;
            ++step;
        }
    }

    private boolean acquireNewPage(long required) {
        try {
            this.currentPage = this.allocatePage(required);
        }
        catch (OutOfMemoryError e) {
            return false;
        }
        this.dataPages.add(this.currentPage);
        UnsafeAlignedOffset.putSize((Object)this.currentPage.getBaseObject(), (long)this.currentPage.getBaseOffset(), (int)0);
        this.pageCursor = UnsafeAlignedOffset.getUaoSize();
        return true;
    }

    @Override
    public long spill(long size, MemoryConsumer trigger) throws IOException {
        if (trigger != this && this.destructiveIterator != null) {
            return this.destructiveIterator.spill(size);
        }
        return 0L;
    }

    private void allocate(int capacity) {
        assert (capacity >= 0);
        capacity = Math.max((int)Math.min(0x20000000L, ByteArrayMethods.nextPowerOf2((long)capacity)), 64);
        assert (capacity <= 0x20000000);
        this.longArray = this.allocateArray(capacity * 2);
        this.longArray.zeroOut();
        this.growthThreshold = (int)((double)capacity * this.loadFactor);
        this.mask = capacity - 1;
    }

    public void free() {
        this.updatePeakMemoryUsed();
        if (this.longArray != null) {
            this.freeArray(this.longArray);
            this.longArray = null;
        }
        Iterator dataPagesIterator = this.dataPages.iterator();
        while (dataPagesIterator.hasNext()) {
            MemoryBlock dataPage = (MemoryBlock)dataPagesIterator.next();
            dataPagesIterator.remove();
            this.freePage(dataPage);
        }
        assert (this.dataPages.isEmpty());
        while (!this.spillWriters.isEmpty()) {
            File file = this.spillWriters.removeFirst().getFile();
            if (file == null || !file.exists() || file.delete()) continue;
            logger.error("Was unable to delete spill file {}", (Object)file.getAbsolutePath());
        }
    }

    public TaskMemoryManager getTaskMemoryManager() {
        return this.taskMemoryManager;
    }

    public long getPageSizeBytes() {
        return this.pageSizeBytes;
    }

    public long getTotalMemoryConsumption() {
        long totalDataPagesSize = 0L;
        for (MemoryBlock dataPage : this.dataPages) {
            totalDataPagesSize += dataPage.size();
        }
        return totalDataPagesSize + (this.longArray != null ? this.longArray.memoryBlock().size() : 0L);
    }

    private void updatePeakMemoryUsed() {
        long mem = this.getTotalMemoryConsumption();
        if (mem > this.peakMemoryUsedBytes) {
            this.peakMemoryUsedBytes = mem;
        }
    }

    public long getPeakMemoryUsedBytes() {
        this.updatePeakMemoryUsed();
        return this.peakMemoryUsedBytes;
    }

    public double getAverageProbesPerLookup() {
        if (!this.enablePerfMetrics) {
            throw new IllegalStateException();
        }
        return 1.0 * (double)this.numProbes / (double)this.numKeyLookups;
    }

    @VisibleForTesting
    public int getNumDataPages() {
        return this.dataPages.size();
    }

    public LongArray getArray() {
        assert (this.longArray != null);
        return this.longArray;
    }

    public void reset() {
        this.updatePeakMemoryUsed();
        this.numKeys = 0;
        this.numValues = 0;
        this.freeArray(this.longArray);
        while (this.dataPages.size() > 0) {
            MemoryBlock dataPage = this.dataPages.removeLast();
            this.freePage(dataPage);
        }
        this.allocate(this.initialCapacity);
        this.canGrowArray = true;
        this.currentPage = null;
        this.pageCursor = 0L;
    }

    @VisibleForTesting
    void growAndRehash() {
        assert (this.longArray != null);
        LongArray oldLongArray = this.longArray;
        int oldCapacity = (int)oldLongArray.size() / 2;
        this.allocate(Math.min(growthStrategy.nextCapacity(oldCapacity), 0x20000000));
        int i = 0;
        while ((long)i < oldLongArray.size()) {
            long keyPointer = oldLongArray.get(i);
            if (keyPointer != 0L) {
                int hashcode = (int)oldLongArray.get(i + 1);
                int newPos = hashcode & this.mask;
                int step = 1;
                while (this.longArray.get(newPos * 2) != 0L) {
                    newPos = newPos + step & this.mask;
                    ++step;
                }
                this.longArray.set(newPos * 2, keyPointer);
                this.longArray.set(newPos * 2 + 1, (long)hashcode);
            }
            i += 2;
        }
        this.freeArray(oldLongArray);
    }

    public final class Location {
        private int pos;
        private boolean isDefined;
        private int keyHashcode;
        private Object baseObject;
        private long keyOffset;
        private int keyLength;
        private long valueOffset;
        private int valueLength;
        @Nullable
        private MemoryBlock memoryPage;

        private void updateAddressesAndSizes(long fullKeyAddress) {
            this.updateAddressesAndSizes(BytesToBytesMap.this.taskMemoryManager.getPage(fullKeyAddress), BytesToBytesMap.this.taskMemoryManager.getOffsetInPage(fullKeyAddress));
        }

        private void updateAddressesAndSizes(Object base, long offset) {
            this.baseObject = base;
            int totalLength = UnsafeAlignedOffset.getSize((Object)base, (long)offset);
            int uaoSize = UnsafeAlignedOffset.getUaoSize();
            this.keyLength = UnsafeAlignedOffset.getSize((Object)base, (long)(offset += (long)uaoSize));
            this.keyOffset = offset += (long)uaoSize;
            this.valueOffset = offset + (long)this.keyLength;
            this.valueLength = totalLength - this.keyLength - uaoSize;
        }

        private Location with(int pos, int keyHashcode, boolean isDefined) {
            assert (BytesToBytesMap.this.longArray != null);
            this.pos = pos;
            this.isDefined = isDefined;
            this.keyHashcode = keyHashcode;
            if (isDefined) {
                long fullKeyAddress = BytesToBytesMap.this.longArray.get(pos * 2);
                this.updateAddressesAndSizes(fullKeyAddress);
            }
            return this;
        }

        private Location with(MemoryBlock page, long offsetInPage) {
            this.isDefined = true;
            this.memoryPage = page;
            this.updateAddressesAndSizes(page.getBaseObject(), offsetInPage);
            return this;
        }

        private Location with(Object base, long offset, int length) {
            this.isDefined = true;
            this.memoryPage = null;
            this.baseObject = base;
            int uaoSize = UnsafeAlignedOffset.getUaoSize();
            this.keyOffset = offset + (long)uaoSize;
            this.keyLength = UnsafeAlignedOffset.getSize((Object)base, (long)offset);
            this.valueOffset = offset + (long)uaoSize + (long)this.keyLength;
            this.valueLength = length - uaoSize - this.keyLength;
            return this;
        }

        public boolean nextValue() {
            assert (this.isDefined);
            long nextAddr = Platform.getLong((Object)this.baseObject, (long)(this.valueOffset + (long)this.valueLength));
            if (nextAddr == 0L) {
                return false;
            }
            this.updateAddressesAndSizes(nextAddr);
            return true;
        }

        public MemoryBlock getMemoryPage() {
            return this.memoryPage;
        }

        public boolean isDefined() {
            return this.isDefined;
        }

        public Object getKeyBase() {
            assert (this.isDefined);
            return this.baseObject;
        }

        public long getKeyOffset() {
            assert (this.isDefined);
            return this.keyOffset;
        }

        public Object getValueBase() {
            assert (this.isDefined);
            return this.baseObject;
        }

        public long getValueOffset() {
            assert (this.isDefined);
            return this.valueOffset;
        }

        public int getKeyLength() {
            assert (this.isDefined);
            return this.keyLength;
        }

        public int getValueLength() {
            assert (this.isDefined);
            return this.valueLength;
        }

        public boolean append(Object kbase, long koff, int klen, Object vbase, long voff, int vlen) {
            long offset;
            assert (klen % 8 == 0);
            assert (vlen % 8 == 0);
            assert (BytesToBytesMap.this.longArray != null);
            if (BytesToBytesMap.this.numKeys == 0x20000000 || !BytesToBytesMap.this.canGrowArray && BytesToBytesMap.this.numKeys >= BytesToBytesMap.this.growthThreshold) {
                return false;
            }
            int uaoSize = UnsafeAlignedOffset.getUaoSize();
            long recordLength = 2L * (long)uaoSize + (long)klen + (long)vlen + 8L;
            if (!(BytesToBytesMap.this.currentPage != null && BytesToBytesMap.this.currentPage.size() - BytesToBytesMap.this.pageCursor >= recordLength || BytesToBytesMap.this.acquireNewPage(recordLength + (long)uaoSize))) {
                return false;
            }
            Object base = BytesToBytesMap.this.currentPage.getBaseObject();
            long recordOffset = offset = BytesToBytesMap.this.currentPage.getBaseOffset() + BytesToBytesMap.this.pageCursor;
            UnsafeAlignedOffset.putSize((Object)base, (long)offset, (int)(klen + vlen + uaoSize));
            UnsafeAlignedOffset.putSize((Object)base, (long)(offset + (long)uaoSize), (int)klen);
            Platform.copyMemory((Object)kbase, (long)koff, (Object)base, (long)(offset += (long)(2 * uaoSize)), (long)klen);
            Platform.copyMemory((Object)vbase, (long)voff, (Object)base, (long)(offset += (long)klen), (long)vlen);
            Platform.putLong((Object)base, (long)(offset += (long)vlen), (long)(this.isDefined ? BytesToBytesMap.this.longArray.get(this.pos * 2) : 0L));
            offset = BytesToBytesMap.this.currentPage.getBaseOffset();
            UnsafeAlignedOffset.putSize((Object)base, (long)offset, (int)(UnsafeAlignedOffset.getSize((Object)base, (long)offset) + 1));
            BytesToBytesMap.this.pageCursor = BytesToBytesMap.this.pageCursor + recordLength;
            long storedKeyAddress = BytesToBytesMap.this.taskMemoryManager.encodePageNumberAndOffset(BytesToBytesMap.this.currentPage, recordOffset);
            BytesToBytesMap.this.longArray.set(this.pos * 2, storedKeyAddress);
            this.updateAddressesAndSizes(storedKeyAddress);
            BytesToBytesMap.this.numValues++;
            if (!this.isDefined) {
                BytesToBytesMap.this.numKeys++;
                BytesToBytesMap.this.longArray.set(this.pos * 2 + 1, (long)this.keyHashcode);
                this.isDefined = true;
                if (BytesToBytesMap.this.numKeys >= BytesToBytesMap.this.growthThreshold && BytesToBytesMap.this.longArray.size() < 0x20000000L) {
                    try {
                        BytesToBytesMap.this.growAndRehash();
                    }
                    catch (OutOfMemoryError oom) {
                        BytesToBytesMap.this.canGrowArray = false;
                    }
                }
            }
            return true;
        }
    }

    public final class MapIterator
    implements Iterator<Location> {
        private int numRecords;
        private final Location loc;
        private MemoryBlock currentPage = null;
        private int recordsInPage = 0;
        private Object pageBaseObject;
        private long offsetInPage;
        private boolean destructive = false;
        private UnsafeSorterSpillReader reader = null;

        private MapIterator(int numRecords, Location loc, boolean destructive) {
            this.numRecords = numRecords;
            this.loc = loc;
            this.destructive = destructive;
            if (destructive) {
                BytesToBytesMap.this.destructiveIterator = this;
                if (BytesToBytesMap.this.longArray != null) {
                    BytesToBytesMap.this.freeArray(BytesToBytesMap.this.longArray);
                    BytesToBytesMap.this.longArray = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void advanceToNextPage() {
            MapIterator mapIterator = this;
            synchronized (mapIterator) {
                int nextIdx = BytesToBytesMap.this.dataPages.indexOf(this.currentPage) + 1;
                if (this.destructive && this.currentPage != null) {
                    BytesToBytesMap.this.dataPages.remove(this.currentPage);
                    BytesToBytesMap.this.freePage(this.currentPage);
                    --nextIdx;
                }
                if (BytesToBytesMap.this.dataPages.size() > nextIdx) {
                    this.currentPage = (MemoryBlock)BytesToBytesMap.this.dataPages.get(nextIdx);
                    this.pageBaseObject = this.currentPage.getBaseObject();
                    this.offsetInPage = this.currentPage.getBaseOffset();
                    this.recordsInPage = UnsafeAlignedOffset.getSize((Object)this.pageBaseObject, (long)this.offsetInPage);
                    this.offsetInPage += (long)UnsafeAlignedOffset.getUaoSize();
                } else {
                    this.currentPage = null;
                    if (this.reader != null) {
                        this.handleFailedDelete();
                    }
                    try {
                        Closeables.close((Closeable)this.reader, (boolean)false);
                        this.reader = ((UnsafeSorterSpillWriter)BytesToBytesMap.this.spillWriters.getFirst()).getReader(BytesToBytesMap.this.serializerManager);
                        this.recordsInPage = -1;
                    }
                    catch (IOException e) {
                        Platform.throwException((Throwable)e);
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.numRecords == 0 && this.reader != null) {
                this.handleFailedDelete();
            }
            return this.numRecords > 0;
        }

        @Override
        public Location next() {
            if (this.recordsInPage == 0) {
                this.advanceToNextPage();
            }
            --this.numRecords;
            if (this.currentPage != null) {
                int totalLength = UnsafeAlignedOffset.getSize((Object)this.pageBaseObject, (long)this.offsetInPage);
                this.loc.with(this.currentPage, this.offsetInPage);
                this.offsetInPage += (long)(UnsafeAlignedOffset.getUaoSize() + totalLength + 8);
                --this.recordsInPage;
                return this.loc;
            }
            assert (this.reader != null);
            if (!this.reader.hasNext()) {
                this.advanceToNextPage();
            }
            try {
                this.reader.loadNext();
            }
            catch (IOException e) {
                try {
                    this.reader.close();
                }
                catch (IOException e2) {
                    logger.error("Error while closing spill reader", (Throwable)e2);
                }
                Platform.throwException((Throwable)e);
            }
            this.loc.with(this.reader.getBaseObject(), this.reader.getBaseOffset(), this.reader.getRecordLength());
            return this.loc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long spill(long numBytes) throws IOException {
            MapIterator mapIterator = this;
            synchronized (mapIterator) {
                MemoryBlock block;
                if (!this.destructive || BytesToBytesMap.this.dataPages.size() == 1) {
                    return 0L;
                }
                BytesToBytesMap.this.updatePeakMemoryUsed();
                ShuffleWriteMetrics writeMetrics = new ShuffleWriteMetrics();
                long released = 0L;
                while (BytesToBytesMap.this.dataPages.size() > 0 && (block = (MemoryBlock)BytesToBytesMap.this.dataPages.getLast()) != this.currentPage) {
                    Object base = block.getBaseObject();
                    long offset = block.getBaseOffset();
                    int numRecords = UnsafeAlignedOffset.getSize((Object)base, (long)offset);
                    int uaoSize = UnsafeAlignedOffset.getUaoSize();
                    offset += (long)uaoSize;
                    UnsafeSorterSpillWriter writer = new UnsafeSorterSpillWriter(BytesToBytesMap.this.blockManager, 32768, writeMetrics, numRecords);
                    while (numRecords > 0) {
                        int length = UnsafeAlignedOffset.getSize((Object)base, (long)offset);
                        writer.write(base, offset + (long)uaoSize, length, 0L);
                        offset += (long)(uaoSize + length + 8);
                        --numRecords;
                    }
                    writer.close();
                    BytesToBytesMap.this.spillWriters.add(writer);
                    BytesToBytesMap.this.dataPages.removeLast();
                    BytesToBytesMap.this.freePage(block);
                    if ((released += block.size()) < numBytes) continue;
                    break;
                }
                return released;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void handleFailedDelete() {
            File file = ((UnsafeSorterSpillWriter)BytesToBytesMap.this.spillWriters.removeFirst()).getFile();
            if (file != null && file.exists() && !file.delete()) {
                logger.error("Was unable to delete spill file {}", (Object)file.getAbsolutePath());
            }
        }
    }
}

