/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import java.io.Serializable;
import java.net.URLEncoder;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.RDDPartitionInfo;
import org.apache.spark.ui.PagedTable;
import org.apache.spark.ui.storage.BlockDataSource;
import org.apache.spark.ui.storage.BlockTableRowData;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!B\u0001\u0003\u0001\u0011a!a\u0004\"m_\u000e\\\u0007+Y4fIR\u000b'\r\\3\u000b\u0005\r!\u0011aB:u_J\fw-\u001a\u0006\u0003\u000b\u0019\t!!^5\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0019A#F\f\u000e\u0003\u0011I!A\u0006\u0003\u0003\u0015A\u000bw-\u001a3UC\ndW\r\u0005\u0002\u001935\t!!\u0003\u0002\u001b\u0005\t\t\"\t\\8dWR\u000b'\r\\3S_^$\u0015\r^1\t\u0011q\u0001!\u0011!Q\u0001\ny\t\u0001BY1tKB\u000bG\u000f[\u0002\u0001!\tybE\u0004\u0002!IA\u0011\u0011eD\u0007\u0002E)\u00111%H\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015z\u0011A\u0002)sK\u0012,g-\u0003\u0002(Q\t11\u000b\u001e:j]\u001eT!!J\b\t\u0011)\u0002!\u0011!Q\u0001\n-\nQB\u001d3e!\u0006\u0014H/\u001b;j_:\u001c\bc\u0001\u00172i9\u0011Qf\f\b\u0003C9J\u0011\u0001E\u0005\u0003a=\tq\u0001]1dW\u0006<W-\u0003\u00023g\t\u00191+Z9\u000b\u0005Az\u0001CA\u001b=\u001b\u00051$BA\u001c9\u0003\t1\u0018G\u0003\u0002:u\u0005\u0019\u0011\r]5\u000b\u0005m2\u0011AB:uCR,8/\u0003\u0002>m\t\u0001\"\u000b\u0012#QCJ$\u0018\u000e^5p]&sgm\u001c\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u0006A\u0001/Y4f'&TX\r\u0005\u0002\u000f\u0003&\u0011!i\u0004\u0002\u0004\u0013:$\b\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u0015M|'\u000f^\"pYVlg\u000e\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0003\u0011!Wm]2\u0011\u00059A\u0015BA%\u0010\u0005\u001d\u0011un\u001c7fC:D\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001T\u0001\u0012Kb,7-\u001e;peN+X.\\1sS\u0016\u001c\bc\u0001\u00172\u001bB\u0011QGT\u0005\u0003\u001fZ\u0012q\"\u0012=fGV$xN]*v[6\f'/\u001f\u0005\u0006#\u0002!\tAU\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fM#VKV,Y3B\u0011\u0001\u0004\u0001\u0005\u00069A\u0003\rA\b\u0005\u0006UA\u0003\ra\u000b\u0005\u0006\u007fA\u0003\r\u0001\u0011\u0005\u0006\tB\u0003\rA\b\u0005\u0006\rB\u0003\ra\u0012\u0005\u0006\u0017B\u0003\r\u0001\u0014\u0005\u00067\u0002!\t\u0005X\u0001\bi\u0006\u0014G.Z%e+\u0005q\u0002\"\u00020\u0001\t\u0003b\u0016!\u0004;bE2,7i]:DY\u0006\u001c8\u000fC\u0003a\u0001\u0011\u0005C,A\tqC\u001e,7+\u001b>f\r>\u0014XNR5fY\u0012DQA\u0019\u0001\u0005Bq\u000bQ\u0003\u001d:fmB\u000bw-Z*ju\u00164uN]7GS\u0016dG\rC\u0003e\u0001\u0011\u0005C,A\nqC\u001e,g*^7cKJ4uN]7GS\u0016dG\rC\u0004g\u0001\t\u0007I\u0011I4\u0002\u0015\u0011\fG/Y*pkJ\u001cW-F\u0001i!\tA\u0012.\u0003\u0002k\u0005\ty!\t\\8dW\u0012\u000bG/Y*pkJ\u001cW\r\u0003\u0004m\u0001\u0001\u0006I\u0001[\u0001\fI\u0006$\u0018mU8ve\u000e,\u0007\u0005C\u0003o\u0001\u0011\u0005s.\u0001\u0005qC\u001e,G*\u001b8l)\tq\u0002\u000fC\u0003r[\u0002\u0007\u0001)\u0001\u0003qC\u001e,\u0007\"B:\u0001\t\u0003b\u0016\u0001E4p\u0005V$Ho\u001c8G_Jl\u0007+\u0019;i\u0011\u0015)\b\u0001\"\u0011w\u0003\u001dAW-\u00193feN,\u0012a\u001e\t\u0004YEB\bCA=}\u001b\u0005Q(BA>\u0010\u0003\rAX\u000e\\\u0005\u0003{j\u0014AAT8eK\"1q\u0010\u0001C!\u0003\u0003\t1A]8x)\r9\u00181\u0001\u0005\u0007\u0003\u000bq\b\u0019A\f\u0002\u000b\tdwnY6")
public class BlockPagedTable
implements PagedTable<BlockTableRowData> {
    private final String basePath;
    private final int pageSize;
    private final String sortColumn;
    private final boolean desc;
    private final BlockDataSource dataSource;

    @Override
    public Seq<Node> table(int page) {
        return PagedTable.table$(this, page);
    }

    @Override
    public Seq<Node> pageNavigation(int page, int pageSize, int totalPages) {
        return PagedTable.pageNavigation$(this, page, pageSize, totalPages);
    }

    @Override
    public String tableId() {
        return "rdd-storage-by-block-table";
    }

    @Override
    public String tableCssClass() {
        return "table table-bordered table-condensed table-striped table-head-clickable";
    }

    @Override
    public String pageSizeFormField() {
        return "block.pageSize";
    }

    @Override
    public String prevPageSizeFormField() {
        return "block.prevPageSize";
    }

    @Override
    public String pageNumberFormField() {
        return "block.page";
    }

    public BlockDataSource dataSource() {
        return this.dataSource;
    }

    @Override
    public String pageLink(int page) {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn, "UTF-8");
        return new StringBuilder(0).append(this.basePath).append(new StringBuilder(2).append("&").append(this.pageNumberFormField()).append("=").append(page).toString()).append(new StringBuilder(12).append("&block.sort=").append(encodedSortColumn).toString()).append(new StringBuilder(12).append("&block.desc=").append(this.desc).toString()).append(new StringBuilder(2).append("&").append(this.pageSizeFormField()).append("=").append(this.pageSize).toString()).toString();
    }

    @Override
    public String goButtonFormPath() {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn, "UTF-8");
        return new StringBuilder(24).append(this.basePath).append("&block.sort=").append(encodedSortColumn).append("&block.desc=").append(this.desc).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Node> headers() {
        void var3_3;
        Seq blockHeaders = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Block Name", "Storage Level", "Size in Memory", "Size on Disk", "Executors"}));
        if (!blockHeaders.contains((Object)this.sortColumn)) {
            throw new IllegalArgumentException(new StringBuilder(16).append("Unknown column: ").append(this.sortColumn).toString());
        }
        Seq headerRow = (Seq)blockHeaders.map((Function1 & Serializable & scala.Serializable)header -> {
            Elem elem;
            String string = header;
            String string2 = $this.sortColumn;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Unparsed headerLink = Unparsed$.MODULE$.apply(new StringBuilder(0).append($this.basePath).append(new StringBuilder(12).append("&block.sort=").append(URLEncoder.encode(header, "UTF-8")).toString()).append(new StringBuilder(12).append("&block.desc=").append(!$this.desc).toString()).append(new StringBuilder(16).append("&block.pageSize=").append($this.pageSize).toString()).toString());
                String arrow = $this.desc ? "&#x25BE;" : "&#x25B4;";
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("href", (Seq)headerLink, (MetaData)$md);
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n              "));
                $buf2.$amp$plus(header);
                $buf2.$amp$plus((Object)new Text("\n              "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new EntityRef("nbsp"));
                $buf3.$amp$plus((Object)Unparsed$.MODULE$.apply(arrow));
                $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                $buf2.$amp$plus((Object)new Text("\n            "));
                $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n          "));
                Elem elem2 = new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                elem = elem2;
            } else {
                Unparsed headerLink = Unparsed$.MODULE$.apply(new StringBuilder(0).append($this.basePath).append(new StringBuilder(12).append("&block.sort=").append(URLEncoder.encode(header, "UTF-8")).toString()).append(new StringBuilder(16).append("&block.pageSize=").append($this.pageSize).toString()).toString());
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            "));
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("href", (Seq)headerLink, (MetaData)$md);
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus((Object)new Text("\n              "));
                $buf4.$amp$plus(header);
                $buf4.$amp$plus((Object)new Text("\n            "));
                $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                $buf.$amp$plus((Object)new Text("\n          "));
                Elem elem3 = new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                elem = elem3;
            }
            return elem;
        }, Seq$.MODULE$.canBuildFrom());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)headerRow);
        return new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Node> row(BlockTableRowData block) {
        void var2_2;
        void var3_3;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)block.blockName());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)block.storageLevel());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)Utils$.MODULE$.bytesToString(block.memoryUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)Utils$.MODULE$.bytesToString(block.diskUsed()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)block.executors());
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    public BlockPagedTable(String basePath, Seq<RDDPartitionInfo> rddPartitions, int pageSize, String sortColumn, boolean desc, Seq<ExecutorSummary> executorSummaries) {
        this.basePath = basePath;
        this.pageSize = pageSize;
        this.sortColumn = sortColumn;
        this.desc = desc;
        PagedTable.$init$(this);
        this.dataSource = new BlockDataSource(rddPartitions, pageSize, sortColumn, desc, (Map<String, String>)((TraversableOnce)executorSummaries.map((Function1 & Serializable & scala.Serializable)ex -> new Tuple2((Object)ex.id(), (Object)ex.hostPort()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }
}

