/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.CountingWritableChannel;
import org.apache.spark.storage.DiskBlockData;
import org.apache.spark.storage.DiskBlockManager;
import org.apache.spark.storage.EncryptedBlockData;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import org.spark_project.guava.io.Closeables;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb!B\u0001\u0003\u0001\u0011Q!!\u0003#jg.\u001cFo\u001c:f\u0015\t\u0019A!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0012!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0011!#F\u0007\u0002')\u0011A\u0003B\u0001\tS:$XM\u001d8bY&\u0011ac\u0005\u0002\b\u0019><w-\u001b8h\u0011!A\u0002A!A!\u0002\u0013Q\u0012\u0001B2p]\u001a\u001c\u0001\u0001\u0005\u0002\u001c95\tA!\u0003\u0002\u001e\t\tI1\u000b]1sW\u000e{gN\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005YA-[:l\u001b\u0006t\u0017mZ3s!\t\t#%D\u0001\u0003\u0013\t\u0019#A\u0001\tESN\\'\t\\8dW6\u000bg.Y4fe\"AQ\u0005\u0001B\u0001B\u0003%a%A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\tYr%\u0003\u0002)\t\ty1+Z2ve&$\u00180T1oC\u001e,'\u000fC\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0005Y5rs\u0006\u0005\u0002\"\u0001!)\u0001$\u000ba\u00015!)q$\u000ba\u0001A!)Q%\u000ba\u0001M!9\u0011\u0007\u0001b\u0001\n\u0013\u0011\u0014!E7j]6+Wn\u001c:z\u001b\u0006\u0004()\u001f;fgV\t1\u0007\u0005\u0002\ri%\u0011Q'\u0004\u0002\u0005\u0019>tw\r\u0003\u00048\u0001\u0001\u0006IaM\u0001\u0013[&tW*Z7pefl\u0015\r\u001d\"zi\u0016\u001c\b\u0005C\u0004:\u0001\t\u0007I\u0011\u0002\u001a\u0002#5\f\u00070T3n_JLX*\u00199CsR,7\u000f\u0003\u0004<\u0001\u0001\u0006IaM\u0001\u0013[\u0006DX*Z7pefl\u0015\r\u001d\"zi\u0016\u001c\b\u0005C\u0004>\u0001\t\u0007I\u0011\u0002 \u0002\u0015\tdwnY6TSj,7/F\u0001@!\u0011\u0001u)S\u001a\u000e\u0003\u0005S!AQ\"\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002E\u000b\u0006!Q\u000f^5m\u0015\u00051\u0015\u0001\u00026bm\u0006L!\u0001S!\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002\"\u0015&\u00111J\u0001\u0002\b\u00052|7m[%e\u0011\u0019i\u0005\u0001)A\u0005\u007f\u0005Y!\r\\8dWNK'0Z:!\u0011\u0015y\u0005\u0001\"\u0001Q\u0003\u001d9W\r^*ju\u0016$\"aM)\t\u000bIs\u0005\u0019A%\u0002\u000f\tdwnY6JI\")A\u000b\u0001C\u0001+\u0006\u0019\u0001/\u001e;\u0015\u0005Y;GCA,[!\ta\u0001,\u0003\u0002Z\u001b\t!QK\\5u\u0011\u0015Y6\u000b1\u0001]\u0003%9(/\u001b;f\rVt7\r\u0005\u0003\r;~;\u0016B\u00010\u000e\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006A1\r[1o]\u0016d7O\u0003\u0002e\u000b\u0006\u0019a.[8\n\u0005\u0019\f'aE,sSR\f'\r\\3CsR,7\t[1o]\u0016d\u0007\"\u0002*T\u0001\u0004I\u0005\"B5\u0001\t\u0003Q\u0017\u0001\u00039vi\nKH/Z:\u0015\u0007][G\u000eC\u0003SQ\u0002\u0007\u0011\nC\u0003nQ\u0002\u0007a.A\u0003csR,7\u000f\u0005\u0002pg6\t\u0001O\u0003\u0002re\u0006\u0011\u0011n\u001c\u0006\u0003\t\u0012I!\u0001\u001e9\u0003#\rCWO\\6fI\nKH/\u001a\"vM\u001a,'\u000fC\u0003w\u0001\u0011\u0005q/\u0001\u0005hKR\u0014\u0015\u0010^3t)\tA8\u0010\u0005\u0002\"s&\u0011!P\u0001\u0002\n\u00052|7m\u001b#bi\u0006DQAU;A\u0002%CQ! \u0001\u0005\u0002y\faA]3n_Z,GcA@\u0002\u0006A\u0019A\"!\u0001\n\u0007\u0005\rQBA\u0004C_>dW-\u00198\t\u000bIc\b\u0019A%\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f\u0005A1m\u001c8uC&t7\u000fF\u0002\u0000\u0003\u001bAaAUA\u0004\u0001\u0004I\u0005bBA\t\u0001\u0011%\u00111C\u0001\r_B,gNR8s/JLG/\u001a\u000b\u0004?\u0006U\u0001\u0002CA\f\u0003\u001f\u0001\r!!\u0007\u0002\t\u0019LG.\u001a\t\u0005\u00037\ty\"\u0004\u0002\u0002\u001e)\u0011\u0011/R\u0005\u0005\u0003C\tiB\u0001\u0003GS2,\u0007")
public class DiskStore
implements Logging {
    private final SparkConf conf;
    private final DiskBlockManager diskManager;
    private final SecurityManager securityManager;
    private final long minMemoryMapBytes;
    private final long maxMemoryMapBytes;
    private final ConcurrentHashMap<BlockId, Object> blockSizes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long minMemoryMapBytes() {
        return this.minMemoryMapBytes;
    }

    private long maxMemoryMapBytes() {
        return this.maxMemoryMapBytes;
    }

    private ConcurrentHashMap<BlockId, Object> blockSizes() {
        return this.blockSizes;
    }

    public long getSize(BlockId blockId) {
        return BoxesRunTime.unboxToLong((Object)this.blockSizes().get(blockId));
    }

    public void put(BlockId blockId, Function1<WritableByteChannel, BoxedUnit> writeFunc) {
        if (this.contains(blockId)) {
            throw new IllegalStateException(new StringBuilder(43).append("Block ").append(blockId).append(" is already present in the disk store").toString());
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Attempting to put block ").append(blockId).toString());
        long startTime = System.currentTimeMillis();
        File file = this.diskManager.getFile(blockId);
        CountingWritableChannel out = new CountingWritableChannel(this.openForWrite(file));
        boolean threwException = true;
        try {
            writeFunc.apply((Object)out);
            this.blockSizes().put(blockId, BoxesRunTime.boxToLong((long)out.getCount()));
            threwException = false;
        }
        finally {
            try {
                try {
                    out.close();
                }
                catch (IOException ioe) {
                    if (!threwException) {
                        threwException = true;
                        throw ioe;
                    }
                }
            }
            finally {
                if (threwException) {
                    this.remove(blockId);
                }
            }
        }
        long finishTime = System.currentTimeMillis();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Block %s stored as %s file on disk in %d ms")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getName(), Utils$.MODULE$.bytesToString(file.length()), BoxesRunTime.boxToLong((long)(finishTime - startTime))})));
    }

    public void putBytes(BlockId blockId, ChunkedByteBuffer bytes) {
        this.put(blockId, (Function1<WritableByteChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)channel -> {
            bytes.writeFully(channel);
            return BoxedUnit.UNIT;
        });
    }

    public BlockData getBytes(BlockId blockId) {
        BlockData blockData;
        File file = this.diskManager.getFile(blockId.name());
        long blockSize = this.getSize(blockId);
        Option<byte[]> option = this.securityManager.getIOEncryptionKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            byte[] key = (byte[])some.value();
            blockData = new EncryptedBlockData(file, blockSize, this.conf, key);
        } else {
            blockData = new DiskBlockData(this.minMemoryMapBytes(), this.maxMemoryMapBytes(), file, blockSize);
        }
        return blockData;
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(BlockId blockId) {
        boolean bl;
        this.blockSizes().remove(blockId);
        File file = this.diskManager.getFile(blockId.name());
        if (file.exists()) {
            void var3_3;
            boolean ret = file.delete();
            if (!ret) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error deleting ").append(file.getPath()).toString());
            }
            bl = var3_3;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean contains(BlockId blockId) {
        File file = this.diskManager.getFile(blockId.name());
        return file.exists();
    }

    private WritableByteChannel openForWrite(File file) {
        WritableByteChannel writableByteChannel;
        FileChannel out = new FileOutputStream(file).getChannel();
        try {
            writableByteChannel = (WritableByteChannel)this.securityManager.getIOEncryptionKey().map((Function1 & Serializable & scala.Serializable)key -> CryptoStreamUtils$.MODULE$.createWritableChannel(out, $this.conf, (byte[])key)).getOrElse((Function0 & Serializable & scala.Serializable)() -> out);
        }
        catch (Exception e) {
            Closeables.close((Closeable)out, (boolean)true);
            file.delete();
            throw e;
        }
        return writableByteChannel;
    }

    public DiskStore(SparkConf conf, DiskBlockManager diskManager, SecurityManager securityManager) {
        this.conf = conf;
        this.diskManager = diskManager;
        this.securityManager = securityManager;
        Logging.$init$(this);
        this.minMemoryMapBytes = conf.getSizeAsBytes("spark.storage.memoryMapThreshold", "2m");
        this.maxMemoryMapBytes = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.MEMORY_MAP_LIMIT_FOR_TESTS()));
        this.blockSizes = new ConcurrentHashMap();
    }
}

