/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerBlockUpdated;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.storage.BlockManagerInfo;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.BlockManagerMessages$GetBlockStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetMatchingBlockIds$;
import org.apache.spark.storage.BlockManagerMessages$GetMemoryStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetStorageStatus$;
import org.apache.spark.storage.BlockManagerMessages$StopBlockManagerMaster$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockUpdatedInfo$;
import org.apache.spark.storage.DefaultTopologyMapper;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.storage.TestBlockId;
import org.apache.spark.storage.TopologyMapper;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.SetLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t]f!B\u0001\u0003\u0001\u0011Q!A\u0007\"m_\u000e\\W*\u00198bO\u0016\u0014X*Y:uKJ,e\u000e\u001a9pS:$(BA\u0002\u0005\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\n\u0005\u0001-\tr\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Ui\u0011a\u0005\u0006\u0003)\u0011\t1A\u001d9d\u0013\t12CA\u000bUQJ,\u0017\rZ*bM\u0016\u0014\u0006oY#oIB|\u0017N\u001c;\u0011\u0005aYR\"A\r\u000b\u0005i!\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005qI\"a\u0002'pO\u001eLgn\u001a\u0005\t=\u0001\u0011)\u0019!C!A\u00051!\u000f]2F]Z\u001c\u0001!F\u0001\"!\t\u0011\"%\u0003\u0002$'\t1!\u000b]2F]ZD\u0001\"\n\u0001\u0003\u0002\u0003\u0006I!I\u0001\beB\u001cWI\u001c<!\u0011!9\u0003A!b\u0001\n\u0003A\u0013aB5t\u0019>\u001c\u0017\r\\\u000b\u0002SA\u0011ABK\u0005\u0003W5\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003*\u0003!I7\u000fT8dC2\u0004\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\t\r|gN\u001a\t\u0003cIj\u0011\u0001B\u0005\u0003g\u0011\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011U\u0002!\u0011!Q\u0001\nY\n1\u0002\\5ti\u0016tWM\u001d\"vgB\u0011qGO\u0007\u0002q)\u0011\u0011\bB\u0001\ng\u000eDW\rZ;mKJL!a\u000f\u001d\u0003\u001f1Kg/\u001a'jgR,g.\u001a:CkNDQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtD#B B\u0005\u000e#\u0005C\u0001!\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010=\u0001\u0004\t\u0003\"B\u0014=\u0001\u0004I\u0003\"B\u0018=\u0001\u0004\u0001\u0004\"B\u001b=\u0001\u00041\u0004b\u0002$\u0001\u0005\u0004%IaR\u0001\u0011E2|7m['b]\u0006<WM]%oM>,\u0012\u0001\u0013\t\u0005\u0013:\u00036+D\u0001K\u0015\tYE*A\u0004nkR\f'\r\\3\u000b\u00055k\u0011AC2pY2,7\r^5p]&\u0011qJ\u0013\u0002\b\u0011\u0006\u001c\b.T1q!\t\u0001\u0015+\u0003\u0002S\u0005\tq!\t\\8dW6\u000bg.Y4fe&#\u0007C\u0001!U\u0013\t)&A\u0001\tCY>\u001c7.T1oC\u001e,'/\u00138g_\"1q\u000b\u0001Q\u0001\n!\u000b\u0011C\u00197pG.l\u0015M\\1hKJLeNZ8!\u0011\u001dI\u0006A1A\u0005\ni\u000b\u0001D\u00197pG.l\u0015M\\1hKJLEMQ=Fq\u0016\u001cW\u000f^8s+\u0005Y\u0006\u0003B%O9B\u0003\"!\u00183\u000f\u0005y\u0013\u0007CA0\u000e\u001b\u0005\u0001'BA1 \u0003\u0019a$o\\8u}%\u00111-D\u0001\u0007!J,G-\u001a4\n\u0005\u00154'AB*ue&twM\u0003\u0002d\u001b!1\u0001\u000e\u0001Q\u0001\nm\u000b\u0011D\u00197pG.l\u0015M\\1hKJLEMQ=Fq\u0016\u001cW\u000f^8sA!9!\u000e\u0001b\u0001\n\u0013Y\u0017A\u00042m_\u000e\\Gj\\2bi&|gn]\u000b\u0002YB!QN]:w\u001b\u0005q'BA8q\u0003\u0011)H/\u001b7\u000b\u0003E\fAA[1wC&\u0011qJ\u001c\t\u0003\u0001RL!!\u001e\u0002\u0003\u000f\tcwnY6JIB\u0019\u0011j\u001e)\n\u0005aT%a\u0002%bg\"\u001cV\r\u001e\u0005\u0007u\u0002\u0001\u000b\u0011\u00027\u0002\u001f\tdwnY6M_\u000e\fG/[8og\u0002Bq\u0001 \u0001C\u0002\u0013%Q0A\u0007bg.$\u0006N]3bIB{w\u000e\\\u000b\u0002}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002]\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'\u000fC\u0004\u0002\f\u0001\u0001\u000b\u0011\u0002@\u0002\u001d\u0005\u001c8\u000e\u00165sK\u0006$\u0007k\\8mA!I\u0011q\u0002\u0001C\u0002\u0013-\u0011\u0011C\u0001\u0014CN\\W\t_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0003\u0003'\u0001B!!\u0006\u0002\u001a5\u0011\u0011q\u0003\u0006\u0004\u0003\u0007i\u0011\u0002BA\u000e\u0003/\u0011q$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011!\ty\u0002\u0001Q\u0001\n\u0005M\u0011\u0001F1tW\u0016CXmY;uS>t7i\u001c8uKb$\b\u0005C\u0005\u0002$\u0001\u0011\r\u0011\"\u0003\u0002&\u0005qAo\u001c9pY><\u00170T1qa\u0016\u0014XCAA\u0014!\r\u0001\u0015\u0011F\u0005\u0004\u0003W\u0011!A\u0004+pa>dwnZ=NCB\u0004XM\u001d\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002(\u0005yAo\u001c9pY><\u00170T1qa\u0016\u0014\b\u0005\u0003\u0005\u00024\u0001\u0011\r\u0011\"\u0001)\u0003Q\u0001(o\\1di&4X\r\\=SKBd\u0017nY1uK\"9\u0011q\u0007\u0001!\u0002\u0013I\u0013!\u00069s_\u0006\u001cG/\u001b<fYf\u0014V\r\u001d7jG\u0006$X\r\t\u0005\b\u0003w\u0001A\u0011IA\u001f\u0003=\u0011XmY3jm\u0016\fe\u000e\u001a*fa2LH\u0003BA \u0003#\u0002r\u0001DA!\u0003\u000b\nY%C\u0002\u0002D5\u0011q\u0002U1si&\fGNR;oGRLwN\u001c\t\u0004\u0019\u0005\u001d\u0013bAA%\u001b\t\u0019\u0011I\\=\u0011\u00071\ti%C\u0002\u0002P5\u0011A!\u00168ji\"A\u00111KA\u001d\u0001\u0004\t)&A\u0004d_:$X\r\u001f;\u0011\u0007I\t9&C\u0002\u0002ZM\u0011aB\u00159d\u0007\u0006dGnQ8oi\u0016DH\u000fC\u0004\u0002^\u0001!I!a\u0018\u0002\u0013I,Wn\u001c<f%\u0012$G\u0003BA1\u0003\u007f\u0002b!!\u0006\u0002d\u0005\u001d\u0014\u0002BA3\u0003/\u0011aAR;ukJ,\u0007CBA5\u0003g\nIH\u0004\u0003\u0002l\u0005=dbA0\u0002n%\ta\"C\u0002\u0002r5\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002v\u0005]$aA*fc*\u0019\u0011\u0011O\u0007\u0011\u00071\tY(C\u0002\u0002~5\u00111!\u00138u\u0011!\t\t)a\u0017A\u0002\u0005e\u0014!\u0002:eI&#\u0007bBAC\u0001\u0011%\u0011qQ\u0001\u000ee\u0016lwN^3TQV4g\r\\3\u0015\t\u0005%\u0015Q\u0012\t\u0007\u0003+\t\u0019'a#\u0011\u000b\u0005%\u00141O\u0015\t\u0011\u0005=\u00151\u0011a\u0001\u0003s\n\u0011b\u001d5vM\u001adW-\u00133\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\u0006y!/Z7pm\u0016\u0014%o\\1eG\u0006\u001cH\u000f\u0006\u0004\u0002b\u0005]\u0015\u0011\u0015\u0005\t\u00033\u000b\t\n1\u0001\u0002\u001c\u0006Y!M]8bI\u000e\f7\u000f^%e!\ra\u0011QT\u0005\u0004\u0003?k!\u0001\u0002'p]\u001eDq!a)\u0002\u0012\u0002\u0007\u0011&\u0001\tsK6|g/\u001a$s_6$%/\u001b<fe\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0016A\u0005:f[>4XM\u00117pG.l\u0015M\\1hKJ$B!a\u0013\u0002,\"9\u0011QVAS\u0001\u0004\u0001\u0016A\u00042m_\u000e\\W*\u00198bO\u0016\u0014\u0018\n\u001a\u0005\b\u0003c\u0003A\u0011BAZ\u00039\u0011X-\\8wK\u0016CXmY;u_J$B!a\u0013\u00026\"9\u0011qWAX\u0001\u0004a\u0016AB3yK\u000eLE\rC\u0004\u0002<\u0002!I!!0\u0002#!,\u0017M\u001d;cK\u0006$(+Z2fSZ,G\rF\u0002*\u0003\u007fCq!!,\u0002:\u0002\u0007\u0001\u000bC\u0004\u0002D\u0002!I!!2\u0002-I,Wn\u001c<f\u00052|7m\u001b$s_6<vN]6feN$B!a\u0013\u0002H\"9\u0011\u0011ZAa\u0001\u0004\u0019\u0018a\u00022m_\u000e\\\u0017\n\u001a\u0005\b\u0003\u001b\u0004A\u0011BAh\u00031iW-\\8ssN#\u0018\r^;t+\t\t\t\u000e\u0005\u0004^\u0003'\u0004\u0016q[\u0005\u0004\u0003+4'aA'baB9A\"!7\u0002\u001c\u0006m\u0015bAAn\u001b\t1A+\u001e9mKJBq!a8\u0001\t\u0013\t\t/A\u0007ti>\u0014\u0018mZ3Ti\u0006$Xo]\u000b\u0003\u0003G\u0004R\u0001DAs\u0003SL1!a:\u000e\u0005\u0015\t%O]1z!\r\u0001\u00151^\u0005\u0004\u0003[\u0014!!D*u_J\fw-Z*uCR,8\u000fC\u0004\u0002r\u0002!I!a=\u0002\u0017\tdwnY6Ti\u0006$Xo\u001d\u000b\u0007\u0003k\u0014)Aa\u0002\u0011\ru\u000b\u0019\u000eUA|!\u0019\t)\"a\u0019\u0002zB)A\"a?\u0002\u0000&\u0019\u0011Q`\u0007\u0003\r=\u0003H/[8o!\r\u0001%\u0011A\u0005\u0004\u0005\u0007\u0011!a\u0003\"m_\u000e\\7\u000b^1ukNDq!!3\u0002p\u0002\u00071\u000fC\u0004\u0003\n\u0005=\b\u0019A\u0015\u0002\u0013\u0005\u001c8n\u00157bm\u0016\u001c\bb\u0002B\u0007\u0001\u0011%!qB\u0001\u0014O\u0016$X*\u0019;dQ&twM\u00117pG.LEm\u001d\u000b\u0007\u0005#\u0011)Ba\b\u0011\r\u0005U\u00111\rB\n!\u0015\tI'a\u001dt\u0011!\u00119Ba\u0003A\u0002\te\u0011A\u00024jYR,'\u000fE\u0003\r\u00057\u0019\u0018&C\u0002\u0003\u001e5\u0011\u0011BR;oGRLwN\\\u0019\t\u000f\t%!1\u0002a\u0001S!9!1\u0005\u0001\u0005\n\t\u0015\u0012\u0001\u0003:fO&\u001cH/\u001a:\u0015\u0013A\u00139Ca\u000b\u00030\tM\u0002b\u0002B\u0015\u0005C\u0001\r\u0001U\u0001\u0016S\u0012<\u0016\u000e\u001e5pkR$v\u000e]8m_\u001eL\u0018J\u001c4p\u0011!\u0011iC!\tA\u0002\u0005m\u0015\u0001E7bq>s\u0007*Z1q\u001b\u0016l7+\u001b>f\u0011!\u0011\tD!\tA\u0002\u0005m\u0015!E7bq>3g\rS3ba6+WnU5{K\"A!Q\u0007B\u0011\u0001\u0004\u00119$A\u0007tY\u00064X-\u00128ea>Lg\u000e\u001e\t\u0004%\te\u0012b\u0001B\u001e'\tq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007b\u0002B \u0001\u0011%!\u0011I\u0001\u0010kB$\u0017\r^3CY>\u001c7.\u00138g_RY\u0011Fa\u0011\u0003F\t\u001d#\u0011\u000bB+\u0011\u001d\tiK!\u0010A\u0002ACq!!3\u0003>\u0001\u00071\u000f\u0003\u0005\u0003J\tu\u0002\u0019\u0001B&\u00031\u0019Ho\u001c:bO\u0016dUM^3m!\r\u0001%QJ\u0005\u0004\u0005\u001f\u0012!\u0001D*u_J\fw-\u001a'fm\u0016d\u0007\u0002\u0003B*\u0005{\u0001\r!a'\u0002\u000f5,WnU5{K\"A!q\u000bB\u001f\u0001\u0004\tY*\u0001\u0005eSN\\7+\u001b>f\u0011\u001d\u0011Y\u0006\u0001C\u0005\u0005;\nAbZ3u\u0019>\u001c\u0017\r^5p]N$BAa\u0018\u0003bA)\u0011\u0011NA:!\"9\u0011\u0011\u001aB-\u0001\u0004\u0019\bb\u0002B3\u0001\u0011%!qM\u0001\u0016O\u0016$Hj\\2bi&|gn]!oIN#\u0018\r^;t)\u0011\u0011IG!#\u0011\u000b1\tYPa\u001b\u0011\t\t5$1\u0011\b\u0005\u0005_\u0012yH\u0004\u0003\u0003r\tud\u0002\u0002B:\u0005wrAA!\u001e\u0003z9\u0019qLa\u001e\n\u0003%I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\r\u0011\tIA\u0001\u0015\u00052|7m['b]\u0006<WM]'fgN\fw-Z:\n\t\t\u0015%q\u0011\u0002\u0018\u00052|7m\u001b'pG\u0006$\u0018n\u001c8t\u0003:$7\u000b^1ukNT1A!!\u0003\u0011\u001d\tIMa\u0019A\u0002MDqA!$\u0001\t\u0013\u0011y)\u0001\u000fhKRdunY1uS>t7/T;mi&\u0004H.\u001a\"m_\u000e\\\u0017\nZ:\u0015\t\tE%q\u0013\t\u0007\u0003S\u0012\u0019Ja\u0018\n\t\tU\u0015q\u000f\u0002\u000b\u0013:$W\r_3e'\u0016\f\b\u0002\u0003BM\u0005\u0017\u0003\rAa'\u0002\u0011\tdwnY6JIN\u0004B\u0001DAsg\"9!q\u0014\u0001\u0005\n\t\u0005\u0016\u0001C4fiB+WM]:\u0015\t\t}#1\u0015\u0005\b\u0003[\u0013i\n1\u0001Q\u0011\u001d\u00119\u000b\u0001C\u0005\u0005S\u000bacZ3u\u000bb,7-\u001e;pe\u0016sG\r]8j]R\u0014VM\u001a\u000b\u0005\u0005W\u0013i\u000bE\u0003\r\u0003w\u00149\u0004C\u0004\u00030\n\u0015\u0006\u0019\u0001/\u0002\u0015\u0015DXmY;u_JLE\rC\u0004\u00034\u0002!\tE!.\u0002\r=t7\u000b^8q)\t\tY\u0005")
public class BlockManagerMasterEndpoint
implements ThreadSafeRpcEndpoint,
Logging {
    private final RpcEnv rpcEnv;
    private final boolean isLocal;
    public final LiveListenerBus org$apache$spark$storage$BlockManagerMasterEndpoint$$listenerBus;
    private final scala.collection.mutable.HashMap<BlockManagerId, BlockManagerInfo> org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo;
    private final scala.collection.mutable.HashMap<String, BlockManagerId> org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor;
    private final HashMap<BlockId, HashSet<BlockManagerId>> blockLocations;
    private final ThreadPoolExecutor askThreadPool;
    private final ExecutionContextExecutorService askExecutionContext;
    private final TopologyMapper topologyMapper;
    private final boolean proactivelyReplicate;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public final RpcEndpointRef self() {
        return RpcEndpoint.self$(this);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return RpcEndpoint.receive$(this);
    }

    @Override
    public void onError(Throwable cause) {
        RpcEndpoint.onError$(this, cause);
    }

    @Override
    public void onConnected(RpcAddress remoteAddress) {
        RpcEndpoint.onConnected$(this, remoteAddress);
    }

    @Override
    public void onDisconnected(RpcAddress remoteAddress) {
        RpcEndpoint.onDisconnected$(this, remoteAddress);
    }

    @Override
    public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
        RpcEndpoint.onNetworkError$(this, cause, remoteAddress);
    }

    @Override
    public void onStart() {
        RpcEndpoint.onStart$(this);
    }

    @Override
    public final void stop() {
        RpcEndpoint.stop$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public scala.collection.mutable.HashMap<BlockManagerId, BlockManagerInfo> org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo() {
        return this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo;
    }

    public scala.collection.mutable.HashMap<String, BlockManagerId> org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor() {
        return this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor;
    }

    private HashMap<BlockId, HashSet<BlockManagerId>> blockLocations() {
        return this.blockLocations;
    }

    private ThreadPoolExecutor askThreadPool() {
        return this.askThreadPool;
    }

    private ExecutionContextExecutorService askExecutionContext() {
        return this.askExecutionContext;
    }

    private TopologyMapper topologyMapper() {
        return this.topologyMapper;
    }

    public boolean proactivelyReplicate() {
        return this.proactivelyReplicate;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
        return new scala.Serializable(this, context){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMasterEndpoint $outer;
            private final RpcCallContext context$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof BlockManagerMessages.RegisterBlockManager) {
                    BlockManagerMessages.RegisterBlockManager registerBlockManager = (BlockManagerMessages.RegisterBlockManager)A1;
                    BlockManagerId blockManagerId = registerBlockManager.blockManagerId();
                    long maxOnHeapMemSize = registerBlockManager.maxOnHeapMemSize();
                    long maxOffHeapMemSize = registerBlockManager.maxOffHeapMemSize();
                    RpcEndpointRef slaveEndpoint = registerBlockManager.sender();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$register(blockManagerId, maxOnHeapMemSize, maxOffHeapMemSize, slaveEndpoint));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.UpdateBlockInfo) {
                    BlockManagerMessages.UpdateBlockInfo updateBlockInfo = (BlockManagerMessages.UpdateBlockInfo)A1;
                    BlockManagerId blockManagerId = updateBlockInfo.blockManagerId();
                    BlockId blockId = updateBlockInfo.blockId();
                    StorageLevel storageLevel = updateBlockInfo.storageLevel();
                    long deserializedSize = updateBlockInfo.memSize();
                    long size = updateBlockInfo.diskSize();
                    this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$updateBlockInfo(blockManagerId, blockId, storageLevel, deserializedSize, size)));
                    this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$listenerBus.post(new SparkListenerBlockUpdated(BlockUpdatedInfo$.MODULE$.apply(updateBlockInfo)));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetLocations) {
                    BlockManagerMessages.GetLocations getLocations = (BlockManagerMessages.GetLocations)A1;
                    BlockId blockId = getLocations.blockId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocations(blockId));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetLocationsAndStatus) {
                    BlockManagerMessages.GetLocationsAndStatus getLocationsAndStatus = (BlockManagerMessages.GetLocationsAndStatus)A1;
                    BlockId blockId = getLocationsAndStatus.blockId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocationsAndStatus(blockId));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetLocationsMultipleBlockIds) {
                    BlockManagerMessages.GetLocationsMultipleBlockIds getLocationsMultipleBlockIds = (BlockManagerMessages.GetLocationsMultipleBlockIds)A1;
                    BlockId[] blockIds = getLocationsMultipleBlockIds.blockIds();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocationsMultipleBlockIds(blockIds));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetPeers) {
                    BlockManagerMessages.GetPeers getPeers = (BlockManagerMessages.GetPeers)A1;
                    BlockManagerId blockManagerId = getPeers.blockManagerId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getPeers(blockManagerId));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetExecutorEndpointRef) {
                    BlockManagerMessages.GetExecutorEndpointRef getExecutorEndpointRef = (BlockManagerMessages.GetExecutorEndpointRef)A1;
                    String executorId = getExecutorEndpointRef.executorId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getExecutorEndpointRef(executorId));
                    object = BoxedUnit.UNIT;
                } else if (BlockManagerMessages$GetMemoryStatus$.MODULE$.equals(A1)) {
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$memoryStatus());
                    object = BoxedUnit.UNIT;
                } else if (BlockManagerMessages$GetStorageStatus$.MODULE$.equals(A1)) {
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$storageStatus());
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetBlockStatus) {
                    BlockManagerMessages.GetBlockStatus getBlockStatus = (BlockManagerMessages.GetBlockStatus)A1;
                    BlockId blockId = getBlockStatus.blockId();
                    boolean askSlaves = getBlockStatus.askSlaves();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockStatus(blockId, askSlaves));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.GetMatchingBlockIds) {
                    BlockManagerMessages.GetMatchingBlockIds getMatchingBlockIds = (BlockManagerMessages.GetMatchingBlockIds)A1;
                    Function1<BlockId, Object> filter = getMatchingBlockIds.filter();
                    boolean askSlaves = getMatchingBlockIds.askSlaves();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$getMatchingBlockIds(filter, askSlaves));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.RemoveRdd) {
                    BlockManagerMessages.RemoveRdd removeRdd2 = (BlockManagerMessages.RemoveRdd)A1;
                    int rddId = removeRdd2.rddId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeRdd(rddId));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.RemoveShuffle) {
                    BlockManagerMessages.RemoveShuffle removeShuffle = (BlockManagerMessages.RemoveShuffle)A1;
                    int shuffleId = removeShuffle.shuffleId();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeShuffle(shuffleId));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.RemoveBroadcast) {
                    BlockManagerMessages.RemoveBroadcast removeBroadcast2 = (BlockManagerMessages.RemoveBroadcast)A1;
                    long broadcastId = removeBroadcast2.broadcastId();
                    boolean removeFromDriver = removeBroadcast2.removeFromDriver();
                    this.context$1.reply(this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeBroadcast(broadcastId, removeFromDriver));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.RemoveBlock) {
                    BlockManagerMessages.RemoveBlock removeBlock = (BlockManagerMessages.RemoveBlock)A1;
                    BlockId blockId = removeBlock.blockId();
                    this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeBlockFromWorkers(blockId);
                    this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.RemoveExecutor) {
                    BlockManagerMessages.RemoveExecutor removeExecutor = (BlockManagerMessages.RemoveExecutor)A1;
                    String execId = removeExecutor.execId();
                    this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeExecutor(execId);
                    this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                    object = BoxedUnit.UNIT;
                } else if (BlockManagerMessages$StopBlockManagerMaster$.MODULE$.equals(A1)) {
                    this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                    this.$outer.stop();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.BlockManagerHeartbeat) {
                    BlockManagerMessages.BlockManagerHeartbeat blockManagerHeartbeat = (BlockManagerMessages.BlockManagerHeartbeat)A1;
                    BlockManagerId blockManagerId = blockManagerHeartbeat.blockManagerId();
                    this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$heartbeatReceived(blockManagerId)));
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlockManagerMessages.HasCachedBlocks) {
                    BlockManagerMessages.HasCachedBlocks hasCachedBlocks = (BlockManagerMessages.HasCachedBlocks)A1;
                    String executorId = hasCachedBlocks.executorId();
                    Option option = this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().get((Object)executorId);
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        BlockManagerId bm = (BlockManagerId)some.value();
                        if (this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().contains((Object)bm)) {
                            BlockManagerInfo bmInfo = (BlockManagerInfo)this.$outer.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply((Object)bm);
                            this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)bmInfo.cachedBlocks().nonEmpty()));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)false));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (None$.MODULE$.equals(option)) {
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)false));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof BlockManagerMessages.RegisterBlockManager ? true : (object instanceof BlockManagerMessages.UpdateBlockInfo ? true : (object instanceof BlockManagerMessages.GetLocations ? true : (object instanceof BlockManagerMessages.GetLocationsAndStatus ? true : (object instanceof BlockManagerMessages.GetLocationsMultipleBlockIds ? true : (object instanceof BlockManagerMessages.GetPeers ? true : (object instanceof BlockManagerMessages.GetExecutorEndpointRef ? true : (BlockManagerMessages$GetMemoryStatus$.MODULE$.equals(object) ? true : (BlockManagerMessages$GetStorageStatus$.MODULE$.equals(object) ? true : (object instanceof BlockManagerMessages.GetBlockStatus ? true : (object instanceof BlockManagerMessages.GetMatchingBlockIds ? true : (object instanceof BlockManagerMessages.RemoveRdd ? true : (object instanceof BlockManagerMessages.RemoveShuffle ? true : (object instanceof BlockManagerMessages.RemoveBroadcast ? true : (object instanceof BlockManagerMessages.RemoveBlock ? true : (object instanceof BlockManagerMessages.RemoveExecutor ? true : (BlockManagerMessages$StopBlockManagerMaster$.MODULE$.equals(object) ? true : (object instanceof BlockManagerMessages.BlockManagerHeartbeat ? true : object instanceof BlockManagerMessages.HasCachedBlocks)))))))))))))))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.context$1 = context$1;
            }
        };
    }

    public Future<Seq<Object>> org$apache$spark$storage$BlockManagerMasterEndpoint$$removeRdd(int rddId) {
        Iterable blocks = (Iterable)((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.blockLocations()).asScala()).keys().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(x$1.asRDDId()), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BlockManagerMasterEndpoint.$anonfun$removeRdd$2(rddId, x$2)));
        blocks.foreach((Function1 & Serializable & scala.Serializable)blockId -> {
            HashSet<BlockManagerId> bms = this.blockLocations().get(blockId);
            bms.foreach((Function1 & Serializable & scala.Serializable)bm -> {
                BlockManagerMasterEndpoint.$anonfun$removeRdd$4(this, blockId, bm);
                return BoxedUnit.UNIT;
            });
            return this.blockLocations().remove(blockId);
        });
        BlockManagerMessages.RemoveRdd removeMsg = new BlockManagerMessages.RemoveRdd(rddId);
        Seq futures = ((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().values().map((Function1 & Serializable & scala.Serializable)bm -> bm.slaveEndpoint().ask(removeMsg, ClassTag$.MODULE$.Int()).recover((PartialFunction)new scala.Serializable(this, rddId, (BlockManagerInfo)bm){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMasterEndpoint $outer;
            private final int rddId$1;
            private final BlockManagerInfo bm$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof IOException) {
                    IOException iOException = (IOException)A1;
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Error trying to remove RDD ").append($this.rddId$1).append(" from block manager ").append($this.bm$1.blockManagerId()).toString(), iOException);
                    object = BoxesRunTime.boxToInteger((int)0);
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable instanceof IOException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rddId$1 = rddId$1;
                this.bm$1 = bm$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.storage.BlockManagerMasterEndpoint$$anonfun$$nestedInanonfun$removeRdd$6$1 )}, serializedLambda);
            }
        }, (ExecutionContext)this.askExecutionContext()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.askExecutionContext());
    }

    public Future<Seq<Object>> org$apache$spark$storage$BlockManagerMasterEndpoint$$removeShuffle(int shuffleId) {
        BlockManagerMessages.RemoveShuffle removeMsg = new BlockManagerMessages.RemoveShuffle(shuffleId);
        return Future$.MODULE$.sequence((TraversableOnce)((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().values().map((Function1 & Serializable & scala.Serializable)bm -> bm.slaveEndpoint().ask(removeMsg, ClassTag$.MODULE$.Boolean()), Iterable$.MODULE$.canBuildFrom())).toSeq(), Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.askExecutionContext());
    }

    public Future<Seq<Object>> org$apache$spark$storage$BlockManagerMasterEndpoint$$removeBroadcast(long broadcastId, boolean removeFromDriver) {
        BlockManagerMessages.RemoveBroadcast removeMsg = new BlockManagerMessages.RemoveBroadcast(broadcastId, removeFromDriver);
        Iterable requiredBlockManagers = (Iterable)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().values().filter((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockManagerMasterEndpoint.$anonfun$removeBroadcast$1(removeFromDriver, info)));
        Seq futures = ((TraversableOnce)requiredBlockManagers.map((Function1 & Serializable & scala.Serializable)bm -> bm.slaveEndpoint().ask(removeMsg, ClassTag$.MODULE$.Int()).recover((PartialFunction)new scala.Serializable(this, broadcastId, (BlockManagerInfo)bm){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMasterEndpoint $outer;
            private final long broadcastId$1;
            private final BlockManagerInfo bm$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof IOException) {
                    IOException iOException = (IOException)A1;
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Error trying to remove broadcast ").append($this.broadcastId$1).append(" from block manager ").append(String.valueOf($this.bm$2.blockManagerId())).toString(), iOException);
                    object = BoxesRunTime.boxToInteger((int)0);
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                boolean bl = throwable instanceof IOException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.broadcastId$1 = broadcastId$1;
                this.bm$2 = bm$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.storage.BlockManagerMasterEndpoint$$anonfun$$nestedInanonfun$removeBroadcast$2$1 )}, serializedLambda);
            }
        }, (ExecutionContext)this.askExecutionContext()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.askExecutionContext());
    }

    private void removeBlockManager(BlockManagerId blockManagerId) {
        BlockManagerInfo info = (BlockManagerInfo)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply((Object)blockManagerId);
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().$minus$eq((Object)blockManagerId.executorId());
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().remove((Object)blockManagerId);
        for (BlockId blockId : info.blocks().keySet()) {
            HashSet<BlockManagerId> locations = this.blockLocations().get(blockId);
            locations.$minus$eq((Object)blockManagerId);
            if (locations.size() == 0) {
                this.blockLocations().remove(blockId);
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("No more replicas available for ").append(blockId).append(" !").toString());
                continue;
            }
            if (!this.proactivelyReplicate() || !blockId.isRDD() && !(blockId instanceof TestBlockId)) continue;
            int maxReplicas = locations.size() + 1;
            int i = new Random(blockId.hashCode()).nextInt(locations.size());
            Seq blockLocations = locations.toSeq();
            BlockManagerId candidateBMId = (BlockManagerId)blockLocations.apply(i);
            this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().get((Object)candidateBMId).foreach((Function1 & Serializable & scala.Serializable)bm2 -> {
                Seq remainingLocations = (Seq)locations.toSeq().filter((Function1 & Serializable & scala.Serializable)bm -> BoxesRunTime.boxToBoolean((boolean)BlockManagerMasterEndpoint.$anonfun$removeBlockManager$3(candidateBMId, bm)));
                BlockManagerMessages.ReplicateBlock replicateMsg = new BlockManagerMessages.ReplicateBlock(blockId, (Seq<BlockManagerId>)remainingLocations, maxReplicas);
                return bm2.slaveEndpoint().ask(replicateMsg, ClassTag$.MODULE$.Boolean());
            });
        }
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$listenerBus.post(new SparkListenerBlockManagerRemoved(System.currentTimeMillis(), blockManagerId));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Removing block manager ").append(blockManagerId).toString());
    }

    public void org$apache$spark$storage$BlockManagerMasterEndpoint$$removeExecutor(String execId) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Trying to remove executor ").append(execId).append(" from BlockManagerMaster.").toString());
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().get((Object)execId).foreach((Function1 & Serializable & scala.Serializable)blockManagerId -> {
            this.removeBlockManager(blockManagerId);
            return BoxedUnit.UNIT;
        });
    }

    public boolean org$apache$spark$storage$BlockManagerMasterEndpoint$$heartbeatReceived(BlockManagerId blockManagerId) {
        boolean bl;
        if (!this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().contains((Object)blockManagerId)) {
            bl = blockManagerId.isDriver() && !this.isLocal();
        } else {
            ((BlockManagerInfo)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply((Object)blockManagerId)).updateLastSeenMs();
            bl = true;
        }
        return bl;
    }

    public void org$apache$spark$storage$BlockManagerMasterEndpoint$$removeBlockFromWorkers(BlockId blockId) {
        block0: {
            HashSet<BlockManagerId> locations = this.blockLocations().get(blockId);
            if (locations == null) break block0;
            locations.foreach((Function1 & Serializable & scala.Serializable)blockManagerId -> {
                Option blockManager = this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().get(blockManagerId);
                return blockManager.isDefined() ? ((BlockManagerInfo)blockManager.get()).slaveEndpoint().ask(new BlockManagerMessages.RemoveBlock(blockId), ClassTag$.MODULE$.Boolean()) : BoxedUnit.UNIT;
            });
        }
    }

    public scala.collection.immutable.Map<BlockManagerId, Tuple2<Object, Object>> org$apache$spark$storage$BlockManagerMasterEndpoint$$memoryStatus() {
        return ((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
            BlockManagerInfo info = (BlockManagerInfo)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)blockManagerId, (Object)new Tuple2.mcJJ.sp(info.maxMem(), info.remainingMem()));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public StorageStatus[] org$apache$spark$storage$BlockManagerMasterEndpoint$$storageStatus() {
        return (StorageStatus[])((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
            BlockManagerInfo info = (BlockManagerInfo)tuple2._2();
            StorageStatus storageStatus = new StorageStatus(blockManagerId, info.maxMem(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)info.maxOnHeapMem())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)info.maxOffHeapMem())), (Map<BlockId, BlockStatus>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(info.blocks()).asScala()));
            return storageStatus;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StorageStatus.class));
    }

    public scala.collection.immutable.Map<BlockManagerId, Future<Option<BlockStatus>>> org$apache$spark$storage$BlockManagerMasterEndpoint$$blockStatus(BlockId blockId, boolean askSlaves) {
        BlockManagerMessages.GetBlockStatus getBlockStatus = new BlockManagerMessages.GetBlockStatus(blockId, BlockManagerMessages$GetBlockStatus$.MODULE$.apply$default$2());
        return ((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().values().map((Function1 & Serializable & scala.Serializable)info -> {
            Future blockStatusFuture = askSlaves ? info.slaveEndpoint().ask(getBlockStatus, ClassTag$.MODULE$.apply(Option.class)) : Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> info.getStatus(blockId), (ExecutionContext)this.askExecutionContext());
            return new Tuple2((Object)info.blockManagerId(), (Object)blockStatusFuture);
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Future<Seq<BlockId>> org$apache$spark$storage$BlockManagerMasterEndpoint$$getMatchingBlockIds(Function1<BlockId, Object> filter, boolean askSlaves) {
        BlockManagerMessages.GetMatchingBlockIds getMatchingBlockIds = new BlockManagerMessages.GetMatchingBlockIds(filter, BlockManagerMessages$GetMatchingBlockIds$.MODULE$.apply$default$2());
        return Future$.MODULE$.sequence((TraversableOnce)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().values().map((Function1 & Serializable & scala.Serializable)info -> {
            Future future = askSlaves ? info.slaveEndpoint().ask(getMatchingBlockIds, ClassTag$.MODULE$.apply(Seq.class)) : Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(info.blocks()).asScala()).keys().filter(filter)).toSeq(), (ExecutionContext)this.askExecutionContext());
            return future;
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom(), (ExecutionContext)this.askExecutionContext()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)x$4.flatten((Function1)Predef$.MODULE$.$conforms())).toSeq(), (ExecutionContext)this.askExecutionContext());
    }

    public BlockManagerId org$apache$spark$storage$BlockManagerMasterEndpoint$$register(BlockManagerId idWithoutTopologyInfo, long maxOnHeapMemSize, long maxOffHeapMemSize, RpcEndpointRef slaveEndpoint) {
        BlockManagerId id = BlockManagerId$.MODULE$.apply(idWithoutTopologyInfo.executorId(), idWithoutTopologyInfo.host(), idWithoutTopologyInfo.port(), this.topologyMapper().getTopologyForHost(idWithoutTopologyInfo.host()));
        long time = System.currentTimeMillis();
        if (!this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().contains((Object)id)) {
            Option option = this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().get((Object)id.executorId());
            if (option instanceof Some) {
                Some some = (Some)option;
                BlockManagerId oldId = (BlockManagerId)some.value();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Got two different block manager registrations on same executor - ").append(new StringBuilder(36).append(" will replace old one ").append(oldId).append(" with new one ").append(id).toString()).toString());
                this.org$apache$spark$storage$BlockManagerMasterEndpoint$$removeExecutor(id.executorId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Registering block manager %s with %s RAM, %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id.hostPort(), Utils$.MODULE$.bytesToString(maxOnHeapMemSize + maxOffHeapMemSize), id})));
            this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().update((Object)id.executorId(), (Object)id);
            this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().update((Object)id, (Object)new BlockManagerInfo(id, System.currentTimeMillis(), maxOnHeapMemSize, maxOffHeapMemSize, slaveEndpoint));
        }
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$listenerBus.post(new SparkListenerBlockManagerAdded(time, id, maxOnHeapMemSize + maxOffHeapMemSize, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)maxOnHeapMemSize)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)maxOffHeapMemSize))));
        return id;
    }

    public boolean org$apache$spark$storage$BlockManagerMasterEndpoint$$updateBlockInfo(BlockManagerId blockManagerId, BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        HashSet<BlockManagerId> hashSet;
        if (!this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().contains((Object)blockManagerId)) {
            return blockManagerId.isDriver() && !this.isLocal();
        }
        if (blockId == null) {
            ((BlockManagerInfo)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply((Object)blockManagerId)).updateLastSeenMs();
            return true;
        }
        ((BlockManagerInfo)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply((Object)blockManagerId)).updateBlockInfo(blockId, storageLevel, memSize, diskSize);
        HashSet<BlockManagerId> locations = null;
        if (this.blockLocations().containsKey(blockId)) {
            locations = this.blockLocations().get(blockId);
            hashSet = BoxedUnit.UNIT;
        } else {
            locations = new HashSet<BlockManagerId>();
            hashSet = this.blockLocations().put(blockId, locations);
        }
        boolean bl = storageLevel.isValid() ? locations.add((Object)blockManagerId) : locations.remove((Object)blockManagerId);
        HashSet<BlockManagerId> hashSet2 = locations.size() == 0 ? this.blockLocations().remove(blockId) : BoxedUnit.UNIT;
        return true;
    }

    public Seq<BlockManagerId> org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocations(BlockId blockId) {
        return this.blockLocations().containsKey(blockId) ? ((SetLike)this.blockLocations().get(blockId)).toSeq() : (Seq)Seq$.MODULE$.empty();
    }

    public Option<BlockManagerMessages.BlockLocationsAndStatus> org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocationsAndStatus(BlockId blockId) {
        Seq locations = (Seq)Option$.MODULE$.apply(this.blockLocations().get(blockId)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Option status = locations.headOption().flatMap((Function1 & Serializable & scala.Serializable)bmId -> ((BlockManagerInfo)this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().apply(bmId)).getStatus(blockId));
        return locations.nonEmpty() && status.isDefined() ? new Some((Object)new BlockManagerMessages.BlockLocationsAndStatus((Seq<BlockManagerId>)locations, (BlockStatus)status.get())) : None$.MODULE$;
    }

    public IndexedSeq<Seq<BlockManagerId>> org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocationsMultipleBlockIds(BlockId[] blockIds) {
        return (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockIds)).map((Function1 & Serializable & scala.Serializable)blockId -> this.org$apache$spark$storage$BlockManagerMasterEndpoint$$getLocations((BlockId)blockId), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<BlockManagerId> org$apache$spark$storage$BlockManagerMasterEndpoint$$getPeers(BlockManagerId blockManagerId) {
        Set blockManagerIds = this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().keySet();
        return blockManagerIds.contains((Object)blockManagerId) ? ((scala.collection.SetLike)((TraversableLike)blockManagerIds.filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDriver()))).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)BlockManagerMasterEndpoint.$anonfun$getPeers$2(blockManagerId, x$7)))).toSeq() : (Seq)Seq$.MODULE$.empty();
    }

    public Option<RpcEndpointRef> org$apache$spark$storage$BlockManagerMasterEndpoint$$getExecutorEndpointRef(String executorId) {
        return this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor().get((Object)executorId).flatMap((Function1 & Serializable & scala.Serializable)blockManagerId -> this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().get(blockManagerId).map((Function1 & Serializable & scala.Serializable)info -> info.slaveEndpoint()));
    }

    @Override
    public void onStop() {
        this.askThreadPool().shutdownNow();
    }

    public static final /* synthetic */ boolean $anonfun$removeRdd$2(int rddId$1, RDDBlockId x$2) {
        return x$2.rddId() == rddId$1;
    }

    public static final /* synthetic */ void $anonfun$removeRdd$4(BlockManagerMasterEndpoint $this, RDDBlockId blockId$6, BlockManagerId bm) {
        $this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo().get((Object)bm).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.removeBlock(blockId$6);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeBroadcast$1(boolean removeFromDriver$1, BlockManagerInfo info) {
        return removeFromDriver$1 || !info.blockManagerId().isDriver();
    }

    public static final /* synthetic */ boolean $anonfun$removeBlockManager$3(BlockManagerId candidateBMId$1, BlockManagerId bm) {
        BlockManagerId blockManagerId = bm;
        BlockManagerId blockManagerId2 = candidateBMId$1;
        return blockManagerId == null ? blockManagerId2 != null : !((Object)blockManagerId).equals(blockManagerId2);
    }

    public static final /* synthetic */ boolean $anonfun$getPeers$2(BlockManagerId blockManagerId$1, BlockManagerId x$7) {
        BlockManagerId blockManagerId = x$7;
        BlockManagerId blockManagerId2 = blockManagerId$1;
        return !(blockManagerId != null ? !((Object)blockManagerId).equals(blockManagerId2) : blockManagerId2 != null);
    }

    public BlockManagerMasterEndpoint(RpcEnv rpcEnv, boolean isLocal, SparkConf conf, LiveListenerBus listenerBus) {
        this.rpcEnv = rpcEnv;
        this.isLocal = isLocal;
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$listenerBus = listenerBus;
        RpcEndpoint.$init$(this);
        Logging.$init$(this);
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerInfo = new scala.collection.mutable.HashMap();
        this.org$apache$spark$storage$BlockManagerMasterEndpoint$$blockManagerIdByExecutor = new scala.collection.mutable.HashMap();
        this.blockLocations = new HashMap();
        this.askThreadPool = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("block-manager-ask-thread-pool", 100, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.askExecutionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)this.askThreadPool());
        String topologyMapperClassName = conf.get("spark.storage.replication.topologyMapper", DefaultTopologyMapper.class.getName());
        Class<?> clazz = Utils$.MODULE$.classForName(topologyMapperClassName);
        TopologyMapper mapper = (TopologyMapper)clazz.getConstructor(SparkConf.class).newInstance(conf);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Using ").append(topologyMapperClassName).append(" for getting topology information").toString());
        this.topologyMapper = mapper;
        this.proactivelyReplicate = new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.storage.replication.proactive", "false"))).toBoolean();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "BlockManagerMasterEndpoint up");
    }
}

