/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.util.UUID;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.storage.TaskResultBlockId;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.storage.TestBlockId;
import org.apache.spark.storage.UnrecognizedBlockId;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

@DeveloperApi
public final class BlockId$ {
    public static BlockId$ MODULE$;
    private final Regex RDD;
    private final Regex SHUFFLE;
    private final Regex SHUFFLE_DATA;
    private final Regex SHUFFLE_INDEX;
    private final Regex BROADCAST;
    private final Regex TASKRESULT;
    private final Regex STREAM;
    private final Regex TEMP_LOCAL;
    private final Regex TEMP_SHUFFLE;
    private final Regex TEST;

    static {
        new BlockId$();
    }

    public Regex RDD() {
        return this.RDD;
    }

    public Regex SHUFFLE() {
        return this.SHUFFLE;
    }

    public Regex SHUFFLE_DATA() {
        return this.SHUFFLE_DATA;
    }

    public Regex SHUFFLE_INDEX() {
        return this.SHUFFLE_INDEX;
    }

    public Regex BROADCAST() {
        return this.BROADCAST;
    }

    public Regex TASKRESULT() {
        return this.TASKRESULT;
    }

    public Regex STREAM() {
        return this.STREAM;
    }

    public Regex TEMP_LOCAL() {
        return this.TEMP_LOCAL;
    }

    public Regex TEMP_SHUFFLE() {
        return this.TEMP_SHUFFLE;
    }

    public Regex TEST() {
        return this.TEST;
    }

    public BlockId apply(String name) {
        BlockId blockId;
        String string = name;
        Option option = this.RDD().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String rddId = (String)((LinearSeqOptimized)option.get()).apply(0);
            String splitIndex = (String)((LinearSeqOptimized)option.get()).apply(1);
            blockId = new RDDBlockId(new StringOps(Predef$.MODULE$.augmentString(rddId)).toInt(), new StringOps(Predef$.MODULE$.augmentString(splitIndex)).toInt());
        } else {
            Option option2 = this.SHUFFLE().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(3) == 0) {
                String shuffleId = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String mapId = (String)((LinearSeqOptimized)option2.get()).apply(1);
                String reduceId = (String)((LinearSeqOptimized)option2.get()).apply(2);
                blockId = new ShuffleBlockId(new StringOps(Predef$.MODULE$.augmentString(shuffleId)).toInt(), new StringOps(Predef$.MODULE$.augmentString(mapId)).toInt(), new StringOps(Predef$.MODULE$.augmentString(reduceId)).toInt());
            } else {
                Option option3 = this.SHUFFLE_DATA().unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(3) == 0) {
                    String shuffleId = (String)((LinearSeqOptimized)option3.get()).apply(0);
                    String mapId = (String)((LinearSeqOptimized)option3.get()).apply(1);
                    String reduceId = (String)((LinearSeqOptimized)option3.get()).apply(2);
                    blockId = new ShuffleDataBlockId(new StringOps(Predef$.MODULE$.augmentString(shuffleId)).toInt(), new StringOps(Predef$.MODULE$.augmentString(mapId)).toInt(), new StringOps(Predef$.MODULE$.augmentString(reduceId)).toInt());
                } else {
                    Option option4 = this.SHUFFLE_INDEX().unapplySeq((CharSequence)string);
                    if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(3) == 0) {
                        String shuffleId = (String)((LinearSeqOptimized)option4.get()).apply(0);
                        String mapId = (String)((LinearSeqOptimized)option4.get()).apply(1);
                        String reduceId = (String)((LinearSeqOptimized)option4.get()).apply(2);
                        blockId = new ShuffleIndexBlockId(new StringOps(Predef$.MODULE$.augmentString(shuffleId)).toInt(), new StringOps(Predef$.MODULE$.augmentString(mapId)).toInt(), new StringOps(Predef$.MODULE$.augmentString(reduceId)).toInt());
                    } else {
                        Option option5 = this.BROADCAST().unapplySeq((CharSequence)string);
                        if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(2) == 0) {
                            String broadcastId = (String)((LinearSeqOptimized)option5.get()).apply(0);
                            String field = (String)((LinearSeqOptimized)option5.get()).apply(1);
                            blockId = new BroadcastBlockId(new StringOps(Predef$.MODULE$.augmentString(broadcastId)).toLong(), new StringOps(Predef$.MODULE$.augmentString(field)).stripPrefix("_"));
                        } else {
                            Option option6 = this.TASKRESULT().unapplySeq((CharSequence)string);
                            if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(1) == 0) {
                                String taskId = (String)((LinearSeqOptimized)option6.get()).apply(0);
                                blockId = new TaskResultBlockId(new StringOps(Predef$.MODULE$.augmentString(taskId)).toLong());
                            } else {
                                Option option7 = this.STREAM().unapplySeq((CharSequence)string);
                                if (!option7.isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(2) == 0) {
                                    String streamId = (String)((LinearSeqOptimized)option7.get()).apply(0);
                                    String uniqueId = (String)((LinearSeqOptimized)option7.get()).apply(1);
                                    blockId = new StreamBlockId(new StringOps(Predef$.MODULE$.augmentString(streamId)).toInt(), new StringOps(Predef$.MODULE$.augmentString(uniqueId)).toLong());
                                } else {
                                    Option option8 = this.TEMP_LOCAL().unapplySeq((CharSequence)string);
                                    if (!option8.isEmpty() && option8.get() != null && ((LinearSeqOptimized)option8.get()).lengthCompare(1) == 0) {
                                        String uuid = (String)((LinearSeqOptimized)option8.get()).apply(0);
                                        blockId = new TempLocalBlockId(UUID.fromString(uuid));
                                    } else {
                                        Option option9 = this.TEMP_SHUFFLE().unapplySeq((CharSequence)string);
                                        if (!option9.isEmpty() && option9.get() != null && ((LinearSeqOptimized)option9.get()).lengthCompare(1) == 0) {
                                            String uuid = (String)((LinearSeqOptimized)option9.get()).apply(0);
                                            blockId = new TempShuffleBlockId(UUID.fromString(uuid));
                                        } else {
                                            Option option10 = this.TEST().unapplySeq((CharSequence)string);
                                            if (!option10.isEmpty() && option10.get() != null && ((LinearSeqOptimized)option10.get()).lengthCompare(1) == 0) {
                                                String value = (String)((LinearSeqOptimized)option10.get()).apply(0);
                                                blockId = new TestBlockId(value);
                                            } else {
                                                throw new UnrecognizedBlockId(name);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return blockId;
    }

    private BlockId$() {
        MODULE$ = this;
        this.RDD = new StringOps(Predef$.MODULE$.augmentString("rdd_([0-9]+)_([0-9]+)")).r();
        this.SHUFFLE = new StringOps(Predef$.MODULE$.augmentString("shuffle_([0-9]+)_([0-9]+)_([0-9]+)")).r();
        this.SHUFFLE_DATA = new StringOps(Predef$.MODULE$.augmentString("shuffle_([0-9]+)_([0-9]+)_([0-9]+).data")).r();
        this.SHUFFLE_INDEX = new StringOps(Predef$.MODULE$.augmentString("shuffle_([0-9]+)_([0-9]+)_([0-9]+).index")).r();
        this.BROADCAST = new StringOps(Predef$.MODULE$.augmentString("broadcast_([0-9]+)([_A-Za-z0-9]*)")).r();
        this.TASKRESULT = new StringOps(Predef$.MODULE$.augmentString("taskresult_([0-9]+)")).r();
        this.STREAM = new StringOps(Predef$.MODULE$.augmentString("input-([0-9]+)-([0-9]+)")).r();
        this.TEMP_LOCAL = new StringOps(Predef$.MODULE$.augmentString("temp_local_([-A-Fa-f0-9]+)")).r();
        this.TEMP_SHUFFLE = new StringOps(Predef$.MODULE$.augmentString("temp_shuffle_([-A-Fa-f0-9]+)")).r();
        this.TEST = new StringOps(Predef$.MODULE$.augmentString("test_(.*)")).r();
    }
}

