/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import javax.annotation.Nullable;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.spark.Partitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.annotation.Private;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.io.NioBufferedFileInputStream;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.network.util.LimitedInputStream;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.sort.SerializedShuffleHandle;
import org.apache.spark.shuffle.sort.ShuffleExternalSorter;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.shuffle.sort.SpillInfo;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.TimeTrackingOutputStream;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.annotations.VisibleForTesting;
import org.spark_project.guava.io.ByteStreams;
import org.spark_project.guava.io.Closeables;
import org.spark_project.guava.io.Files;
import scala.Option;
import scala.Product2;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

@Private
public class UnsafeShuffleWriter<K, V>
extends ShuffleWriter<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(UnsafeShuffleWriter.class);
    private static final ClassTag<Object> OBJECT_CLASS_TAG = ClassTag$.MODULE$.Object();
    @VisibleForTesting
    static final int DEFAULT_INITIAL_SORT_BUFFER_SIZE = 4096;
    static final int DEFAULT_INITIAL_SER_BUFFER_SIZE = 0x100000;
    private final BlockManager blockManager;
    private final IndexShuffleBlockResolver shuffleBlockResolver;
    private final TaskMemoryManager memoryManager;
    private final SerializerInstance serializer;
    private final Partitioner partitioner;
    private final ShuffleWriteMetrics writeMetrics;
    private final int shuffleId;
    private final int mapId;
    private final TaskContext taskContext;
    private final SparkConf sparkConf;
    private final boolean transferToEnabled;
    private final int initialSortBufferSize;
    private final int inputBufferSizeInBytes;
    private final int outputBufferSizeInBytes;
    @Nullable
    private MapStatus mapStatus;
    @Nullable
    private ShuffleExternalSorter sorter;
    private long peakMemoryUsedBytes = 0L;
    private MyByteArrayOutputStream serBuffer;
    private SerializationStream serOutputStream;
    private boolean stopping = false;

    public UnsafeShuffleWriter(BlockManager blockManager, IndexShuffleBlockResolver shuffleBlockResolver, TaskMemoryManager memoryManager, SerializedShuffleHandle<K, V> handle, int mapId, TaskContext taskContext, SparkConf sparkConf) throws IOException {
        int numPartitions = handle.dependency().partitioner().numPartitions();
        if (numPartitions > SortShuffleManager.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE()) {
            throw new IllegalArgumentException("UnsafeShuffleWriter can only be used for shuffles with at most " + SortShuffleManager.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE() + " reduce partitions");
        }
        this.blockManager = blockManager;
        this.shuffleBlockResolver = shuffleBlockResolver;
        this.memoryManager = memoryManager;
        this.mapId = mapId;
        ShuffleDependency dep = handle.dependency();
        this.shuffleId = dep.shuffleId();
        this.serializer = dep.serializer().newInstance();
        this.partitioner = dep.partitioner();
        this.writeMetrics = taskContext.taskMetrics().shuffleWriteMetrics();
        this.taskContext = taskContext;
        this.sparkConf = sparkConf;
        this.transferToEnabled = sparkConf.getBoolean("spark.file.transferTo", true);
        this.initialSortBufferSize = sparkConf.getInt("spark.shuffle.sort.initialBufferSize", 4096);
        this.inputBufferSizeInBytes = (int)((Long)sparkConf.get(package$.MODULE$.SHUFFLE_FILE_BUFFER_SIZE())).longValue() * 1024;
        this.outputBufferSizeInBytes = (int)((Long)sparkConf.get(package$.MODULE$.SHUFFLE_UNSAFE_FILE_OUTPUT_BUFFER_SIZE())).longValue() * 1024;
        this.open();
    }

    private void updatePeakMemoryUsed() {
        long mem;
        if (this.sorter != null && (mem = this.sorter.getPeakMemoryUsedBytes()) > this.peakMemoryUsedBytes) {
            this.peakMemoryUsedBytes = mem;
        }
    }

    public long getPeakMemoryUsedBytes() {
        this.updatePeakMemoryUsed();
        return this.peakMemoryUsedBytes;
    }

    @Override
    @VisibleForTesting
    public void write(java.util.Iterator<Product2<K, V>> records) throws IOException {
        this.write((Iterator)JavaConverters.asScalaIteratorConverter(records).asScala());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Iterator<Product2<K, V>> records) throws IOException {
        boolean success = false;
        try {
            while (records.hasNext()) {
                this.insertRecordIntoSorter((Product2)records.next());
            }
            this.closeAndWriteOutput();
            success = true;
        }
        finally {
            if (this.sorter != null) {
                try {
                    this.sorter.cleanupResources();
                }
                catch (Exception e) {
                    if (success) {
                        throw e;
                    }
                    logger.error("In addition to a failure during writing, we failed during cleanup.", (Throwable)e);
                }
            }
        }
    }

    private void open() {
        assert (this.sorter == null);
        this.sorter = new ShuffleExternalSorter(this.memoryManager, this.blockManager, this.taskContext, this.initialSortBufferSize, this.partitioner.numPartitions(), this.sparkConf, this.writeMetrics);
        this.serBuffer = new MyByteArrayOutputStream(0x100000);
        this.serOutputStream = this.serializer.serializeStream(this.serBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void closeAndWriteOutput() throws IOException {
        long[] partitionLengths;
        assert (this.sorter != null);
        this.updatePeakMemoryUsed();
        this.serBuffer = null;
        this.serOutputStream = null;
        SpillInfo[] spills = this.sorter.closeAndGetSpills();
        this.sorter = null;
        File output = this.shuffleBlockResolver.getDataFile(this.shuffleId, this.mapId);
        File tmp = Utils.tempFileWith(output);
        try {
            try {
                partitionLengths = this.mergeSpills(spills, tmp);
            }
            catch (Throwable throwable) {
                for (SpillInfo spill : spills) {
                    if (!spill.file.exists() || spill.file.delete()) continue;
                    logger.error("Error while deleting spill file {}", (Object)spill.file.getPath());
                }
                throw throwable;
            }
            for (SpillInfo spill : spills) {
                if (!spill.file.exists() || spill.file.delete()) continue;
                logger.error("Error while deleting spill file {}", (Object)spill.file.getPath());
            }
            this.shuffleBlockResolver.writeIndexFileAndCommit(this.shuffleId, this.mapId, partitionLengths, tmp);
        }
        finally {
            if (tmp.exists() && !tmp.delete()) {
                logger.error("Error while deleting temp file {}", (Object)tmp.getAbsolutePath());
            }
        }
        this.mapStatus = MapStatus$.MODULE$.apply(this.blockManager.shuffleServerId(), partitionLengths);
    }

    @VisibleForTesting
    void insertRecordIntoSorter(Product2<K, V> record) throws IOException {
        assert (this.sorter != null);
        Object key = record._1();
        int partitionId = this.partitioner.getPartition(key);
        this.serBuffer.reset();
        this.serOutputStream.writeKey(key, OBJECT_CLASS_TAG);
        this.serOutputStream.writeValue(record._2(), OBJECT_CLASS_TAG);
        this.serOutputStream.flush();
        int serializedRecordSize = this.serBuffer.size();
        assert (serializedRecordSize > 0);
        this.sorter.insertRecord(this.serBuffer.getBuf(), Platform.BYTE_ARRAY_OFFSET, serializedRecordSize, partitionId);
    }

    @VisibleForTesting
    void forceSorterToSpill() throws IOException {
        assert (this.sorter != null);
        this.sorter.spill();
    }

    private long[] mergeSpills(SpillInfo[] spills, File outputFile) throws IOException {
        boolean compressionEnabled = this.sparkConf.getBoolean("spark.shuffle.compress", true);
        CompressionCodec compressionCodec = CompressionCodec$.MODULE$.createCodec(this.sparkConf);
        boolean fastMergeEnabled = this.sparkConf.getBoolean("spark.shuffle.unsafe.fastMergeEnabled", true);
        boolean fastMergeIsSupported = !compressionEnabled || CompressionCodec$.MODULE$.supportsConcatenationOfSerializedStreams(compressionCodec);
        boolean encryptionEnabled = this.blockManager.serializerManager().encryptionEnabled();
        try {
            long[] partitionLengths;
            if (spills.length == 0) {
                new FileOutputStream(outputFile).close();
                return new long[this.partitioner.numPartitions()];
            }
            if (spills.length == 1) {
                Files.move((File)spills[0].file, (File)outputFile);
                return spills[0].partitionLengths;
            }
            if (fastMergeEnabled && fastMergeIsSupported) {
                if (this.transferToEnabled && !encryptionEnabled) {
                    logger.debug("Using transferTo-based fast merge");
                    partitionLengths = this.mergeSpillsWithTransferTo(spills, outputFile);
                } else {
                    logger.debug("Using fileStream-based fast merge");
                    partitionLengths = this.mergeSpillsWithFileStream(spills, outputFile, null);
                }
            } else {
                logger.debug("Using slow merge");
                partitionLengths = this.mergeSpillsWithFileStream(spills, outputFile, compressionCodec);
            }
            this.writeMetrics.decBytesWritten(spills[spills.length - 1].file.length());
            this.writeMetrics.incBytesWritten(outputFile.length());
            return partitionLengths;
        }
        catch (IOException e) {
            if (outputFile.exists() && !outputFile.delete()) {
                logger.error("Unable to delete output file {}", (Object)outputFile.getPath());
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] mergeSpillsWithFileStream(SpillInfo[] spills, File outputFile, @Nullable CompressionCodec compressionCodec) throws IOException {
        assert (spills.length >= 2);
        int numPartitions = this.partitioner.numPartitions();
        long[] partitionLengths = new long[numPartitions];
        InputStream[] spillInputStreams = new InputStream[spills.length];
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile), this.outputBufferSizeInBytes);
        CountingOutputStream mergedFileOutputStream = new CountingOutputStream((OutputStream)bos);
        boolean threwException = true;
        try {
            for (int i = 0; i < spills.length; ++i) {
                spillInputStreams[i] = new NioBufferedFileInputStream(spills[i].file, this.inputBufferSizeInBytes);
            }
            for (int partition = 0; partition < numPartitions; ++partition) {
                long initialFileLength = mergedFileOutputStream.getByteCount();
                Object partitionOutput = new CloseAndFlushShieldOutputStream(new TimeTrackingOutputStream(this.writeMetrics, (OutputStream)mergedFileOutputStream));
                partitionOutput = this.blockManager.serializerManager().wrapForEncryption((OutputStream)partitionOutput);
                if (compressionCodec != null) {
                    partitionOutput = compressionCodec.compressedOutputStream((OutputStream)partitionOutput);
                }
                for (int i = 0; i < spills.length; ++i) {
                    long partitionLengthInSpill = spills[i].partitionLengths[partition];
                    if (partitionLengthInSpill <= 0L) continue;
                    try (Object partitionInputStream = new LimitedInputStream(spillInputStreams[i], partitionLengthInSpill, false);){
                        partitionInputStream = this.blockManager.serializerManager().wrapForEncryption((InputStream)partitionInputStream);
                        if (compressionCodec != null) {
                            partitionInputStream = compressionCodec.compressedInputStream((InputStream)partitionInputStream);
                        }
                        ByteStreams.copy((InputStream)partitionInputStream, (OutputStream)partitionOutput);
                        continue;
                    }
                }
                ((OutputStream)partitionOutput).flush();
                ((OutputStream)partitionOutput).close();
                partitionLengths[partition] = mergedFileOutputStream.getByteCount() - initialFileLength;
            }
            threwException = false;
        }
        finally {
            for (InputStream stream : spillInputStreams) {
                Closeables.close((Closeable)stream, (boolean)threwException);
            }
            Closeables.close((Closeable)mergedFileOutputStream, (boolean)threwException);
        }
        return partitionLengths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] mergeSpillsWithTransferTo(SpillInfo[] spills, File outputFile) throws IOException {
        assert (spills.length >= 2);
        int numPartitions = this.partitioner.numPartitions();
        long[] partitionLengths = new long[numPartitions];
        FileChannel[] spillInputChannels = new FileChannel[spills.length];
        long[] spillInputChannelPositions = new long[spills.length];
        FileChannel mergedFileOutputChannel = null;
        boolean threwException = true;
        try {
            for (int i = 0; i < spills.length; ++i) {
                spillInputChannels[i] = new FileInputStream(spills[i].file).getChannel();
            }
            mergedFileOutputChannel = new FileOutputStream(outputFile, true).getChannel();
            long bytesWrittenToMergedFile = 0L;
            for (int partition = 0; partition < numPartitions; ++partition) {
                int i = 0;
                while (i < spills.length) {
                    long partitionLengthInSpill = spills[i].partitionLengths[partition];
                    FileChannel spillInputChannel = spillInputChannels[i];
                    long writeStartTime = System.nanoTime();
                    Utils.copyFileStreamNIO(spillInputChannel, mergedFileOutputChannel, spillInputChannelPositions[i], partitionLengthInSpill);
                    int n = i++;
                    spillInputChannelPositions[n] = spillInputChannelPositions[n] + partitionLengthInSpill;
                    this.writeMetrics.incWriteTime(System.nanoTime() - writeStartTime);
                    bytesWrittenToMergedFile += partitionLengthInSpill;
                    int n2 = partition;
                    partitionLengths[n2] = partitionLengths[n2] + partitionLengthInSpill;
                }
            }
            if (mergedFileOutputChannel.position() != bytesWrittenToMergedFile) {
                throw new IOException("Current position " + mergedFileOutputChannel.position() + " does not equal expected position " + bytesWrittenToMergedFile + " after transferTo. Please check your kernel version to see if it is 2.6.32, as there is a kernel bug which will lead to unexpected behavior when using transferTo. You can set spark.file.transferTo=false to disable this NIO feature.");
            }
            threwException = false;
        }
        catch (Throwable throwable) {
            for (int i = 0; i < spills.length; ++i) {
                assert (spillInputChannelPositions[i] == spills[i].file.length());
                Closeables.close((Closeable)spillInputChannels[i], (boolean)threwException);
            }
            Closeables.close(mergedFileOutputChannel, (boolean)threwException);
            throw throwable;
        }
        for (int i = 0; i < spills.length; ++i) {
            assert (spillInputChannelPositions[i] == spills[i].file.length());
            Closeables.close((Closeable)spillInputChannels[i], (boolean)threwException);
        }
        Closeables.close((Closeable)mergedFileOutputChannel, (boolean)threwException);
        return partitionLengths;
    }

    @Override
    public Option<MapStatus> stop(boolean success) {
        try {
            this.taskContext.taskMetrics().incPeakExecutionMemory(this.getPeakMemoryUsedBytes());
            if (this.stopping) {
                Option option = Option.apply(null);
                return option;
            }
            this.stopping = true;
            if (success) {
                if (this.mapStatus == null) {
                    throw new IllegalStateException("Cannot call stop(true) without having called write()");
                }
                Option option = Option.apply((Object)this.mapStatus);
                return option;
            }
            Option option = Option.apply(null);
            return option;
        }
        finally {
            if (this.sorter != null) {
                this.sorter.cleanupResources();
            }
        }
    }

    private class CloseAndFlushShieldOutputStream
    extends CloseShieldOutputStream {
        CloseAndFlushShieldOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void flush() {
        }
    }

    private static final class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        MyByteArrayOutputStream(int size) {
            super(size);
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

