/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.UnsafeInput;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.spark.SparkException;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.KryoDeserializationStream;
import org.apache.spark.serializer.KryoSerializationStream;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c!B\u0001\u0003\u0001\u0011Q!AF&ss>\u001cVM]5bY&TXM]%ogR\fgnY3\u000b\u0005\r!\u0011AC:fe&\fG.\u001b>fe*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0005\u0002\u0001\u0017A\u0011A\"D\u0007\u0002\u0005%\u0011aB\u0001\u0002\u0013'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\:uC:\u001cW\r\u0003\u0005\u0011\u0001\t\u0005\t\u0015!\u0003\u0013\u0003\tY7o\u0001\u0001\u0011\u00051\u0019\u0012B\u0001\u000b\u0003\u00059Y%/_8TKJL\u0017\r\\5{KJD\u0001B\u0006\u0001\u0003\u0002\u0003\u0006IaF\u0001\nkN,WK\\:bM\u0016\u0004\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011qAQ8pY\u0016\fg\u000eC\u0003\u001f\u0001\u0011\u0005q$\u0001\u0004=S:LGO\u0010\u000b\u0004A\u0005\u0012\u0003C\u0001\u0007\u0001\u0011\u0015\u0001R\u00041\u0001\u0013\u0011\u00151R\u00041\u0001\u0018\u0011\u0019!\u0003\u0001)Q\u0005K\u0005Q1-Y2iK\u0012\\%/_8\u0011\u0005\u0019jS\"A\u0014\u000b\u0005!J\u0013\u0001B6ss>T!AK\u0016\u0002!\u0015\u001cx\u000e^3sS\u000e\u001cxN\u001a;xCJ,'\"\u0001\u0017\u0002\u0007\r|W.\u0003\u0002/O\t!1J]=pQ\t\u0019\u0003\u0007\u0005\u00022m5\t!G\u0003\u00024i\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0003U\nQA[1wCbL!a\u000e\u001a\u0003\u00119+H\u000e\\1cY\u0016Da!\u000f\u0001\u0005\u0002\tQ\u0014A\u00032peJ|wo\u0013:z_R\tQ\u0005\u0003\u0004=\u0001\u0011\u0005!!P\u0001\fe\u0016dW-Y:f\u0017JLx\u000e\u0006\u0002?\u0003B\u0011\u0001dP\u0005\u0003\u0001f\u0011A!\u00168ji\")\u0001f\u000fa\u0001K!A1\t\u0001EC\u0002\u0013%A)\u0001\u0004pkR\u0004X\u000f^\u000b\u0002\u000bB\u0011a)S\u0007\u0002\u000f*\u0011\u0001jJ\u0001\u0003S>L!AS$\u0003\r=+H\u000f];u\u0011!a\u0005\u0001#b\u0001\n\u0013i\u0015!B5oaV$X#\u0001(\u0011\u0005\u0019{\u0015B\u0001)H\u0005\u0015Ie\u000e];u\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003%\u0019XM]5bY&TX-\u0006\u0002UQR\u0011Q+\u001d\u000b\u0003-z\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u00079LwNC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&A\u0003\"zi\u0016\u0014UO\u001a4fe\"9q,UA\u0001\u0002\b\u0001\u0017AC3wS\u0012,gnY3%gA\u0019\u0011\r\u001a4\u000e\u0003\tT!aY\r\u0002\u000fI,g\r\\3di&\u0011QM\u0019\u0002\t\u00072\f7o\u001d+bOB\u0011q\r\u001b\u0007\u0001\t\u0015I\u0017K1\u0001k\u0005\u0005!\u0016CA6o!\tAB.\u0003\u0002n3\t9aj\u001c;iS:<\u0007C\u0001\rp\u0013\t\u0001\u0018DA\u0002B]fDQA])A\u0002\u0019\f\u0011\u0001\u001e\u0005\u0006i\u0002!\t%^\u0001\fI\u0016\u001cXM]5bY&TX-\u0006\u0002wsR\u0011q/ \u000b\u0003qj\u0004\"aZ=\u0005\u000b%\u001c(\u0019\u00016\t\u000fm\u001c\u0018\u0011!a\u0002y\u0006QQM^5eK:\u001cW\r\n\u001b\u0011\u0007\u0005$\u0007\u0010C\u0003\u007fg\u0002\u0007a+A\u0003csR,7\u000f\u0003\u0004u\u0001\u0011\u0005\u0013\u0011A\u000b\u0005\u0003\u0007\tI\u0001\u0006\u0004\u0002\u0006\u0005E\u00111\u0003\u000b\u0005\u0003\u000f\tY\u0001E\u0002h\u0003\u0013!Q![@C\u0002)D\u0011\"!\u0004\u0000\u0003\u0003\u0005\u001d!a\u0004\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$S\u0007\u0005\u0003bI\u0006\u001d\u0001\"\u0002@\u0000\u0001\u00041\u0006bBA\u000b\u007f\u0002\u0007\u0011qC\u0001\u0007Y>\fG-\u001a:\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b[\u0003\u0011a\u0017M\\4\n\t\u0005\u0005\u00121\u0004\u0002\f\u00072\f7o\u001d'pC\u0012,'\u000fC\u0004\u0002&\u0001!\t%a\n\u0002\u001fM,'/[1mSj,7\u000b\u001e:fC6$B!!\u000b\u00020A\u0019A\"a\u000b\n\u0007\u00055\"AA\nTKJL\u0017\r\\5{CRLwN\\*ue\u0016\fW\u000e\u0003\u0005\u00022\u0005\r\u0002\u0019AA\u001a\u0003\u0005\u0019\b\u0003BA\u001b\u0003si!!a\u000e\u000b\u0005!S\u0016\u0002BA\u001e\u0003o\u0011AbT;uaV$8\u000b\u001e:fC6Dq!a\u0010\u0001\t\u0003\n\t%A\teKN,'/[1mSj,7\u000b\u001e:fC6$B!a\u0011\u0002JA\u0019A\"!\u0012\n\u0007\u0005\u001d#AA\u000bEKN,'/[1mSj\fG/[8o'R\u0014X-Y7\t\u0011\u0005E\u0012Q\ba\u0001\u0003\u0017\u0002B!!\u000e\u0002N%!\u0011qJA\u001c\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V\u0005aq-\u001a;BkR|'+Z:fiR\tq\u0003")
public class KryoSerializerInstance
extends SerializerInstance {
    private Output output;
    private Input input;
    private final KryoSerializer ks;
    private final boolean useUnsafe;
    @Nullable
    private Kryo cachedKryo;
    private volatile byte bitmap$0;

    /*
     * WARNING - void declaration
     */
    public Kryo borrowKryo() {
        Kryo kryo;
        if (this.cachedKryo != null) {
            void var1_1;
            Kryo kryo2 = this.cachedKryo;
            kryo2.reset();
            this.cachedKryo = null;
            kryo = var1_1;
        } else {
            kryo = this.ks.newKryo();
        }
        return kryo;
    }

    public void releaseKryo(Kryo kryo) {
        block0: {
            if (this.cachedKryo != null) break block0;
            this.cachedKryo = kryo;
        }
    }

    private Output output$lzycompute() {
        KryoSerializerInstance kryoSerializerInstance = this;
        synchronized (kryoSerializerInstance) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.output = this.ks.newKryoOutput();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.output;
    }

    private Output output() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.output$lzycompute() : this.output;
    }

    private Input input$lzycompute() {
        KryoSerializerInstance kryoSerializerInstance = this;
        synchronized (kryoSerializerInstance) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.input = this.useUnsafe ? new UnsafeInput() : new Input();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.input;
    }

    private Input input() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.input$lzycompute() : this.input;
    }

    @Override
    public <T> ByteBuffer serialize(T t, ClassTag<T> evidence$3) {
        this.output().clear();
        Kryo kryo = this.borrowKryo();
        try {
            try {
                kryo.writeClassAndObject(this.output(), t);
            }
            catch (Throwable throwable) {
                KryoException kryoException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof KryoException && (kryoException = (KryoException)throwable2).getMessage().startsWith("Buffer overflow")) {
                    throw new SparkException(new StringBuilder(91).append("Kryo serialization failed: ").append(kryoException.getMessage()).append(". To avoid this, ").append("increase spark.kryoserializer.buffer.max value.").toString(), (Throwable)kryoException);
                }
                throw throwable;
            }
        }
        finally {
            this.releaseKryo(kryo);
        }
        return ByteBuffer.wrap(this.output().toBytes());
    }

    @Override
    public <T> T deserialize(ByteBuffer bytes, ClassTag<T> evidence$4) {
        Object object;
        Kryo kryo = this.borrowKryo();
        try {
            this.input().setBuffer(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining());
            object = kryo.readClassAndObject(this.input());
        }
        finally {
            this.releaseKryo(kryo);
        }
        return (T)object;
    }

    @Override
    public <T> T deserialize(ByteBuffer bytes, ClassLoader loader, ClassTag<T> evidence$5) {
        Object object;
        Kryo kryo = this.borrowKryo();
        ClassLoader oldClassLoader = kryo.getClassLoader();
        try {
            kryo.setClassLoader(loader);
            this.input().setBuffer(bytes.array(), bytes.arrayOffset() + bytes.position(), bytes.remaining());
            object = kryo.readClassAndObject(this.input());
        }
        finally {
            kryo.setClassLoader(oldClassLoader);
            this.releaseKryo(kryo);
        }
        return (T)object;
    }

    @Override
    public SerializationStream serializeStream(OutputStream s) {
        return new KryoSerializationStream(this, s, this.useUnsafe);
    }

    @Override
    public DeserializationStream deserializeStream(InputStream s) {
        return new KryoDeserializationStream(this, s, this.useUnsafe);
    }

    public boolean getAutoReset() {
        boolean bl;
        Field field = Kryo.class.getDeclaredField("autoReset");
        field.setAccessible(true);
        Kryo kryo = this.borrowKryo();
        try {
            bl = BoxesRunTime.unboxToBoolean((Object)field.get(kryo));
        }
        finally {
            this.releaseKryo(kryo);
        }
        return bl;
    }

    public KryoSerializerInstance(KryoSerializer ks, boolean useUnsafe) {
        this.ks = ks;
        this.useUnsafe = useUnsafe;
        this.cachedKryo = this.borrowKryo();
    }
}

