/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf!B\u0001\u0003\u0001\tQ!!F$f]\u0016\u0014\u0018nY!we>\u001cVM]5bY&TXM\u001d\u0006\u0003\u0007\u0011\t!b]3sS\u0006d\u0017N_3s\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7C\u0001\u0001\f!\ra1#F\u0007\u0002\u001b)\u0011abD\u0001\u0005WJLxN\u0003\u0002\u0011#\u0005\u0001Rm]8uKJL7m]8gi^\f'/\u001a\u0006\u0002%\u0005\u00191m\\7\n\u0005Qi!AC*fe&\fG.\u001b>feB\u0011acG\u0007\u0002/)\u0011\u0001$G\u0001\bO\u0016tWM]5d\u0015\tQb!\u0001\u0003bmJ|\u0017B\u0001\u000f\u0018\u000559UM\\3sS\u000e\u0014VmY8sI\"Aa\u0004\u0001B\u0001B\u0003%\u0001%A\u0004tG\",W.Y:\u0004\u0001A!\u0011EK\u00172\u001d\t\u0011\u0003\u0006\u0005\u0002$M5\tAE\u0003\u0002&?\u00051AH]8pizR\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\na\u0001\u0015:fI\u00164\u0017BA\u0016-\u0005\ri\u0015\r\u001d\u0006\u0003S\u0019\u0002\"AL\u0018\u000e\u0003\u0019J!\u0001\r\u0014\u0003\t1{gn\u001a\t\u0003CIJ!a\r\u0017\u0003\rM#(/\u001b8h\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019a\u0014N\\5u}Q\u0011q'\u000f\t\u0003q\u0001i\u0011A\u0001\u0005\u0006=Q\u0002\r\u0001\t\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u00035\u0019w.\u001c9sKN\u001c8)Y2iKV\tQ\b\u0005\u0003?\u0007\u0016KU\"A \u000b\u0005\u0001\u000b\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u0005\u001a\n!bY8mY\u0016\u001cG/[8o\u0013\t!uHA\u0004ICNDW*\u00199\u0011\u0005\u0019;U\"A\r\n\u0005!K\"AB*dQ\u0016l\u0017\rE\u0002/\u00152K!a\u0013\u0014\u0003\u000b\u0005\u0013(/Y=\u0011\u00059j\u0015B\u0001('\u0005\u0011\u0011\u0015\u0010^3\t\rA\u0003\u0001\u0015!\u0003>\u00039\u0019w.\u001c9sKN\u001c8)Y2iK\u0002BqA\u0015\u0001C\u0002\u0013%1+A\beK\u000e|W\u000e\u001d:fgN\u001c\u0015m\u00195f+\u0005!\u0006\u0003\u0002 D+\u0016\u0003\"AV.\u000e\u0003]S!\u0001W-\u0002\u00079LwNC\u0001[\u0003\u0011Q\u0017M^1\n\u0005q;&A\u0003\"zi\u0016\u0014UO\u001a4fe\"1a\f\u0001Q\u0001\nQ\u000b\u0001\u0003Z3d_6\u0004(/Z:t\u0007\u0006\u001c\u0007.\u001a\u0011\t\u000f\u0001\u0004!\u0019!C\u0005C\u0006YqO]5uKJ\u001c\u0015m\u00195f+\u0005\u0011\u0007\u0003\u0002 D\u000b\u000e\u0004$\u0001\u001a7\u0011\u0007\u0015D'.D\u0001g\u0015\t9\u0017$\u0001\u0002j_&\u0011\u0011N\u001a\u0002\f\t\u0006$X/\\,sSR,'\u000f\u0005\u0002lY2\u0001A!C7o\u0003\u0003\u0005\tQ!\u0001q\u0005\ryF%\r\u0005\u0007_\u0002\u0001\u000b\u0011\u00022\u0002\u0019]\u0014\u0018\u000e^3s\u0007\u0006\u001c\u0007.\u001a\u0011\u0012\u0005E$\bC\u0001\u0018s\u0013\t\u0019hEA\u0004O_RD\u0017N\\4\u0011\u00059*\u0018B\u0001<'\u0005\r\te.\u001f\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u0003-\u0011X-\u00193fe\u000e\u000b7\r[3\u0016\u0003i\u0004BAP\"FwB\u001aA0!\u0001\u0011\u0007\u0015lx0\u0003\u0002\u007fM\nYA)\u0019;v[J+\u0017\rZ3s!\rY\u0017\u0011\u0001\u0003\f\u0003\u0007\t)!!A\u0001\u0002\u000b\u0005\u0001OA\u0002`IIBq!a\u0002\u0001A\u0003%!0\u0001\u0007sK\u0006$WM]\"bG\",\u0007\u0005C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e\u0005\u0001b-\u001b8hKJ\u0004(/\u001b8u\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003\u001f\u0001BAP\"F[!A\u00111\u0003\u0001!\u0002\u0013\ty!A\tgS:<WM\u001d9sS:$8)Y2iK\u0002B\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\u0002\u0017M\u001c\u0007.Z7b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u00037\u0001BAP\".\u000b\"A\u0011q\u0004\u0001!\u0002\u0013\tY\"\u0001\u0007tG\",W.Y\"bG\",\u0007\u0005\u0003\u0006\u0002$\u0001A)\u0019!C\u0005\u0003K\tQaY8eK\u000e,\"!a\n\u0011\t\u0005%\u0012QF\u0007\u0003\u0003WQ!a\u001a\u0003\n\t\u0005=\u00121\u0006\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000eDq!a\r\u0001\t\u0003\t)$\u0001\u0005d_6\u0004(/Z:t)\rI\u0015q\u0007\u0005\b\u0003s\t\t\u00041\u0001F\u0003\u0019\u00198\r[3nC\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012A\u00033fG>l\u0007O]3tgR\u0019Q)!\u0011\t\u000f\u0005\r\u00131\ba\u0001+\u0006Y1o\u00195f[\u0006\u0014\u0015\u0010^3t\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013\nab]3sS\u0006d\u0017N_3ECR,X.\u0006\u0003\u0002L\u0005eCCBA'\u0003'\ny\u0006E\u0002/\u0003\u001fJ1!!\u0015'\u0005\u0011)f.\u001b;\t\u0011\u0005U\u0013Q\ta\u0001\u0003/\nQ\u0001Z1uk6\u00042a[A-\t!\tY&!\u0012C\u0002\u0005u#!\u0001*\u0012\u0005E,\u0002\u0002CA1\u0003\u000b\u0002\r!a\u0019\u0002\r=,H\u000f];u!\u0011\t)'!\u001b\u000e\u0005\u0005\u001d$BA4\u000e\u0013\u0011\tY'a\u001a\u0003\r=+H\u000f];u\u0011\u001d\ty\u0007\u0001C\u0001\u0003c\n\u0001\u0003Z3tKJL\u0017\r\\5{K\u0012\u000bG/^7\u0015\u0007U\t\u0019\b\u0003\u0005\u0002v\u00055\u0004\u0019AA<\u0003\u0015Ig\u000e];u!\u0011\t)'!\u001f\n\t\u0005m\u0014q\r\u0002\u0006\u0013:\u0004X\u000f\u001e\u0005\b\u0003\u007f\u0002A\u0011IAA\u0003\u00159(/\u001b;f)!\ti%a!\u0002\f\u00065\u0005b\u0002\b\u0002~\u0001\u0007\u0011Q\u0011\t\u0004\u0019\u0005\u001d\u0015bAAE\u001b\t!1J]=p\u0011!\t\t'! A\u0002\u0005\r\u0004bBA+\u0003{\u0002\r!\u0006\u0005\b\u0003#\u0003A\u0011IAJ\u0003\u0011\u0011X-\u00193\u0015\u000fU\t)*a&\u0002\u001a\"9a\"a$A\u0002\u0005\u0015\u0005\u0002CA;\u0003\u001f\u0003\r!a\u001e\t\u0011\u0005m\u0015q\u0012a\u0001\u0003;\u000b!\u0002Z1uk6\u001cE.Y:t!\u0011\t\u0013qT\u000b\n\u0007\u0005\u0005FFA\u0003DY\u0006\u001c8\u000f")
public class GenericAvroSerializer
extends Serializer<GenericRecord> {
    private CompressionCodec codec;
    private final Map<Object, String> schemas;
    private final HashMap<Schema, byte[]> compressCache;
    private final HashMap<ByteBuffer, Schema> decompressCache;
    private final HashMap<Schema, DatumWriter<?>> writerCache;
    private final HashMap<Schema, DatumReader<?>> readerCache;
    private final HashMap<Schema, Object> fingerprintCache;
    private final HashMap<Object, Schema> schemaCache;
    private volatile boolean bitmap$0;

    private HashMap<Schema, byte[]> compressCache() {
        return this.compressCache;
    }

    private HashMap<ByteBuffer, Schema> decompressCache() {
        return this.decompressCache;
    }

    private HashMap<Schema, DatumWriter<?>> writerCache() {
        return this.writerCache;
    }

    private HashMap<Schema, DatumReader<?>> readerCache() {
        return this.readerCache;
    }

    private HashMap<Schema, Object> fingerprintCache() {
        return this.fingerprintCache;
    }

    private HashMap<Object, Schema> schemaCache() {
        return this.schemaCache;
    }

    private CompressionCodec codec$lzycompute() {
        GenericAvroSerializer genericAvroSerializer = this;
        synchronized (genericAvroSerializer) {
            if (!this.bitmap$0) {
                this.codec = CompressionCodec$.MODULE$.createCodec(SparkEnv$.MODULE$.get().conf());
                this.bitmap$0 = true;
            }
        }
        return this.codec;
    }

    private CompressionCodec codec() {
        return !this.bitmap$0 ? this.codec$lzycompute() : this.codec;
    }

    public byte[] compress(Schema schema) {
        return (byte[])this.compressCache().getOrElseUpdate((Object)schema, (Function0 & Serializable & scala.Serializable)() -> {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStream out = this.codec().compressedOutputStream(bos);
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.write(schema.toString().getBytes(StandardCharsets.UTF_8)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
            return bos.toByteArray();
        });
    }

    public Schema decompress(ByteBuffer schemaBytes) {
        return (Schema)this.decompressCache().getOrElseUpdate((Object)schemaBytes, (Function0 & Serializable & scala.Serializable)() -> {
            ByteArrayInputStream bis = new ByteArrayInputStream(schemaBytes.array(), schemaBytes.arrayOffset() + schemaBytes.position(), schemaBytes.remaining());
            InputStream in = this.codec().compressedInputStream(bis);
            byte[] bytes = (byte[])Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> IOUtils.toByteArray((InputStream)in), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> in.close());
            return new Schema.Parser().parse(new String(bytes, StandardCharsets.UTF_8));
        });
    }

    public <R extends GenericRecord> void serializeDatum(R datum, Output output) {
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)output, null);
        Schema schema = datum.getSchema();
        long fingerprint = BoxesRunTime.unboxToLong((Object)this.fingerprintCache().getOrElseUpdate((Object)schema, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> SchemaNormalization.parsingFingerprint64((Schema)schema)));
        Option option = this.schemas.get((Object)BoxesRunTime.boxToLong((long)fingerprint));
        if (option instanceof Some) {
            output.writeBoolean(true);
            output.writeLong(fingerprint);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            output.writeBoolean(false);
            byte[] compressedSchema = this.compress(schema);
            output.writeInt(compressedSchema.length);
            output.writeBytes(compressedSchema);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        ((DatumWriter)this.writerCache().getOrElseUpdate((Object)schema, (Function0 & Serializable & scala.Serializable)() -> GenericData.get().createDatumWriter(schema))).write(datum, (Encoder)encoder);
        encoder.flush();
    }

    public GenericRecord deserializeDatum(Input input) {
        Schema schema;
        if (input.readBoolean()) {
            long fingerprint = input.readLong();
            schema = (Schema)this.schemaCache().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)fingerprint), (Function0 & Serializable & scala.Serializable)() -> {
                Option option = $this.schemas.get((Object)BoxesRunTime.boxToLong((long)fingerprint));
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new SparkException(new StringBuilder(140).append("Error reading attempting to read avro data -- encountered an unknown ").append(new StringBuilder(63).append("fingerprint: ").append(fingerprint).append(", not sure what schema to use.  This could happen ").toString()).append("if you registered additional schemas after starting your spark context.").toString());
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                String s = (String)some.value();
                Schema schema = new Schema.Parser().parse(s);
                return schema;
            });
        } else {
            int length = input.readInt();
            schema = this.decompress(ByteBuffer.wrap(input.readBytes(length)));
        }
        Schema schema2 = schema;
        BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder((InputStream)input, null);
        return (GenericRecord)((DatumReader)this.readerCache().getOrElseUpdate((Object)schema2, (Function0 & Serializable & scala.Serializable)() -> GenericData.get().createDatumReader(schema2))).read(null, (Decoder)decoder);
    }

    public void write(Kryo kryo, Output output, GenericRecord datum) {
        this.serializeDatum(datum, output);
    }

    public GenericRecord read(Kryo kryo, Input input, Class<GenericRecord> datumClass) {
        return this.deserializeDatum(input);
    }

    public GenericAvroSerializer(Map<Object, String> schemas) {
        this.schemas = schemas;
        this.compressCache = new HashMap();
        this.decompressCache = new HashMap();
        this.writerCache = new HashMap();
        this.readerCache = new HashMap();
        this.fingerprintCache = new HashMap();
        this.schemaCache = new HashMap();
    }
}

