/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.ExecutorFailuresInTaskSet;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerExecutorBlacklistedForStage;
import org.apache.spark.scheduler.SparkListenerNodeBlacklistedForStage;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}d!B\u0001\u0003\u0001\tQ!\u0001\u0005+bg.\u001cV\r\u001e\"mC\u000e\\G.[:u\u0015\t\u0019A!A\u0005tG\",G-\u001e7fe*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\f\u0014\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0006\u0004%IAG\u0001\fY&\u001cH/\u001a8fe\n+8o\u0001\u0001\u0016\u0003m\u0001\"\u0001H\u000f\u000e\u0003\tI!A\b\u0002\u0003\u001f1Kg/\u001a'jgR,g.\u001a:CkND\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IaG\u0001\rY&\u001cH/\u001a8fe\n+8\u000f\t\u0005\tE\u0001\u0011)\u0019!C\u0001G\u0005!1m\u001c8g+\u0005!\u0003CA\u0013'\u001b\u0005!\u0011BA\u0014\u0005\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003%\u0003\u0015\u0019wN\u001c4!\u0011!Y\u0003A!b\u0001\n\u0003a\u0013aB:uC\u001e,\u0017\nZ\u000b\u0002[A\u0011ABL\u0005\u0003_5\u00111!\u00138u\u0011!\t\u0004A!A!\u0002\u0013i\u0013\u0001C:uC\u001e,\u0017\n\u001a\u0011\t\u0011M\u0002!Q1A\u0005\u00021\nab\u001d;bO\u0016\fE\u000f^3naRLE\r\u0003\u00056\u0001\t\u0005\t\u0015!\u0003.\u0003=\u0019H/Y4f\u0003R$X-\u001c9u\u0013\u0012\u0004\u0003\u0002C\u001c\u0001\u0005\u000b\u0007I\u0011\u0001\u001d\u0002\u000b\rdwnY6\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003}m\u0012Qa\u00117pG.D\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!O\u0001\u0007G2|7m\u001b\u0011\t\u000b\t\u0003A\u0011A\"\u0002\rqJg.\u001b;?)\u0019!UIR$I\u0013B\u0011A\u0004\u0001\u0005\u00061\u0005\u0003\ra\u0007\u0005\u0006E\u0005\u0003\r\u0001\n\u0005\u0006W\u0005\u0003\r!\f\u0005\u0006g\u0005\u0003\r!\f\u0005\u0006o\u0005\u0003\r!\u000f\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003-\u0003yi\u0015\tW0U\u0003N[u,\u0011+U\u000b6\u0003FkU0Q\u000bJ{V\tW#D+R{%\u000b\u0003\u0004N\u0001\u0001\u0006I!L\u0001 \u001b\u0006Cv\fV!T\u0017~\u000bE\u000bV#N!R\u001bv\fU#S?\u0016CViQ+U\u001fJ\u0003\u0003bB(\u0001\u0005\u0004%I\u0001L\u0001\u001b\u001b\u0006Cv\fV!T\u0017~\u000bE\u000bV#N!R\u001bv\fU#S?:{E)\u0012\u0005\u0007#\u0002\u0001\u000b\u0011B\u0017\u000275\u000b\u0005l\u0018+B'.{\u0016\t\u0016+F\u001bB#6k\u0018)F%~su\nR#!\u0011\u001d\u0019\u0006A1A\u0005\n1\n1$T!Y?\u001a\u000b\u0015\nT+S\u000bN{\u0006+\u0012*`\u000bb+5iX*U\u0003\u001e+\u0005BB+\u0001A\u0003%Q&\u0001\u000fN\u0003b{f)Q%M+J+5k\u0018)F%~+\u0005,R\"`'R\u000bu)\u0012\u0011\t\u000f]\u0003!\u0019!C\u0005Y\u0005qR*\u0011-`\r\u0006KE*\u0012#`\u000bb+5i\u0018)F%~su\nR#`'R\u000bu)\u0012\u0005\u00073\u0002\u0001\u000b\u0011B\u0017\u0002?5\u000b\u0005l\u0018$B\u00132+EiX#Y\u000b\u000e{\u0006+\u0012*`\u001d>#UiX*U\u0003\u001e+\u0005\u0005C\u0004\\\u0001\t\u0007I\u0011\u0001/\u0002\u001d\u0015DXm\u0019+p\r\u0006LG.\u001e:fgV\tQ\f\u0005\u0003_G\u0016\u0004X\"A0\u000b\u0005\u0001\f\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003E6\t!bY8mY\u0016\u001cG/[8o\u0013\t!wLA\u0004ICNDW*\u00199\u0011\u0005\u0019lgBA4l!\tAW\"D\u0001j\u0015\tQ\u0017$\u0001\u0004=e>|GOP\u0005\u0003Y6\ta\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\u0019\u0019FO]5oO*\u0011A.\u0004\t\u00039EL!A\u001d\u0002\u00033\u0015CXmY;u_J4\u0015-\u001b7ve\u0016\u001c\u0018J\u001c+bg.\u001cV\r\u001e\u0005\u0007i\u0002\u0001\u000b\u0011B/\u0002\u001f\u0015DXm\u0019+p\r\u0006LG.\u001e:fg\u0002BqA\u001e\u0001C\u0002\u0013%q/A\fo_\u0012,Gk\\#yK\u000e\u001cx+\u001b;i\r\u0006LG.\u001e:fgV\t\u0001\u0010\u0005\u0003_G\u0016L\bc\u00010{K&\u00111p\u0018\u0002\b\u0011\u0006\u001c\bnU3u\u0011\u0019i\b\u0001)A\u0005q\u0006Abn\u001c3f)>,\u00050Z2t/&$\bNR1jYV\u0014Xm\u001d\u0011\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003\tAD\\8eKR{'\t\\1dW2L7\u000f^3e)\u0006\u001c8.\u00138eKb,7/\u0006\u0002\u0002\u0004A)alY3\u0002\u0006A\u0019aL_\u0017\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007\tQD\\8eKR{'\t\\1dW2L7\u000f^3e)\u0006\u001c8.\u00138eKb,7\u000f\t\u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001f\t\u0001C\u00197bG.d\u0017n\u001d;fI\u0016CXmY:\u0016\u0003eDq!a\u0005\u0001A\u0003%\u00110A\tcY\u0006\u001c7\u000e\\5ti\u0016$W\t_3dg\u0002B\u0011\"a\u0006\u0001\u0005\u0004%I!a\u0004\u0002!\td\u0017mY6mSN$X\r\u001a(pI\u0016\u001c\bbBA\u000e\u0001\u0001\u0006I!_\u0001\u0012E2\f7m\u001b7jgR,GMT8eKN\u0004\u0003\"CA\u0010\u0001\u0001\u0007I\u0011BA\u0011\u0003Ma\u0017\r^3ti\u001a\u000b\u0017\u000e\\;sKJ+\u0017m]8o+\u0005)\u0007\"CA\u0013\u0001\u0001\u0007I\u0011BA\u0014\u0003]a\u0017\r^3ti\u001a\u000b\u0017\u000e\\;sKJ+\u0017m]8o?\u0012*\u0017\u000f\u0006\u0003\u0002*\u0005=\u0002c\u0001\u0007\u0002,%\u0019\u0011QF\u0007\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003c\t\u0019#!AA\u0002\u0015\f1\u0001\u001f\u00132\u0011\u001d\t)\u0004\u0001Q!\n\u0015\fA\u0003\\1uKN$h)Y5mkJ,'+Z1t_:\u0004\u0003bBA\u001d\u0001\u0011\u0005\u0011\u0011E\u0001\u0017O\u0016$H*\u0019;fgR4\u0015-\u001b7ve\u0016\u0014V-Y:p]\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012\u0001H5t\u000bb,7-\u001e;pe\nc\u0017mY6mSN$X\r\u001a$peR\u000b7o\u001b\u000b\u0007\u0003\u0003\n9%a\u0013\u0011\u00071\t\u0019%C\u0002\u0002F5\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002J\u0005m\u0002\u0019A3\u0002\u0015\u0015DXmY;u_JLE\rC\u0004\u0002N\u0005m\u0002\u0019A\u0017\u0002\u000b%tG-\u001a=\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T\u0005A\u0012n\u001d(pI\u0016\u0014E.Y2lY&\u001cH/\u001a3G_J$\u0016m]6\u0015\r\u0005\u0005\u0013QKA-\u0011\u001d\t9&a\u0014A\u0002\u0015\fAA\\8eK\"9\u0011QJA(\u0001\u0004i\u0003bBA/\u0001\u0011\u0005\u0011qL\u0001 SN,\u00050Z2vi>\u0014(\t\\1dW2L7\u000f^3e\r>\u0014H+Y:l'\u0016$H\u0003BA!\u0003CBq!!\u0013\u0002\\\u0001\u0007Q\rC\u0004\u0002f\u0001!\t!a\u001a\u00027%\u001chj\u001c3f\u00052\f7m\u001b7jgR,GMR8s)\u0006\u001c8nU3u)\u0011\t\t%!\u001b\t\u000f\u0005]\u00131\ra\u0001K\"A\u0011Q\u000e\u0001\u0005\u0002\t\ty'\u0001\u000fva\u0012\fG/\u001a\"mC\u000e\\G.[:u\r>\u0014h)Y5mK\u0012$\u0016m]6\u0015\u0015\u0005%\u0012\u0011OA;\u0003s\nY\bC\u0004\u0002t\u0005-\u0004\u0019A3\u0002\t!|7\u000f\u001e\u0005\b\u0003o\nY\u00071\u0001f\u0003\u0011)\u00070Z2\t\u000f\u00055\u00131\u000ea\u0001[!9\u0011QPA6\u0001\u0004)\u0017!\u00044bS2,(/\u001a*fCN|g\u000e")
public class TaskSetBlacklist
implements Logging {
    private final LiveListenerBus listenerBus;
    private final SparkConf conf;
    private final int stageId;
    private final int stageAttemptId;
    private final Clock clock;
    private final int MAX_TASK_ATTEMPTS_PER_EXECUTOR;
    private final int MAX_TASK_ATTEMPTS_PER_NODE;
    private final int MAX_FAILURES_PER_EXEC_STAGE;
    private final int MAX_FAILED_EXEC_PER_NODE_STAGE;
    private final HashMap<String, ExecutorFailuresInTaskSet> execToFailures;
    private final HashMap<String, HashSet<String>> nodeToExecsWithFailures;
    private final HashMap<String, HashSet<Object>> nodeToBlacklistedTaskIndexes;
    private final HashSet<String> blacklistedExecs;
    private final HashSet<String> blacklistedNodes;
    private String latestFailureReason;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public int stageId() {
        return this.stageId;
    }

    public int stageAttemptId() {
        return this.stageAttemptId;
    }

    public Clock clock() {
        return this.clock;
    }

    private int MAX_TASK_ATTEMPTS_PER_EXECUTOR() {
        return this.MAX_TASK_ATTEMPTS_PER_EXECUTOR;
    }

    private int MAX_TASK_ATTEMPTS_PER_NODE() {
        return this.MAX_TASK_ATTEMPTS_PER_NODE;
    }

    private int MAX_FAILURES_PER_EXEC_STAGE() {
        return this.MAX_FAILURES_PER_EXEC_STAGE;
    }

    private int MAX_FAILED_EXEC_PER_NODE_STAGE() {
        return this.MAX_FAILED_EXEC_PER_NODE_STAGE;
    }

    public HashMap<String, ExecutorFailuresInTaskSet> execToFailures() {
        return this.execToFailures;
    }

    private HashMap<String, HashSet<String>> nodeToExecsWithFailures() {
        return this.nodeToExecsWithFailures;
    }

    private HashMap<String, HashSet<Object>> nodeToBlacklistedTaskIndexes() {
        return this.nodeToBlacklistedTaskIndexes;
    }

    private HashSet<String> blacklistedExecs() {
        return this.blacklistedExecs;
    }

    private HashSet<String> blacklistedNodes() {
        return this.blacklistedNodes;
    }

    private String latestFailureReason() {
        return this.latestFailureReason;
    }

    private void latestFailureReason_$eq(String x$1) {
        this.latestFailureReason = x$1;
    }

    public String getLatestFailureReason() {
        return this.latestFailureReason();
    }

    public boolean isExecutorBlacklistedForTask(String executorId, int index) {
        return this.execToFailures().get((Object)executorId).exists((Function1 & Serializable & scala.Serializable)execFailures -> BoxesRunTime.boxToBoolean((boolean)TaskSetBlacklist.$anonfun$isExecutorBlacklistedForTask$1(this, index, execFailures)));
    }

    public boolean isNodeBlacklistedForTask(String node, int index) {
        return this.nodeToBlacklistedTaskIndexes().get((Object)node).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains((Object)BoxesRunTime.boxToInteger((int)index))));
    }

    public boolean isExecutorBlacklistedForTaskSet(String executorId) {
        return this.blacklistedExecs().contains((Object)executorId);
    }

    public boolean isNodeBlacklistedForTaskSet(String node) {
        return this.blacklistedNodes().contains((Object)node);
    }

    public void updateBlacklistForFailedTask(String host, String exec2, int index, String failureReason) {
        block1: {
            this.latestFailureReason_$eq(failureReason);
            ExecutorFailuresInTaskSet execFailures = (ExecutorFailuresInTaskSet)this.execToFailures().getOrElseUpdate((Object)exec2, (Function0 & Serializable & scala.Serializable)() -> new ExecutorFailuresInTaskSet(host));
            execFailures.updateWithFailure(index, this.clock().getTimeMillis());
            HashSet execsWithFailuresOnNode = (HashSet)this.nodeToExecsWithFailures().getOrElseUpdate((Object)host, (Function0 & Serializable & scala.Serializable)() -> new HashSet());
            execsWithFailuresOnNode.$plus$eq((Object)exec2);
            int failuresOnHost = BoxesRunTime.unboxToInt((Object)execsWithFailuresOnNode.toIterator().flatMap((Function1 & Serializable & scala.Serializable)exec -> Option$.MODULE$.option2Iterable(this.execToFailures().get(exec).map((Function1 & Serializable & scala.Serializable)failures -> BoxesRunTime.boxToInteger((int)failures.getNumTaskFailures(index))))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            Object object = failuresOnHost >= this.MAX_TASK_ATTEMPTS_PER_NODE() ? ((HashSet)this.nodeToBlacklistedTaskIndexes().getOrElseUpdate((Object)host, (Function0 & Serializable & scala.Serializable)() -> new HashSet())).$plus$eq((Object)BoxesRunTime.boxToInteger((int)index)) : BoxedUnit.UNIT;
            int numFailures = execFailures.numUniqueTasksWithFailures();
            if (numFailures < this.MAX_FAILURES_PER_EXEC_STAGE() || !this.blacklistedExecs().add((Object)exec2)) break block1;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Blacklisting executor ").append(exec2).append(" for stage ").append(this.stageId()).toString());
            HashSet blacklistedExecutorsOnNode = (HashSet)execsWithFailuresOnNode.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TaskSetBlacklist.$anonfun$updateBlacklistForFailedTask$7(this, x$2)));
            long now = this.clock().getTimeMillis();
            this.listenerBus().post(new SparkListenerExecutorBlacklistedForStage(now, exec2, numFailures, this.stageId(), this.stageAttemptId()));
            int numFailExec = blacklistedExecutorsOnNode.size();
            if (numFailExec >= this.MAX_FAILED_EXEC_PER_NODE_STAGE() && this.blacklistedNodes().add((Object)host)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Blacklisting ").append(host).append(" for stage ").append(this.stageId()).toString());
                this.listenerBus().post(new SparkListenerNodeBlacklistedForStage(now, host, numFailExec, this.stageId(), this.stageAttemptId()));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$isExecutorBlacklistedForTask$1(TaskSetBlacklist $this, int index$1, ExecutorFailuresInTaskSet execFailures) {
        return execFailures.getNumTaskFailures(index$1) >= $this.MAX_TASK_ATTEMPTS_PER_EXECUTOR();
    }

    public static final /* synthetic */ boolean $anonfun$updateBlacklistForFailedTask$7(TaskSetBlacklist $this, String x$2) {
        return $this.blacklistedExecs().contains((Object)x$2);
    }

    public TaskSetBlacklist(LiveListenerBus listenerBus, SparkConf conf, int stageId, int stageAttemptId, Clock clock) {
        this.listenerBus = listenerBus;
        this.conf = conf;
        this.stageId = stageId;
        this.stageAttemptId = stageAttemptId;
        this.clock = clock;
        Logging.$init$(this);
        this.MAX_TASK_ATTEMPTS_PER_EXECUTOR = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_EXECUTOR()));
        this.MAX_TASK_ATTEMPTS_PER_NODE = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE()));
        this.MAX_FAILURES_PER_EXEC_STAGE = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_FAILURES_PER_EXEC_STAGE()));
        this.MAX_FAILED_EXEC_PER_NODE_STAGE = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_FAILED_EXEC_PER_NODE_STAGE()));
        this.execToFailures = new HashMap();
        this.nodeToExecsWithFailures = new HashMap();
        this.nodeToBlacklistedTaskIndexes = new HashMap();
        this.blacklistedExecs = new HashSet();
        this.blacklistedNodes = new HashSet();
        this.latestFailureReason = null;
    }
}

