/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.HaltReplayException;
import org.apache.spark.scheduler.ReplayListenerBus$;
import org.apache.spark.scheduler.SparkListenerBus;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.JsonProtocol$;
import org.apache.spark.util.ListenerBus;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.HashSet;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\u0001\u0003\u0001\u0011Q!!\u0005*fa2\f\u0017\u0010T5ti\u0016tWM\u001d\"vg*\u00111\u0001B\u0001\ng\u000eDW\rZ;mKJT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\n\u0005\u0001-\tR\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Mi\u0011AA\u0005\u0003)\t\u0011\u0001c\u00159be.d\u0015n\u001d;f]\u0016\u0014()^:\u0011\u0005YIR\"A\f\u000b\u0005a!\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005i9\"a\u0002'pO\u001eLgn\u001a\u0005\u00069\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tq\u0004\u0005\u0002\u0013\u0001!)\u0011\u0005\u0001C\u0001E\u00051!/\u001a9mCf$Ra\t\u00141{\t\u0003\"\u0001\u0004\u0013\n\u0005\u0015j!\u0001B+oSRDQa\n\u0011A\u0002!\nq\u0001\\8h\t\u0006$\u0018\r\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005\u0011\u0011n\u001c\u0006\u0002[\u0005!!.\u0019<b\u0013\ty#FA\u0006J]B,Ho\u0015;sK\u0006l\u0007\"B\u0019!\u0001\u0004\u0011\u0014AC:pkJ\u001cWMT1nKB\u00111G\u000f\b\u0003ia\u0002\"!N\u0007\u000e\u0003YR!aN\u000f\u0002\rq\u0012xn\u001c;?\u0013\tIT\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003wq\u0012aa\u0015;sS:<'BA\u001d\u000e\u0011\u001dq\u0004\u0005%AA\u0002}\na\"\\1zE\u0016$&/\u001e8dCR,G\r\u0005\u0002\r\u0001&\u0011\u0011)\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\u0019\u0005\u0005%AA\u0002\u0011\u000bA\"\u001a<f]R\u001ch)\u001b7uKJ\u0004\"!R+\u000f\u0005\u0019seBA$N\u001d\tAEJ\u0004\u0002J\u0017:\u0011QGS\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\r=\u0013\u0001\u0012\u0001\u0003Q\u0003E\u0011V\r\u001d7bs2K7\u000f^3oKJ\u0014Uo\u001d\t\u0003%E3a!\u0001\u0002\t\u0002\u0011\u00116CA)\f\u0011\u0015a\u0012\u000b\"\u0001U)\u0005\u0001V\u0001\u0002,R\u0001]\u0013!CU3qY\u0006LXI^3oiN4\u0015\u000e\u001c;feB!A\u0002\u0017\u001a@\u0013\tIVBA\u0005Gk:\u001cG/[8oc!91,\u0015b\u0001\n\u0003a\u0016!E*F\u0019\u0016\u001bEkX!M\u0019~3\u0015\n\u0014+F%V\tQ\f\u0005\u0002_+6\t\u0011\u000b\u0003\u0004a#\u0002\u0006I!X\u0001\u0013'\u0016cUi\u0011+`\u00032cuLR%M)\u0016\u0013\u0006\u0005C\u0003\"\u0001\u0011\u0005!\rF\u0003$G:|\u0007\u000fC\u0003eC\u0002\u0007Q-A\u0003mS:,7\u000fE\u0002gWJr!aZ5\u000f\u0005UB\u0017\"\u0001\b\n\u0005)l\u0011a\u00029bG.\fw-Z\u0005\u0003Y6\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003U6AQ!M1A\u0002IBQAP1A\u0002}BQaQ1A\u0002\u0011CQA\u001d\u0001\u0005RM\fA#[:JO:|'/\u00192mK\u0016C8-\u001a9uS>tGCA u\u0011\u0015)\u0018\u000f1\u0001w\u0003\u0005)\u0007C\u00014x\u0013\tAXNA\u0005UQJ|w/\u00192mK\"9!\u0010AI\u0001\n\u0003Y\u0018\u0001\u0005:fa2\f\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\u0005a(FA ~W\u0005q\bcA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!A\u0005v]\u000eDWmY6fI*\u0019\u0011qA\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\f\u0005\u0005!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011q\u0002\u0001\u0012\u0002\u0013\u0005\u0011\u0011C\u0001\u0011e\u0016\u0004H.Y=%I\u00164\u0017-\u001e7uIQ*\"!a\u0005+\u0005\u0011k\b")
public class ReplayListenerBus
implements SparkListenerBus {
    private final CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Function1<String, Object> SELECT_ALL_FILTER() {
        return ReplayListenerBus$.MODULE$.SELECT_ALL_FILTER();
    }

    @Override
    public void doPostEvent(SparkListenerInterface listener, SparkListenerEvent event) {
        SparkListenerBus.doPostEvent$(this, listener, event);
    }

    @Override
    public List<SparkListenerInterface> listeners() {
        return ListenerBus.listeners$(this);
    }

    @Override
    public Option getTimer(Object listener) {
        return ListenerBus.getTimer$(this, listener);
    }

    @Override
    public final void addListener(Object listener) {
        ListenerBus.addListener$(this, listener);
    }

    @Override
    public final void removeListener(Object listener) {
        ListenerBus.removeListener$(this, listener);
    }

    @Override
    public void removeListenerOnError(Object listener) {
        ListenerBus.removeListenerOnError$(this, listener);
    }

    @Override
    public void postToAll(Object event) {
        ListenerBus.postToAll$(this, event);
    }

    @Override
    public <T extends SparkListenerInterface> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return ListenerBus.findListenersByClass$(this, evidence$1);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> org$apache$spark$util$ListenerBus$$listenersPlusTimers() {
        return this.org$apache$spark$util$ListenerBus$$listenersPlusTimers;
    }

    @Override
    public final void org$apache$spark$util$ListenerBus$_setter_$org$apache$spark$util$ListenerBus$$listenersPlusTimers_$eq(CopyOnWriteArrayList<Tuple2<SparkListenerInterface, Option<Timer>>> x$1) {
        this.org$apache$spark$util$ListenerBus$$listenersPlusTimers = x$1;
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void replay(InputStream logData, String sourceName, boolean maybeTruncated, Function1<String, Object> eventsFilter) {
        Iterator lines = Source$.MODULE$.fromInputStream(logData, Codec$.MODULE$.fallbackSystemCodec()).getLines();
        this.replay((Iterator<String>)lines, sourceName, maybeTruncated, eventsFilter);
    }

    public void replay(Iterator<String> lines, String sourceName, boolean maybeTruncated, Function1<String, Object> eventsFilter) {
        ObjectRef currentLine = ObjectRef.create(null);
        IntRef lineNumber = IntRef.create((int)0);
        HashSet unrecognizedEvents = new HashSet();
        HashSet unrecognizedProperties = new HashSet();
        try {
            Iterator lineEntries = lines.zipWithIndex().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplayListenerBus.$anonfun$replay$1(eventsFilter, x0$1)));
            while (lineEntries.hasNext()) {
                try {
                    Tuple2 entry = (Tuple2)lineEntries.next();
                    currentLine.elem = (String)entry._1();
                    lineNumber.elem = entry._2$mcI$sp() + 1;
                    this.postToAll(JsonProtocol$.MODULE$.sparkEventFromJson(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput((String)currentLine.elem), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())));
                }
                catch (ClassNotFoundException e) {
                    Object object;
                    if (!unrecognizedEvents.contains((Object)e.getMessage())) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Drop unrecognized event: ").append(e.getMessage()).toString());
                        object = BoxesRunTime.boxToBoolean((boolean)unrecognizedEvents.add((Object)e.getMessage()));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Drop incompatible event log: ").append((String)currentLine$1.elem).toString());
                }
                catch (UnrecognizedPropertyException e) {
                    Object object;
                    if (!unrecognizedProperties.contains((Object)e.getMessage())) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Drop unrecognized property: ").append(e.getMessage()).toString());
                        object = BoxesRunTime.boxToBoolean((boolean)unrecognizedProperties.add((Object)e.getMessage()));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Drop incompatible event log: ").append((String)currentLine$1.elem).toString());
                }
                catch (JsonParseException jpe) {
                    if (!maybeTruncated || lineEntries.hasNext()) {
                        throw jpe;
                    }
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Got JsonParseException from log file ").append(sourceName).append(new StringBuilder(60).append(" at line ").append(lineNumber$1.elem).append(", the file might not have finished writing cleanly.").toString()).toString());
                }
            }
        }
        catch (Throwable throwable) {
            boolean bl = false;
            IOException iOException = null;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof HaltReplayException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof EOFException && maybeTruncated) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof IOException) {
                bl = true;
                iOException = (IOException)throwable2;
                if (maybeTruncated) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Failed to read Spark event log: ").append(sourceName).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            if (bl) {
                throw iOException;
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Exception parsing Spark event log: ").append(sourceName).toString(), exception);
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Malformed line #").append(lineNumber$1.elem).append(": ").append((String)currentLine$1.elem).append("\n").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public boolean replay$default$3() {
        return false;
    }

    public Function1<String, Object> replay$default$4() {
        return ReplayListenerBus$.MODULE$.SELECT_ALL_FILTER();
    }

    @Override
    public boolean isIgnorableException(Throwable e) {
        return e instanceof HaltReplayException;
    }

    public static final /* synthetic */ boolean $anonfun$replay$1(Function1 eventsFilter$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String line = (String)tuple2._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)eventsFilter$1.apply((Object)line));
        return bl;
    }

    public ReplayListenerBus() {
        Logging.$init$(this);
        ListenerBus.$init$(this);
        SparkListenerBus.$init$(this);
    }
}

