/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.InputFormatInfo$;
import org.apache.spark.scheduler.SplitInfo;
import org.apache.spark.scheduler.SplitInfo$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0001-\u0011q\"\u00138qkR4uN]7bi&sgm\u001c\u0006\u0003\u0007\u0011\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003!Ig\u000e^3s]\u0006d\u0017BA\f\u0015\u0005\u001daunZ4j]\u001eD\u0001\"\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003m\u0001\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\t\r|gN\u001a\u0006\u0003A\u0019\ta\u0001[1e_>\u0004\u0018B\u0001\u0012\u001e\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"AA\u0005\u0001B\u0001B\u0003%1$\u0001\bd_:4\u0017nZ;sCRLwN\u001c\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002\u001d\n\u0001#\u001b8qkR4uN]7bi\u000ec\u0017M\u001f>\u0016\u0003!\u0002$!\u000b\u001c\u0011\u0007)\nDG\u0004\u0002,_A\u0011AFD\u0007\u0002[)\u0011aFC\u0001\u0007yI|w\u000e\u001e \n\u0005Ar\u0011A\u0002)sK\u0012,g-\u0003\u00023g\t)1\t\\1tg*\u0011\u0001G\u0004\t\u0003kYb\u0001\u0001B\u00058q\u0005\u0005\t\u0011!B\u0001u\t\u0019q\fJ\u0019\t\u0011e\u0002!\u0011!Q\u0001\n!\n\u0011#\u001b8qkR4uN]7bi\u000ec\u0017M\u001f>!#\tYd\b\u0005\u0002\u000ey%\u0011QH\u0004\u0002\b\u001d>$\b.\u001b8h!\tiq(\u0003\u0002A\u001d\t\u0019\u0011I\\=\t\u0011\t\u0003!Q1A\u0005\u0002\r\u000bA\u0001]1uQV\tA\t\u0005\u0002+\u000b&\u0011ai\r\u0002\u0007'R\u0014\u0018N\\4\t\u0011!\u0003!\u0011!Q\u0001\n\u0011\u000bQ\u0001]1uQ\u0002BQA\u0013\u0001\u0005\u0002-\u000ba\u0001P5oSRtD\u0003\u0002'O\u001fR\u0003\"!\u0014\u0001\u000e\u0003\tAQ!G%A\u0002mAQAJ%A\u0002A\u0003$!U*\u0011\u0007)\n$\u000b\u0005\u00026'\u0012IqgTA\u0001\u0002\u0003\u0015\tA\u000f\u0005\u0006\u0005&\u0003\r\u0001\u0012\u0005\b-\u0002\u0001\r\u0011\"\u0001X\u0003Qi\u0017\r\u001d:fIV\u001cW-\u00138qkR4uN]7biV\t\u0001\f\u0005\u0002\u000e3&\u0011!L\u0004\u0002\b\u0005>|G.Z1o\u0011\u001da\u0006\u00011A\u0005\u0002u\u000b\u0001$\\1qe\u0016$WoY3J]B,HOR8s[\u0006$x\fJ3r)\tq\u0016\r\u0005\u0002\u000e?&\u0011\u0001M\u0004\u0002\u0005+:LG\u000fC\u0004c7\u0006\u0005\t\u0019\u0001-\u0002\u0007a$\u0013\u0007\u0003\u0004e\u0001\u0001\u0006K\u0001W\u0001\u0016[\u0006\u0004(/\u001a3vG\u0016Le\u000e];u\r>\u0014X.\u0019;!\u0011\u001d1\u0007\u00011A\u0005\u0002]\u000b\u0011#\\1qe\u0016$\u0017J\u001c9vi\u001a{'/\\1u\u0011\u001dA\u0007\u00011A\u0005\u0002%\fQ#\\1qe\u0016$\u0017J\u001c9vi\u001a{'/\\1u?\u0012*\u0017\u000f\u0006\u0002_U\"9!mZA\u0001\u0002\u0004A\u0006B\u00027\u0001A\u0003&\u0001,\u0001\nnCB\u0014X\rZ%oaV$hi\u001c:nCR\u0004\u0003\"\u00028\u0001\t\u0003z\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0011CQ!\u001d\u0001\u0005BI\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002gB\u0011Q\u0002^\u0005\u0003k:\u00111!\u00138u\u0011\u00159\b\u0001\"\u0011y\u0003\u0019)\u0017/^1mgR\u0011\u0001,\u001f\u0005\u0006uZ\u0004\rAP\u0001\u0006_RDWM\u001d\u0005\u0006y\u0002!I!`\u0001\tm\u0006d\u0017\u000eZ1uKR\ta\f\u0003\u0004\u0000\u0001\u0011%\u0011\u0011A\u0001!aJ,g\rT8dg\u001a\u0013x.\\'baJ,G-^2f\u0013:\u0004X\u000f\u001e$pe6\fG\u000f\u0006\u0002\u0002\u0004A1\u0011QAA\b\u0003'i!!a\u0002\u000b\t\u0005%\u00111B\u0001\nS6lW\u000f^1cY\u0016T1!!\u0004\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\t9AA\u0002TKR\u00042!TA\u000b\u0013\r\t9B\u0001\u0002\n'Bd\u0017\u000e^%oM>Dq!a\u0007\u0001\t\u0013\t\t!A\u000fqe\u00164Gj\\2t\rJ|W.T1qe\u0016$\u0017J\u001c9vi\u001a{'/\\1u\u0011\u001d\ty\u0002\u0001C\u0005\u0003\u0003\taCZ5oIB\u0013XMZ3se\u0016$Gj\\2bi&|gn\u001d\u0015\u0004\u0001\u0005\r\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%B!\u0001\u0006b]:|G/\u0019;j_:LA!!\f\u0002(\taA)\u001a<fY>\u0004XM]!qS\u001e9\u0011\u0011\u0007\u0002\t\u0002\u0005M\u0012aD%oaV$hi\u001c:nCRLeNZ8\u0011\u00075\u000b)D\u0002\u0004\u0002\u0005!\u0005\u0011qG\n\u0004\u0003ka\u0001b\u0002&\u00026\u0011\u0005\u00111\b\u000b\u0003\u0003gA\u0001\"a\u0010\u00026\u0011\u0005\u0011\u0011I\u0001\u001aG>l\u0007/\u001e;f!J,g-\u001a:sK\u0012dunY1uS>t7\u000f\u0006\u0003\u0002D\u0005%\u0003C\u0002\u0016\u0002F\u0011\u000b\u0019!C\u0002\u0002HM\u00121!T1q\u0011!\tY%!\u0010A\u0002\u00055\u0013a\u00024pe6\fGo\u001d\t\u0006\u0003\u001f\nI\u0006\u0014\b\u0005\u0003#\n)FD\u0002-\u0003'J\u0011aD\u0005\u0004\u0003/r\u0011a\u00029bG.\fw-Z\u0005\u0005\u00037\niFA\u0002TKFT1!a\u0016\u000f\u0001")
public class InputFormatInfo
implements Logging {
    private final Configuration configuration;
    private final Class<?> inputFormatClazz;
    private final String path;
    private boolean mapreduceInputFormat;
    private boolean mapredInputFormat;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Map<String, Set<SplitInfo>> computePreferredLocations(Seq<InputFormatInfo> seq) {
        return InputFormatInfo$.MODULE$.computePreferredLocations(seq);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public Class<?> inputFormatClazz() {
        return this.inputFormatClazz;
    }

    public String path() {
        return this.path;
    }

    public boolean mapreduceInputFormat() {
        return this.mapreduceInputFormat;
    }

    public void mapreduceInputFormat_$eq(boolean x$1) {
        this.mapreduceInputFormat = x$1;
    }

    public boolean mapredInputFormat() {
        return this.mapredInputFormat;
    }

    public void mapredInputFormat_$eq(boolean x$1) {
        this.mapredInputFormat = x$1;
    }

    public String toString() {
        return new StringBuilder(46).append("InputFormatInfo ").append(super.toString()).append(" .. inputFormatClazz ").append(this.inputFormatClazz()).append(", ").append("path : ").append(this.path()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int hashCode = this.inputFormatClazz().hashCode();
        hashCode = hashCode * 31 + this.path().hashCode();
        return (int)var1_1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof InputFormatInfo)) return false;
        InputFormatInfo inputFormatInfo = (InputFormatInfo)object;
        Class<?> clazz = this.inputFormatClazz();
        Class<?> clazz2 = inputFormatInfo.inputFormatClazz();
        if (clazz == null) {
            if (clazz2 != null) {
                return false;
            }
        } else if (!clazz.equals(clazz2)) return false;
        String string = this.path();
        String string2 = inputFormatInfo.path();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    private void validate() {
        block4: {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("validate InputFormatInfo : ").append(this.inputFormatClazz()).append(", path  ").append(this.path()).toString());
            try {
                if (InputFormat.class.isAssignableFrom(this.inputFormatClazz())) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "inputformat is from mapreduce package");
                    this.mapreduceInputFormat_$eq(true);
                    break block4;
                }
                if (org.apache.hadoop.mapred.InputFormat.class.isAssignableFrom(this.inputFormatClazz())) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "inputformat is from mapred package");
                    this.mapredInputFormat_$eq(true);
                    break block4;
                }
                throw new IllegalArgumentException(new StringBuilder(112).append("Specified inputformat ").append(this.inputFormatClazz()).append(" is NOT a supported input format ? does not implement either of the supported hadoop ").append("api's").toString());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Specified inputformat ").append(this.inputFormatClazz()).append(" cannot be found ?").toString(), e);
            }
        }
    }

    private Set<SplitInfo> prefLocsFromMapreduceInputFormat() {
        JobConf conf = new JobConf(this.configuration());
        SparkHadoopUtil$.MODULE$.get().addCredentials(conf);
        FileInputFormat.setInputPaths((JobConf)conf, (String)this.path());
        InputFormat instance = (InputFormat)ReflectionUtils.newInstance(this.inputFormatClazz(), (Configuration)conf);
        Job job = Job.getInstance((Configuration)conf);
        ArrayBuffer retval = new ArrayBuffer();
        List list = instance.getSplits((JobContext)job);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).foreach((Function1 & Serializable & scala.Serializable)split -> retval.$plus$plus$eq(SplitInfo$.MODULE$.toSplitInfo(this.inputFormatClazz(), this.path(), (InputSplit)split)));
        return retval.toSet();
    }

    private Set<SplitInfo> prefLocsFromMapredInputFormat() {
        JobConf jobConf = new JobConf(this.configuration());
        SparkHadoopUtil$.MODULE$.get().addCredentials(jobConf);
        FileInputFormat.setInputPaths((JobConf)jobConf, (String)this.path());
        org.apache.hadoop.mapred.InputFormat instance = (org.apache.hadoop.mapred.InputFormat)ReflectionUtils.newInstance(this.inputFormatClazz(), (Configuration)jobConf);
        ArrayBuffer retval = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])instance.getSplits(jobConf, jobConf.getNumMapTasks()))).foreach((Function1 & Serializable & scala.Serializable)elem -> retval.$plus$plus$eq(SplitInfo$.MODULE$.toSplitInfo(this.inputFormatClazz(), this.path(), (org.apache.hadoop.mapred.InputSplit)elem)));
        return retval.toSet();
    }

    public Set<SplitInfo> org$apache$spark$scheduler$InputFormatInfo$$findPreferredLocations() {
        Set<SplitInfo> set;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("mapreduceInputFormat : ").append(this.mapreduceInputFormat()).append(", mapredInputFormat : ").append(this.mapredInputFormat()).append(", inputFormatClazz : ").append(this.inputFormatClazz()).toString());
        if (this.mapreduceInputFormat()) {
            set = this.prefLocsFromMapreduceInputFormat();
        } else {
            Predef$.MODULE$.assert(this.mapredInputFormat());
            set = this.prefLocsFromMapredInputFormat();
        }
        return set;
    }

    public InputFormatInfo(Configuration configuration, Class<?> inputFormatClazz, String path) {
        this.configuration = configuration;
        this.inputFormatClazz = inputFormatClazz;
        this.path = path;
        Logging.$init$(this);
        this.mapreduceInputFormat = false;
        this.mapredInputFormat = false;
        this.validate();
    }
}

