/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.BlacklistTracker$;
import org.apache.spark.scheduler.BlacklistTracker$ExecutorFailureList$TaskId$;
import org.apache.spark.scheduler.BlacklistedExecutor;
import org.apache.spark.scheduler.ExecutorFailuresInTaskSet;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SparkListenerExecutorBlacklisted;
import org.apache.spark.scheduler.SparkListenerExecutorUnblacklisted;
import org.apache.spark.scheduler.SparkListenerNodeBlacklisted;
import org.apache.spark.scheduler.SparkListenerNodeUnblacklisted;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Iterable$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r-c!B\u0001\u0003\u0001\tQ!\u0001\u0005\"mC\u000e\\G.[:u)J\f7m[3s\u0015\t\u0019A!A\u0005tG\",G-\u001e7fe*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\f\u0014\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0006\u0004%IAG\u0001\fY&\u001cH/\u001a8fe\n+8o\u0001\u0001\u0016\u0003m\u0001\"\u0001H\u000f\u000e\u0003\tI!A\b\u0002\u0003\u001f1Kg/\u001a'jgR,g.\u001a:CkND\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IaG\u0001\rY&\u001cH/\u001a8fe\n+8\u000f\t\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005!1m\u001c8g!\t!S%D\u0001\u0005\u0013\t1CAA\u0005Ta\u0006\u00148nQ8oM\"A\u0001\u0006\u0001B\u0001B\u0003%\u0011&\u0001\tbY2|7-\u0019;j_:\u001cE.[3oiB\u0019AB\u000b\u0017\n\u0005-j!AB(qi&|g\u000e\u0005\u0002%[%\u0011a\u0006\u0002\u0002\u0019\u000bb,7-\u001e;pe\u0006cGn\\2bi&|gn\u00117jK:$\b\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u000b\rdwnY6\u0011\u0005I*T\"A\u001a\u000b\u0005Q\"\u0011\u0001B;uS2L!AN\u001a\u0003\u000b\rcwnY6\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\u0015Q4\bP\u001f?!\ta\u0002\u0001C\u0003\u0019o\u0001\u00071\u0004C\u0003#o\u0001\u00071\u0005C\u0003)o\u0001\u0007\u0011\u0006C\u00041oA\u0005\t\u0019A\u0019\t\u000ba\u0002A\u0011\u0001!\u0015\u0007i\ne\tC\u0003C\u007f\u0001\u00071)\u0001\u0002tGB\u0011A\u0005R\u0005\u0003\u000b\u0012\u0011Ab\u00159be.\u001cuN\u001c;fqRDQ\u0001K A\u0002%Bq\u0001\u0013\u0001C\u0002\u0013%\u0011*A\u000bN\u0003b{f)Q%M+J+5k\u0018)F%~+\u0005,R\"\u0016\u0003)\u0003\"\u0001D&\n\u00051k!aA%oi\"1a\n\u0001Q\u0001\n)\u000ba#T!Y?\u001a\u000b\u0015\nT+S\u000bN{\u0006+\u0012*`\u000bb+5\t\t\u0005\b!\u0002\u0011\r\u0011\"\u0003J\u0003ai\u0015\tW0G\u0003&cU\tR0F1\u0016\u001bu\fU#S?:{E)\u0012\u0005\u0007%\u0002\u0001\u000b\u0011\u0002&\u000235\u000b\u0005l\u0018$B\u00132+EiX#Y\u000b\u000e{\u0006+\u0012*`\u001d>#U\t\t\u0005\b)\u0002\u0011\r\u0011\"\u0001V\u0003a\u0011E*Q\"L\u0019&\u001bFk\u0018+J\u001b\u0016{U\u000bV0N\u00132c\u0015jU\u000b\u0002-B\u0011AbV\u0005\u000316\u0011A\u0001T8oO\"1!\f\u0001Q\u0001\nY\u000b\u0011D\u0011'B\u0007.c\u0015j\u0015+`)&kUiT+U?6KE\nT%TA!9A\f\u0001b\u0001\n\u0013i\u0016a\b\"M\u0003\u000e[E*S*U?\u001a+Ek\u0011%`\r\u0006KE*\u0016*F?\u0016s\u0015I\u0011'F\tV\ta\f\u0005\u0002\r?&\u0011\u0001-\u0004\u0002\b\u0005>|G.Z1o\u0011\u0019\u0011\u0007\u0001)A\u0005=\u0006\u0001#\tT!D\u00172K5\u000bV0G\u000bR\u001b\u0005j\u0018$B\u00132+&+R0F\u001d\u0006\u0013E*\u0012#!\u0011\u001d!\u0007A1A\u0005\n\u0015\fq#\u001a=fGV$xN]%e)>4\u0015-\u001b7ve\u0016d\u0015n\u001d;\u0016\u0003\u0019\u0004Ba\u001a7os6\t\u0001N\u0003\u0002jU\u00069Q.\u001e;bE2,'BA6\u000e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003[\"\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002pm:\u0011\u0001\u000f\u001e\t\u0003c6i\u0011A\u001d\u0006\u0003gf\ta\u0001\u0010:p_Rt\u0014BA;\u000e\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000f\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ul\u0001C\u0001>|\u001b\u0005\u0001a!\u0002?\u0001\u0005\ti(aE#yK\u000e,Ho\u001c:GC&dWO]3MSN$8cA>\f#!)\u0001h\u001fC\u0001\u007fR\t\u0011P\u0002\u0004\u0002\u0004m$\u0015Q\u0001\u0002\u0007)\u0006\u001c8.\u00133\u0014\u000f\u0005\u00051\"a\u0002\u0002\u000eA\u0019A\"!\u0003\n\u0007\u0005-QBA\u0004Qe>$Wo\u0019;\u0011\u00071\ty!C\u0002\u0002\u00125\u0011AbU3sS\u0006d\u0017N_1cY\u0016D!\"!\u0006\u0002\u0002\tU\r\u0011\"\u0001J\u0003\u0015\u0019H/Y4f\u0011)\tI\"!\u0001\u0003\u0012\u0003\u0006IAS\u0001\u0007gR\fw-\u001a\u0011\t\u0015\u0005u\u0011\u0011\u0001BK\u0002\u0013\u0005\u0011*\u0001\u0007ti\u0006<W-\u0011;uK6\u0004H\u000f\u0003\u0006\u0002\"\u0005\u0005!\u0011#Q\u0001\n)\u000bQb\u001d;bO\u0016\fE\u000f^3naR\u0004\u0003BCA\u0013\u0003\u0003\u0011)\u001a!C\u0001\u0013\u0006IA/Y:l\u0013:$W\r\u001f\u0005\u000b\u0003S\t\tA!E!\u0002\u0013Q\u0015A\u0003;bg.Le\u000eZ3yA!9\u0001(!\u0001\u0005\u0002\u00055B\u0003CA\u0018\u0003g\t)$a\u000e\u0011\t\u0005E\u0012\u0011A\u0007\u0002w\"9\u0011QCA\u0016\u0001\u0004Q\u0005bBA\u000f\u0003W\u0001\rA\u0013\u0005\b\u0003K\tY\u00031\u0001K\u0011)\tY$!\u0001\u0002\u0002\u0013\u0005\u0011QH\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u00020\u0005}\u0012\u0011IA\"\u0011%\t)\"!\u000f\u0011\u0002\u0003\u0007!\nC\u0005\u0002\u001e\u0005e\u0002\u0013!a\u0001\u0015\"I\u0011QEA\u001d!\u0003\u0005\rA\u0013\u0005\u000b\u0003\u000f\n\t!%A\u0005\u0002\u0005%\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0017R3ASA'W\t\ty\u0005\u0005\u0003\u0002R\u0005mSBAA*\u0015\u0011\t)&a\u0016\u0002\u0013Ut7\r[3dW\u0016$'bAA-\u001b\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00131\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCA1\u0003\u0003\t\n\u0011\"\u0001\u0002J\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004BCA3\u0003\u0003\t\n\u0011\"\u0001\u0002J\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004BCA5\u0003\u0003\t\t\u0011\"\u0011\u0002l\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u001c\u0011\t\u0005=\u0014\u0011P\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005!A.\u00198h\u0015\t\t9(\u0001\u0003kCZ\f\u0017bA<\u0002r!I\u0011QPA\u0001\u0003\u0003%\t!S\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0003\u0003\u000b\t!!A\u0005\u0002\u0005\r\u0015A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000b\u000bY\tE\u0002\r\u0003\u000fK1!!#\u000e\u0005\r\te.\u001f\u0005\n\u0003\u001b\u000by(!AA\u0002)\u000b1\u0001\u001f\u00132\u0011)\t\t*!\u0001\u0002\u0002\u0013\u0005\u00131S\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0013\t\u0007\u0003/\u000bI*!\"\u000e\u0003)L1!a'k\u0005!IE/\u001a:bi>\u0014\bBCAP\u0003\u0003\t\t\u0011\"\u0001\u0002\"\u0006A1-\u00198FcV\fG\u000eF\u0002_\u0003GC!\"!$\u0002\u001e\u0006\u0005\t\u0019AAC\u0011)\t9+!\u0001\u0002\u0002\u0013\u0005\u0013\u0011V\u0001\tQ\u0006\u001c\bnQ8eKR\t!\n\u0003\u0006\u0002.\u0006\u0005\u0011\u0011!C!\u0003_\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003[B!\"a-\u0002\u0002\u0005\u0005I\u0011IA[\u0003\u0019)\u0017/^1mgR\u0019a,a.\t\u0015\u00055\u0015\u0011WA\u0001\u0002\u0004\t)iB\u0005\u0002<n\f\t\u0011#\u0003\u0002>\u00061A+Y:l\u0013\u0012\u0004B!!\r\u0002@\u001aI\u00111A>\u0002\u0002#%\u0011\u0011Y\n\u0007\u0003\u007f\u000b\u0019-!\u0004\u0011\u0013\u0005\u0015\u00171\u001a&K\u0015\u0006=RBAAd\u0015\r\tI-D\u0001\beVtG/[7f\u0013\u0011\ti-a2\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u00049\u0003\u007f#\t!!5\u0015\u0005\u0005u\u0006BCAW\u0003\u007f\u000b\t\u0011\"\u0012\u00020\"Q\u0011q[A`\u0003\u0003%\t)!7\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005=\u00121\\Ao\u0003?Dq!!\u0006\u0002V\u0002\u0007!\nC\u0004\u0002\u001e\u0005U\u0007\u0019\u0001&\t\u000f\u0005\u0015\u0012Q\u001ba\u0001\u0015\"Q\u00111]A`\u0003\u0003%\t)!:\u0002\u000fUt\u0017\r\u001d9msR!\u0011q]Ax!\u0011a!&!;\u0011\r1\tYO\u0013&K\u0013\r\ti/\u0004\u0002\u0007)V\u0004H.Z\u001a\t\u0015\u0005E\u0018\u0011]A\u0001\u0002\u0004\ty#A\u0002yIAB\u0011\"!>|\u0001\u0004%I!a>\u0002-\u0019\f\u0017\u000e\\;sKN\fe\u000eZ#ya&\u0014\u0018\u0010V5nKN,\"!!?\u0011\u000b\u001d\fY0a@\n\u0007\u0005u\bNA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bC\u0002\u0007\u0003\u0002\u0005=b+C\u0002\u0003\u00045\u0011a\u0001V;qY\u0016\u0014\u0004\"\u0003B\u0004w\u0002\u0007I\u0011\u0002B\u0005\u0003i1\u0017-\u001b7ve\u0016\u001c\u0018I\u001c3FqBL'/\u001f+j[\u0016\u001cx\fJ3r)\u0011\u0011YA!\u0005\u0011\u00071\u0011i!C\u0002\u0003\u00105\u0011A!\u00168ji\"Q\u0011Q\u0012B\u0003\u0003\u0003\u0005\r!!?\t\u0011\tU1\u0010)Q\u0005\u0003s\fqCZ1jYV\u0014Xm]!oI\u0016C\b/\u001b:z)&lWm\u001d\u0011\t\u0011\te1\u00101A\u0005\nU\u000bQ\"\\5o\u000bb\u0004\u0018N]=US6,\u0007\"\u0003B\u000fw\u0002\u0007I\u0011\u0002B\u0010\u0003Ei\u0017N\\#ya&\u0014\u0018\u0010V5nK~#S-\u001d\u000b\u0005\u0005\u0017\u0011\t\u0003C\u0005\u0002\u000e\nm\u0011\u0011!a\u0001-\"9!QE>!B\u00131\u0016AD7j]\u0016C\b/\u001b:z)&lW\r\t\u0005\b\u0005SYH\u0011\u0001B\u0016\u0003-\tG\r\u001a$bS2,(/Z:\u0015\u0011\t-!Q\u0006B\u0018\u0005cAq!!\u0006\u0003(\u0001\u0007!\nC\u0004\u0002\u001e\t\u001d\u0002\u0019\u0001&\t\u0011\tM\"q\u0005a\u0001\u0005k\t\u0011CZ1jYV\u0014Xm]%o)\u0006\u001c8nU3u!\ra\"qG\u0005\u0004\u0005s\u0011!!G#yK\u000e,Ho\u001c:GC&dWO]3t\u0013:$\u0016m]6TKRDaA!\u0010|\t\u0003I\u0015!\u00068v[Vs\u0017.];f)\u0006\u001c8NR1jYV\u0014Xm\u001d\u0005\u0007\u0005\u0003ZH\u0011A/\u0002\u000f%\u001cX)\u001c9us\"9!QI>\u0005\u0002\t\u001d\u0013!\b3s_B4\u0015-\u001b7ve\u0016\u001cx+\u001b;i)&lWm\\;u\u0005\u00164wN]3\u0015\t\t-!\u0011\n\u0005\b\u0005\u0017\u0012\u0019\u00051\u0001W\u0003)!'o\u001c9CK\u001a|'/\u001a\u0005\b\u0003[[H\u0011\tB()\u0005q\u0007b\u0002B*\u0001\u0001\u0006IAZ\u0001\u0019Kb,7-\u001e;pe&#Gk\u001c$bS2,(/\u001a'jgR\u0004\u0003\"\u0003B,\u0001\t\u0007I\u0011\u0001B-\u0003m)\u00070Z2vi>\u0014\u0018\n\u001a+p\u00052\f7m\u001b7jgR\u001cF/\u0019;vgV\u0011!1\f\t\u0006O2t'Q\f\t\u00049\t}\u0013b\u0001B1\u0005\t\u0019\"\t\\1dW2L7\u000f^3e\u000bb,7-\u001e;pe\"A!Q\r\u0001!\u0002\u0013\u0011Y&\u0001\u000ffq\u0016\u001cW\u000f^8s\u0013\u0012$vN\u00117bG.d\u0017n\u001d;Ti\u0006$Xo\u001d\u0011\t\u0013\t%\u0004A1A\u0005\u0002\t-\u0014a\u00078pI\u0016LE\rV8CY\u0006\u001c7\u000e\\5ti\u0016C\b/\u001b:z)&lW-\u0006\u0002\u0003nA!q\r\u001c8W\u0011!\u0011\t\b\u0001Q\u0001\n\t5\u0014\u0001\b8pI\u0016LE\rV8CY\u0006\u001c7\u000e\\5ti\u0016C\b/\u001b:z)&lW\r\t\u0005\n\u0005k\u0002!\u0019!C\u0005\u0005o\nab\u00188pI\u0016\u0014E.Y2lY&\u001cH/\u0006\u0002\u0003zA1!1\u0010BD\u0005\u0017k!A! \u000b\t\t}$\u0011Q\u0001\u0007CR|W.[2\u000b\t\t\r%QQ\u0001\u000bG>t7-\u001e:sK:$(b\u0001\u001b\u0002v%!!\u0011\u0012B?\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007\u0003B8\u0003\u000e:L1Aa$y\u0005\r\u0019V\r\u001e\u0005\t\u0005'\u0003\u0001\u0015!\u0003\u0003z\u0005yqL\\8eK\nc\u0017mY6mSN$\b\u0005\u0003\u0005\u0003\u0018\u0002\u0001\r\u0011\"\u0001V\u00039qW\r\u001f;FqBL'/\u001f+j[\u0016D\u0011Ba'\u0001\u0001\u0004%\tA!(\u0002%9,\u0007\u0010^#ya&\u0014\u0018\u0010V5nK~#S-\u001d\u000b\u0005\u0005\u0017\u0011y\nC\u0005\u0002\u000e\ne\u0015\u0011!a\u0001-\"9!1\u0015\u0001!B\u00131\u0016a\u00048fqR,\u0005\u0010]5ssRKW.\u001a\u0011\t\u0013\t\u001d\u0006A1A\u0005\u0002\t%\u0016A\u00068pI\u0016$vN\u00117bG.d\u0017n\u001d;fI\u0016CXmY:\u0016\u0005\t-\u0006#B4m]\n5\u0006\u0003B4\u00030:L1A!-i\u0005\u001dA\u0015m\u001d5TKRD\u0001B!.\u0001A\u0003%!1V\u0001\u0018]>$W\rV8CY\u0006\u001c7\u000e\\5ti\u0016$W\t_3dg\u0002BqA!/\u0001\t\u0003\u0011Y,A\u000bbaBd\u0017P\u00117bG.d\u0017n\u001d;US6,w.\u001e;\u0015\u0005\t-\u0001b\u0002B`\u0001\u0011%!1X\u0001\u0015kB$\u0017\r^3OKb$X\t\u001f9jef$\u0016.\\3\t\u000f\t\r\u0007\u0001\"\u0003\u0003F\u000692.\u001b7m\u00052\f7m\u001b7jgR,G-\u0012=fGV$xN\u001d\u000b\u0005\u0005\u0017\u00119\rC\u0004\u0003J\n\u0005\u0007\u0019\u00018\u0002\t\u0015DXm\u0019\u0005\b\u0005\u001b\u0004A\u0011\u0002Bh\u0003yY\u0017\u000e\u001c7Fq\u0016\u001cW\u000f^8sg>s'\t\\1dW2L7\u000f^3e\u001d>$W\r\u0006\u0003\u0003\f\tE\u0007b\u0002Bj\u0005\u0017\u0004\rA\\\u0001\u0005]>$W\rC\u0004\u0003X\u0002!\tA!7\u0002=U\u0004H-\u0019;f\u00052\f7m\u001b7jgR4uN\u001d$fi\u000eDg)Y5mkJ,GC\u0002B\u0006\u00057\u0014y\u000eC\u0004\u0003^\nU\u0007\u0019\u00018\u0002\t!|7\u000f\u001e\u0005\b\u0005\u0013\u0014)\u000e1\u0001o\u0011\u001d\u0011\u0019\u000f\u0001C\u0001\u0005K\f1%\u001e9eCR,'\t\\1dW2L7\u000f\u001e$peN+8mY3tg\u001a,H\u000eV1tWN+G\u000f\u0006\u0005\u0003\f\t\u001d(1\u001eBx\u0011\u001d\u0011IO!9A\u0002)\u000bqa\u001d;bO\u0016LE\rC\u0004\u0003n\n\u0005\b\u0019\u0001&\u0002\u001dM$\u0018mZ3BiR,W\u000e\u001d;JI\"A!\u0011\u001fBq\u0001\u0004\u0011\u00190\u0001\bgC&dWO]3t\u0005f,\u00050Z2\u0011\u000b\u001ddgN!\u000e\t\u000f\t]\b\u0001\"\u0001\u0003z\u0006)\u0012n]#yK\u000e,Ho\u001c:CY\u0006\u001c7\u000e\\5ti\u0016$Gc\u00010\u0003|\"9!Q B{\u0001\u0004q\u0017AC3yK\u000e,Ho\u001c:JI\"91\u0011\u0001\u0001\u0005\u0002\r\r\u0011!\u00048pI\u0016\u0014E.Y2lY&\u001cH\u000f\u0006\u0002\u0003\f\"91q\u0001\u0001\u0005\u0002\r%\u0011!E5t\u001d>$WM\u00117bG.d\u0017n\u001d;fIR\u0019ala\u0003\t\u000f\tM7Q\u0001a\u0001]\"91q\u0002\u0001\u0005\u0002\rE\u0011!\u00065b]\u0012dWMU3n_Z,G-\u0012=fGV$xN\u001d\u000b\u0005\u0005\u0017\u0019\u0019\u0002C\u0004\u0003~\u000e5\u0001\u0019\u00018\b\u0011\r]!\u0001#\u0001\u0005\u00073\t\u0001C\u00117bG.d\u0017n\u001d;Ue\u0006\u001c7.\u001a:\u0011\u0007q\u0019YBB\u0004\u0002\u0005!\u0005Aa!\b\u0014\t\rm1\"\u0005\u0005\bq\rmA\u0011AB\u0011)\t\u0019I\u0002\u0003\u0006\u0004&\rm!\u0019!C\u0005\u0003W\nq\u0002R#G\u0003VcEk\u0018+J\u001b\u0016{U\u000b\u0016\u0005\n\u0007S\u0019Y\u0002)A\u0005\u0003[\n\u0001\u0003R#G\u0003VcEk\u0018+J\u001b\u0016{U\u000b\u0016\u0011\t\u0011\r521\u0004C\u0001\u0007_\t!#[:CY\u0006\u001c7\u000e\\5ti\u0016s\u0017M\u00197fIR\u0019al!\r\t\r\t\u001aY\u00031\u0001$\u0011!\u0019)da\u0007\u0005\u0002\r]\u0012aE4fi\nc\u0017mY6mSN$H+[7f_V$Hc\u0001,\u0004:!1!ea\rA\u0002\rB\u0001b!\u0010\u0004\u001c\u0011\u00051qH\u0001\u0017m\u0006d\u0017\u000eZ1uK\nc\u0017mY6mSN$8i\u001c8ggR!!1BB!\u0011\u0019\u001131\ba\u0001G!Q1QIB\u000e#\u0003%\taa\u0012\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019IEK\u00022\u0003\u001b\u0002")
public class BlacklistTracker
implements Logging {
    private final LiveListenerBus listenerBus;
    private final SparkConf conf;
    private final Option<ExecutorAllocationClient> allocationClient;
    private final Clock clock;
    private final int MAX_FAILURES_PER_EXEC;
    private final int MAX_FAILED_EXEC_PER_NODE;
    private final long BLACKLIST_TIMEOUT_MILLIS;
    private final boolean BLACKLIST_FETCH_FAILURE_ENABLED;
    private final HashMap<String, ExecutorFailureList> executorIdToFailureList;
    private final HashMap<String, BlacklistedExecutor> executorIdToBlacklistStatus;
    private final HashMap<String, Object> nodeIdToBlacklistExpiryTime;
    private final AtomicReference<Set<String>> _nodeBlacklist;
    private long nextExpiryTime;
    private final HashMap<String, HashSet<String>> nodeToBlacklistedExecs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$4() {
        return BlacklistTracker$.MODULE$.$lessinit$greater$default$4();
    }

    public static void validateBlacklistConfs(SparkConf sparkConf) {
        BlacklistTracker$.MODULE$.validateBlacklistConfs(sparkConf);
    }

    public static long getBlacklistTimeout(SparkConf sparkConf) {
        return BlacklistTracker$.MODULE$.getBlacklistTimeout(sparkConf);
    }

    public static boolean isBlacklistEnabled(SparkConf sparkConf) {
        return BlacklistTracker$.MODULE$.isBlacklistEnabled(sparkConf);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    private int MAX_FAILURES_PER_EXEC() {
        return this.MAX_FAILURES_PER_EXEC;
    }

    private int MAX_FAILED_EXEC_PER_NODE() {
        return this.MAX_FAILED_EXEC_PER_NODE;
    }

    public long BLACKLIST_TIMEOUT_MILLIS() {
        return this.BLACKLIST_TIMEOUT_MILLIS;
    }

    private boolean BLACKLIST_FETCH_FAILURE_ENABLED() {
        return this.BLACKLIST_FETCH_FAILURE_ENABLED;
    }

    private HashMap<String, ExecutorFailureList> executorIdToFailureList() {
        return this.executorIdToFailureList;
    }

    public HashMap<String, BlacklistedExecutor> executorIdToBlacklistStatus() {
        return this.executorIdToBlacklistStatus;
    }

    public HashMap<String, Object> nodeIdToBlacklistExpiryTime() {
        return this.nodeIdToBlacklistExpiryTime;
    }

    private AtomicReference<Set<String>> _nodeBlacklist() {
        return this._nodeBlacklist;
    }

    public long nextExpiryTime() {
        return this.nextExpiryTime;
    }

    public void nextExpiryTime_$eq(long x$1) {
        this.nextExpiryTime = x$1;
    }

    public HashMap<String, HashSet<String>> nodeToBlacklistedExecs() {
        return this.nodeToBlacklistedExecs;
    }

    public void applyBlacklistTimeout() {
        block2: {
            Iterable nodesToUnblacklist;
            long now = this.clock.getTimeMillis();
            if (now <= this.nextExpiryTime()) break block2;
            Iterable execsToUnblacklist = ((MapLike)this.executorIdToBlacklistStatus().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BlacklistTracker.$anonfun$applyBlacklistTimeout$1(now, x$1)))).keys();
            if (execsToUnblacklist.nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Removing executors ").append(execsToUnblacklist).append(" from blacklist because the blacklist ").append("for those executors has timed out").toString());
                execsToUnblacklist.foreach((Function1 & Serializable & scala.Serializable)exec -> {
                    BlacklistedExecutor status = (BlacklistedExecutor)this.executorIdToBlacklistStatus().remove(exec).get();
                    HashSet failedExecsOnNode = (HashSet)this.nodeToBlacklistedExecs().apply((Object)status.node());
                    this.listenerBus().post(new SparkListenerExecutorUnblacklisted(now, (String)exec));
                    failedExecsOnNode.remove(exec);
                    return failedExecsOnNode.isEmpty() ? this.nodeToBlacklistedExecs().remove((Object)status.node()) : BoxedUnit.UNIT;
                });
            }
            if ((nodesToUnblacklist = ((MapLike)this.nodeIdToBlacklistExpiryTime().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BlacklistTracker.$anonfun$applyBlacklistTimeout$4(now, x$2)))).keys()).nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Removing nodes ").append(nodesToUnblacklist).append(" from blacklist because the blacklist ").append("has timed out").toString());
                nodesToUnblacklist.foreach((Function1 & Serializable & scala.Serializable)node -> {
                    BlacklistTracker.$anonfun$applyBlacklistTimeout$6(this, now, node);
                    return BoxedUnit.UNIT;
                });
                this._nodeBlacklist().set((Set<String>)this.nodeIdToBlacklistExpiryTime().keySet().toSet());
            }
            this.updateNextExpiryTime();
        }
    }

    private void updateNextExpiryTime() {
        long execMinExpiry = this.executorIdToBlacklistStatus().nonEmpty() ? BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.executorIdToBlacklistStatus().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)BlacklistTracker.$anonfun$updateNextExpiryTime$1(x$3)), Iterable$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        long nodeMinExpiry = this.nodeIdToBlacklistExpiryTime().nonEmpty() ? BoxesRunTime.unboxToLong((Object)this.nodeIdToBlacklistExpiryTime().values().min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        this.nextExpiryTime_$eq(package$.MODULE$.min(execMinExpiry, nodeMinExpiry));
    }

    private void killBlacklistedExecutor(String exec) {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.BLACKLIST_KILL_ENABLED()))) {
            Option<ExecutorAllocationClient> option = this.allocationClient;
            if (option instanceof Some) {
                Some some = (Some)option;
                ExecutorAllocationClient a = (ExecutorAllocationClient)some.value();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Killing blacklisted executor id ").append(exec).append(" ").append(new StringBuilder(14).append("since ").append(org.apache.spark.internal.config.package$.MODULE$.BLACKLIST_KILL_ENABLED().key()).append(" is set.").toString()).toString());
                a.killExecutors((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{exec}))), false, false, true);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Not attempting to kill blacklisted executor id ").append(exec).append(" ").append("since allocation client is not defined.").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
    }

    private void killExecutorsOnBlacklistedNode(String node) {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.BLACKLIST_KILL_ENABLED()))) {
            Option<ExecutorAllocationClient> option = this.allocationClient;
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                ExecutorAllocationClient a = (ExecutorAllocationClient)some.value();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Killing all executors on blacklisted host ").append(node).append(" ").append(new StringBuilder(14).append("since ").append(org.apache.spark.internal.config.package$.MODULE$.BLACKLIST_KILL_ENABLED().key()).append(" is set.").toString()).toString());
                if (!a.killExecutorsOnHost(node)) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Killing executors on node ").append(node).append(" failed.").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Not attempting to kill executors on blacklisted host ").append(node).append(" ").append("since allocation client is not defined.").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        }
    }

    public void updateBlacklistForFetchFailure(String host, String exec) {
        block0: {
            long expiryTimeForNewBlacklists;
            long now;
            block1: {
                if (!this.BLACKLIST_FETCH_FAILURE_ENABLED()) break block0;
                now = this.clock.getTimeMillis();
                expiryTimeForNewBlacklists = now + this.BLACKLIST_TIMEOUT_MILLIS();
                if (!BoxesRunTime.unboxToBoolean((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SERVICE_ENABLED()))) break block1;
                if (this.nodeIdToBlacklistExpiryTime().contains((Object)host)) break block0;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("blacklisting node ").append(host).append(" due to fetch failure of external shuffle service").toString());
                this.nodeIdToBlacklistExpiryTime().put((Object)host, (Object)BoxesRunTime.boxToLong((long)expiryTimeForNewBlacklists));
                this.listenerBus().post(new SparkListenerNodeBlacklisted(now, host, 1));
                this._nodeBlacklist().set((Set<String>)this.nodeIdToBlacklistExpiryTime().keySet().toSet());
                this.killExecutorsOnBlacklistedNode(host);
                this.updateNextExpiryTime();
                break block0;
            }
            if (this.executorIdToBlacklistStatus().contains((Object)exec)) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Blacklisting executor ").append(exec).append(" due to fetch failure").toString());
            this.executorIdToBlacklistStatus().put((Object)exec, (Object)new BlacklistedExecutor(host, expiryTimeForNewBlacklists));
            this.listenerBus().post(new SparkListenerExecutorBlacklisted(now, exec, 1));
            this.updateNextExpiryTime();
            this.killBlacklistedExecutor(exec);
            HashSet blacklistedExecsOnNode = (HashSet)this.nodeToBlacklistedExecs().getOrElseUpdate((Object)host, (Function0 & Serializable & scala.Serializable)() -> (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
            blacklistedExecsOnNode.$plus$eq((Object)exec);
        }
    }

    public void updateBlacklistForSuccessfulTaskSet(int stageId, int stageAttemptId, HashMap<String, ExecutorFailuresInTaskSet> failuresByExec) {
        long now = this.clock.getTimeMillis();
        failuresByExec.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BlacklistTracker.$anonfun$updateBlacklistForSuccessfulTaskSet$1(this, stageId, stageAttemptId, now, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public boolean isExecutorBlacklisted(String executorId) {
        return this.executorIdToBlacklistStatus().contains((Object)executorId);
    }

    public Set<String> nodeBlacklist() {
        return this._nodeBlacklist().get();
    }

    public boolean isNodeBlacklisted(String node) {
        return this.nodeIdToBlacklistExpiryTime().contains((Object)node);
    }

    public void handleRemovedExecutor(String executorId) {
        this.executorIdToFailureList().$minus$eq((Object)executorId);
    }

    public static final /* synthetic */ boolean $anonfun$applyBlacklistTimeout$1(long now$1, Tuple2 x$1) {
        return ((BlacklistedExecutor)x$1._2()).expiryTime() < now$1;
    }

    public static final /* synthetic */ boolean $anonfun$applyBlacklistTimeout$4(long now$1, Tuple2 x$2) {
        return x$2._2$mcJ$sp() < now$1;
    }

    public static final /* synthetic */ void $anonfun$applyBlacklistTimeout$6(BlacklistTracker $this, long now$1, String node) {
        $this.nodeIdToBlacklistExpiryTime().remove((Object)node);
        $this.listenerBus().post(new SparkListenerNodeUnblacklisted(now$1, node));
    }

    public static final /* synthetic */ long $anonfun$updateNextExpiryTime$1(Tuple2 x$3) {
        return ((BlacklistedExecutor)x$3._2()).expiryTime();
    }

    public static final /* synthetic */ void $anonfun$updateBlacklistForSuccessfulTaskSet$1(BlacklistTracker $this, int stageId$1, int stageAttemptId$1, long now$2, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String exec = (String)tuple2._1();
            ExecutorFailuresInTaskSet failuresInTaskSet = (ExecutorFailuresInTaskSet)tuple2._2();
            ExecutorFailureList appFailuresOnExecutor = (ExecutorFailureList)$this.executorIdToFailureList().getOrElseUpdate((Object)exec, (Function0 & Serializable & scala.Serializable)() -> $this.new ExecutorFailureList());
            appFailuresOnExecutor.addFailures(stageId$1, stageAttemptId$1, failuresInTaskSet);
            appFailuresOnExecutor.dropFailuresWithTimeoutBefore(now$2);
            int newTotal = appFailuresOnExecutor.numUniqueTaskFailures();
            long expiryTimeForNewBlacklists = now$2 + $this.BLACKLIST_TIMEOUT_MILLIS();
            if (newTotal >= $this.MAX_FAILURES_PER_EXEC() && !$this.executorIdToBlacklistStatus().contains((Object)exec)) {
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Blacklisting executor id: ").append(exec).append(" because it has ").append(newTotal).append(" task failures in successful task sets").toString());
                String node = failuresInTaskSet.node();
                $this.executorIdToBlacklistStatus().put((Object)exec, (Object)new BlacklistedExecutor(node, expiryTimeForNewBlacklists));
                $this.listenerBus().post(new SparkListenerExecutorBlacklisted(now$2, exec, newTotal));
                $this.executorIdToFailureList().remove((Object)exec);
                $this.updateNextExpiryTime();
                $this.killBlacklistedExecutor(exec);
                HashSet blacklistedExecsOnNode = (HashSet)$this.nodeToBlacklistedExecs().getOrElseUpdate((Object)node, (Function0 & Serializable & scala.Serializable)() -> (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                blacklistedExecsOnNode.$plus$eq((Object)exec);
                if (blacklistedExecsOnNode.size() >= $this.MAX_FAILED_EXEC_PER_NODE() && !$this.nodeIdToBlacklistExpiryTime().contains((Object)node)) {
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Blacklisting node ").append(node).append(" because it has ").append(blacklistedExecsOnNode.size()).append(" ").append(new StringBuilder(23).append("executors blacklisted: ").append(blacklistedExecsOnNode).toString()).toString());
                    $this.nodeIdToBlacklistExpiryTime().put((Object)node, (Object)BoxesRunTime.boxToLong((long)expiryTimeForNewBlacklists));
                    $this.listenerBus().post(new SparkListenerNodeBlacklisted(now$2, node, blacklistedExecsOnNode.size()));
                    $this._nodeBlacklist().set((Set<String>)$this.nodeIdToBlacklistExpiryTime().keySet().toSet());
                    $this.killExecutorsOnBlacklistedNode(node);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public BlacklistTracker(LiveListenerBus listenerBus, SparkConf conf, Option<ExecutorAllocationClient> allocationClient, Clock clock) {
        this.listenerBus = listenerBus;
        this.conf = conf;
        this.allocationClient = allocationClient;
        this.clock = clock;
        Logging.$init$(this);
        BlacklistTracker$.MODULE$.validateBlacklistConfs(conf);
        this.MAX_FAILURES_PER_EXEC = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILURES_PER_EXEC()));
        this.MAX_FAILED_EXEC_PER_NODE = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_FAILED_EXEC_PER_NODE()));
        this.BLACKLIST_TIMEOUT_MILLIS = BlacklistTracker$.MODULE$.getBlacklistTimeout(conf);
        this.BLACKLIST_FETCH_FAILURE_ENABLED = BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.BLACKLIST_FETCH_FAILURE_ENABLED()));
        this.executorIdToFailureList = new HashMap();
        this.executorIdToBlacklistStatus = new HashMap();
        this.nodeIdToBlacklistExpiryTime = new HashMap();
        this._nodeBlacklist = new AtomicReference<GenTraversable>(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
        this.nextExpiryTime = Long.MAX_VALUE;
        this.nodeToBlacklistedExecs = new HashMap();
    }

    public BlacklistTracker(SparkContext sc, Option<ExecutorAllocationClient> allocationClient) {
        this(sc.listenerBus(), sc.conf(), allocationClient, BlacklistTracker$.MODULE$.$lessinit$greater$default$4());
    }

    public final class ExecutorFailureList
    implements Logging {
        private volatile BlacklistTracker$ExecutorFailureList$TaskId$ TaskId$module;
        private ArrayBuffer<Tuple2<TaskId, Object>> failuresAndExpiryTimes;
        private long minExpiryTime;
        private transient Logger org$apache$spark$internal$Logging$$log_;

        @Override
        public String logName() {
            return Logging.logName$(this);
        }

        @Override
        public Logger log() {
            return Logging.log$(this);
        }

        @Override
        public void logInfo(Function0<String> msg) {
            Logging.logInfo$(this, msg);
        }

        @Override
        public void logDebug(Function0<String> msg) {
            Logging.logDebug$(this, msg);
        }

        @Override
        public void logTrace(Function0<String> msg) {
            Logging.logTrace$(this, msg);
        }

        @Override
        public void logWarning(Function0<String> msg) {
            Logging.logWarning$(this, msg);
        }

        @Override
        public void logError(Function0<String> msg) {
            Logging.logError$(this, msg);
        }

        @Override
        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$(this, msg, throwable);
        }

        @Override
        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$(this, msg, throwable);
        }

        @Override
        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$(this, msg, throwable);
        }

        @Override
        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$(this, msg, throwable);
        }

        @Override
        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$(this, msg, throwable);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$(this, isInterpreter);
        }

        @Override
        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
        }

        @Override
        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$(this);
        }

        private BlacklistTracker$ExecutorFailureList$TaskId$ TaskId() {
            if (this.TaskId$module == null) {
                this.TaskId$lzycompute$1();
            }
            return this.TaskId$module;
        }

        @Override
        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        @Override
        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        private ArrayBuffer<Tuple2<TaskId, Object>> failuresAndExpiryTimes() {
            return this.failuresAndExpiryTimes;
        }

        private void failuresAndExpiryTimes_$eq(ArrayBuffer<Tuple2<TaskId, Object>> x$1) {
            this.failuresAndExpiryTimes = x$1;
        }

        private long minExpiryTime() {
            return this.minExpiryTime;
        }

        private void minExpiryTime_$eq(long x$1) {
            this.minExpiryTime = x$1;
        }

        public void addFailures(int stage, int stageAttempt, ExecutorFailuresInTaskSet failuresInTaskSet) {
            failuresInTaskSet.taskToFailureCountAndFailureTime().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ExecutorFailureList.$anonfun$addFailures$1(this, stage, stageAttempt, x0$2);
                return BoxedUnit.UNIT;
            });
        }

        public int numUniqueTaskFailures() {
            return this.failuresAndExpiryTimes().size();
        }

        public boolean isEmpty() {
            return this.failuresAndExpiryTimes().isEmpty();
        }

        public void dropFailuresWithTimeoutBefore(long dropBefore) {
            block0: {
                if (this.minExpiryTime() >= dropBefore) break block0;
                LongRef newMinExpiry = LongRef.create((long)Long.MAX_VALUE);
                ArrayBuffer newFailures = new ArrayBuffer();
                this.failuresAndExpiryTimes().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    ExecutorFailureList.$anonfun$dropFailuresWithTimeoutBefore$1(dropBefore, newMinExpiry, newFailures, x0$3);
                    return BoxedUnit.UNIT;
                });
                this.failuresAndExpiryTimes_$eq((ArrayBuffer<Tuple2<TaskId, Object>>)newFailures);
                this.minExpiryTime_$eq(newMinExpiry.elem);
            }
        }

        public String toString() {
            return new StringBuilder(11).append("failures = ").append(this.failuresAndExpiryTimes()).toString();
        }

        private final void TaskId$lzycompute$1() {
            ExecutorFailureList executorFailureList = this;
            synchronized (executorFailureList) {
                if (this.TaskId$module == null) {
                    this.TaskId$module = new BlacklistTracker$ExecutorFailureList$TaskId$(this);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final /* synthetic */ void $anonfun$addFailures$1(ExecutorFailureList $this, int stage$1, int stageAttempt$1, Tuple2 x0$2) {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int taskIdx = tuple2._1$mcI$sp();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (tuple22 == null) throw new MatchError((Object)tuple2);
            long failureTime = tuple22._2$mcJ$sp();
            long expiryTime = failureTime + $this.BlacklistTracker.this.BLACKLIST_TIMEOUT_MILLIS();
            $this.failuresAndExpiryTimes().$plus$eq((Object)new Tuple2((Object)new TaskId($this, stage$1, stageAttempt$1, taskIdx), (Object)BoxesRunTime.boxToLong((long)expiryTime)));
            if (expiryTime < $this.minExpiryTime()) {
                $this.minExpiryTime_$eq(expiryTime);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public static final /* synthetic */ void $anonfun$dropFailuresWithTimeoutBefore$1(long dropBefore$1, LongRef newMinExpiry$1, ArrayBuffer newFailures$1, Tuple2 x0$3) {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                TaskId task = (TaskId)tuple2._1();
                long expiryTime = tuple2._2$mcJ$sp();
                if (expiryTime >= dropBefore$1) {
                    newFailures$1.$plus$eq((Object)new Tuple2((Object)task, (Object)BoxesRunTime.boxToLong((long)expiryTime)));
                    if (expiryTime < newMinExpiry$1.elem) {
                        newMinExpiry$1.elem = expiryTime;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public ExecutorFailureList() {
            if (BlacklistTracker.this == null) {
                throw null;
            }
            Logging.$init$(this);
            this.failuresAndExpiryTimes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.minExpiryTime = Long.MAX_VALUE;
        }

        public class TaskId
        implements Product,
        scala.Serializable {
            private final int stage;
            private final int stageAttempt;
            private final int taskIndex;
            public final /* synthetic */ ExecutorFailureList $outer;

            public int stage() {
                return this.stage;
            }

            public int stageAttempt() {
                return this.stageAttempt;
            }

            public int taskIndex() {
                return this.taskIndex;
            }

            public TaskId copy(int stage, int stageAttempt, int taskIndex) {
                return new TaskId(this.org$apache$spark$scheduler$BlacklistTracker$ExecutorFailureList$TaskId$$$outer(), stage, stageAttempt, taskIndex);
            }

            public int copy$default$1() {
                return this.stage();
            }

            public int copy$default$2() {
                return this.stageAttempt();
            }

            public int copy$default$3() {
                return this.taskIndex();
            }

            public String productPrefix() {
                return "TaskId";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Integer n;
                int n2 = x$1;
                switch (n2) {
                    case 0: {
                        n = BoxesRunTime.boxToInteger((int)this.stage());
                        break;
                    }
                    case 1: {
                        n = BoxesRunTime.boxToInteger((int)this.stageAttempt());
                        break;
                    }
                    case 2: {
                        n = BoxesRunTime.boxToInteger((int)this.taskIndex());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return n;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof TaskId;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.stage());
                n = Statics.mix((int)n, (int)this.stageAttempt());
                n = Statics.mix((int)n, (int)this.taskIndex());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof TaskId)) return false;
                if (((TaskId)object).org$apache$spark$scheduler$BlacklistTracker$ExecutorFailureList$TaskId$$$outer() != this.org$apache$spark$scheduler$BlacklistTracker$ExecutorFailureList$TaskId$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                TaskId taskId = (TaskId)x$1;
                if (this.stage() != taskId.stage()) return false;
                if (this.stageAttempt() != taskId.stageAttempt()) return false;
                if (this.taskIndex() != taskId.taskIndex()) return false;
                if (!taskId.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ ExecutorFailureList org$apache$spark$scheduler$BlacklistTracker$ExecutorFailureList$TaskId$$$outer() {
                return this.$outer;
            }

            public TaskId(ExecutorFailureList $outer, int stage, int stageAttempt, int taskIndex) {
                this.stage = stage;
                this.stageAttempt = stageAttempt;
                this.taskIndex = taskIndex;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

